/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.service;

import jakarta.servlet.ServletContext;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.javaxwrappers.ServletWrapper;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.base.internal.runtime.ServletInfo;
import org.apache.felix.http.base.internal.service.DefaultHttpContext;
import org.apache.felix.http.base.internal.service.HttpResourceServlet;
import org.apache.felix.http.base.internal.service.ServletContextManager;
import org.apache.felix.http.base.internal.service.SharedHttpServiceImpl;
import org.apache.felix.http.base.internal.util.PatternUtil;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

public final class PerBundleHttpServiceImpl
implements HttpService {
    private final Bundle bundle;
    private final Set<Servlet> localServlets = new HashSet<Servlet>();
    private final ServletContextManager contextManager;
    private final SharedHttpServiceImpl sharedHttpService;

    public PerBundleHttpServiceImpl(Bundle bundle, SharedHttpServiceImpl sharedHttpService, ServletContext context, boolean sharedContextAttributes) {
        if (bundle == null) {
            throw new IllegalArgumentException("Bundle cannot be null!");
        }
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null!");
        }
        this.bundle = bundle;
        this.contextManager = new ServletContextManager(this.bundle, context, sharedContextAttributes, sharedHttpService.getHandlerRegistry().getRegistry(-1L));
        this.sharedHttpService = sharedHttpService;
    }

    public HttpContext createDefaultHttpContext() {
        return new DefaultHttpContext(this.bundle);
    }

    public void registerResources(String alias, String name, HttpContext context) throws NamespaceException {
        if (!this.isNameValid(name)) {
            throw new IllegalArgumentException("Malformed resource name [" + name + "]");
        }
        if (!PatternUtil.isValidPattern(alias) || !alias.startsWith("/")) {
            throw new IllegalArgumentException("Malformed resource alias [" + alias + "]");
        }
        try {
            HttpResourceServlet servlet = new HttpResourceServlet(name);
            ServletWrapper wrapper = new ServletWrapper((jakarta.servlet.Servlet)servlet);
            servlet.setWrapper(wrapper);
            this.registerServlet(alias, wrapper, null, context);
        }
        catch (ServletException e) {
            SystemLogger.LOGGER.error("Failed to register resources", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerServlet(String alias, Servlet servlet, Dictionary initParams, HttpContext context) throws ServletException, NamespaceException {
        Object e;
        if (servlet == null) {
            throw new IllegalArgumentException("Servlet must not be null");
        }
        if (!PatternUtil.isValidPattern(alias) || !alias.startsWith("/")) {
            throw new IllegalArgumentException("Malformed servlet alias [" + alias + "]");
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (initParams != null && initParams.size() > 0) {
            e = initParams.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                Object value = initParams.get(key);
                if (!(key instanceof String) || !(value instanceof String)) continue;
                paramMap.put((String)key, (String)value);
            }
        }
        e = this.localServlets;
        synchronized (e) {
            if (this.localServlets.contains(servlet)) {
                throw new ServletException("Servlet instance " + servlet + " already registered");
            }
            this.localServlets.add(servlet);
        }
        ServletInfo servletInfo = new ServletInfo(String.format("%s_%d", servlet.getClass(), this.hashCode()), alias, paramMap);
        ExtServletContext httpContext = this.getServletContext(context);
        boolean success = false;
        try {
            this.sharedHttpService.registerServlet(alias, httpContext, servlet, servletInfo);
            success = true;
        }
        finally {
            if (!success) {
                Set<Servlet> set = this.localServlets;
                synchronized (set) {
                    this.localServlets.remove(servlet);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(String alias) {
        Servlet servlet = this.sharedHttpService.unregister(alias);
        if (servlet != null) {
            Set<Servlet> set = this.localServlets;
            synchronized (set) {
                this.localServlets.remove(servlet);
            }
        }
    }

    public void unregisterAll() {
        HashSet<Servlet> servlets = new HashSet<Servlet>(this.localServlets);
        for (Servlet servlet : servlets) {
            this.unregisterServlet(servlet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterServlet(Servlet servlet) {
        if (servlet != null) {
            Set<Servlet> set = this.localServlets;
            synchronized (set) {
                this.localServlets.remove(servlet);
            }
            this.sharedHttpService.unregisterServlet(servlet);
        }
    }

    @NotNull
    public ExtServletContext getServletContext(HttpContext context) {
        if (context == null) {
            context = this.createDefaultHttpContext();
        }
        return this.contextManager.getServletContext(context);
    }

    private boolean isNameValid(String name) {
        if (name == null) {
            return false;
        }
        return name.equals("/") || !name.endsWith("/");
    }
}

