/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.service;

import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.felix.http.base.internal.registry.HandlerRegistry;
import org.apache.felix.http.base.internal.runtime.dto.RequestInfoDTOBuilder;
import org.apache.felix.http.base.internal.runtime.dto.RuntimeDTOBuilder;
import org.apache.felix.http.base.internal.whiteboard.WhiteboardManager;
import org.apache.felix.http.base.internal.wrappers.RuntimeServiceWrapper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.dto.ServiceReferenceDTO;
import org.osgi.service.servlet.runtime.HttpServiceRuntime;
import org.osgi.service.servlet.runtime.dto.RequestInfoDTO;
import org.osgi.service.servlet.runtime.dto.RuntimeDTO;

public final class HttpServiceRuntimeImpl
implements HttpServiceRuntime {
    private static final String PROP_CHANGECOUNT = "service.changecount";
    private static final String PROP_CHANGECOUNTDELAY = "org.apache.felix.http.whiteboard.changecount.delay";
    private volatile Hashtable<String, Object> attributes = new Hashtable();
    private final HandlerRegistry registry;
    private final WhiteboardManager contextManager;
    private volatile ServiceRegistration<HttpServiceRuntime> serviceReg;
    private volatile ServiceRegistration<org.osgi.service.http.runtime.HttpServiceRuntime> javaxServiceReg;
    private final AtomicLong changeCount = new AtomicLong();
    private volatile Timer changeCountTimer;
    private final Object changeCountTimerLock = new Object();
    private final long updateChangeCountDelay;

    public HttpServiceRuntimeImpl(HandlerRegistry registry, WhiteboardManager contextManager, BundleContext bundleContext) {
        this.registry = registry;
        this.contextManager = contextManager;
        String val = bundleContext.getProperty(PROP_CHANGECOUNTDELAY);
        long value = 2000L;
        if (val != null) {
            try {
                value = Long.parseLong(val.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (value < 1L) {
                value = 0L;
            }
        }
        this.updateChangeCountDelay = value;
    }

    public RuntimeDTO getRuntimeDTO() {
        ServiceRegistration<HttpServiceRuntime> reg = this.serviceReg;
        if (reg != null) {
            RuntimeDTOBuilder runtimeDTOBuilder = new RuntimeDTOBuilder(this.contextManager.getRuntimeInfo(), (ServiceReferenceDTO)reg.getReference().adapt(ServiceReferenceDTO.class));
            return runtimeDTOBuilder.build();
        }
        throw new IllegalStateException("Service is already unregistered");
    }

    public RequestInfoDTO calculateRequestInfoDTO(String path) {
        return new RequestInfoDTOBuilder(this.registry, path).build();
    }

    public synchronized void setAttribute(String name, Object value) {
        Hashtable<String, Object> newAttributes = new Hashtable<String, Object>(this.attributes);
        newAttributes.put(name, value);
        this.attributes = newAttributes;
    }

    public synchronized void setAllAttributes(Dictionary<String, Object> newAttributes) {
        Hashtable<String, Object> replacement = new Hashtable<String, Object>();
        for (String key : Collections.list(newAttributes.keys())) {
            replacement.put(key, newAttributes.get(key));
        }
        replacement.put(PROP_CHANGECOUNT, this.changeCount);
        this.attributes = replacement;
    }

    public void register(BundleContext bundleContext) {
        this.serviceReg = bundleContext.registerService(HttpServiceRuntime.class, (Object)this, this.attributes);
        RuntimeServiceWrapper wrapper = new RuntimeServiceWrapper(this);
        this.javaxServiceReg = bundleContext.registerService(org.osgi.service.http.runtime.HttpServiceRuntime.class, (Object)wrapper, this.attributes);
        wrapper.setServiceReference((ServiceReference<org.osgi.service.http.runtime.HttpServiceRuntime>)this.javaxServiceReg.getReference());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() {
        if (this.serviceReg != null) {
            try {
                this.serviceReg.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            Object object = this.changeCountTimerLock;
            synchronized (object) {
                if (this.changeCountTimer != null) {
                    this.changeCountTimer.cancel();
                    this.changeCountTimer = null;
                }
            }
            this.serviceReg = null;
        }
        if (this.javaxServiceReg != null) {
            try {
                this.javaxServiceReg.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.javaxServiceReg = null;
        }
    }

    public ServiceReference<HttpServiceRuntime> getServiceReference() {
        ServiceRegistration<HttpServiceRuntime> reg = this.serviceReg;
        if (reg != null) {
            return reg.getReference();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateChangeCount() {
        final ServiceRegistration<HttpServiceRuntime> reg = this.serviceReg;
        final ServiceRegistration<org.osgi.service.http.runtime.HttpServiceRuntime> javaxReg = this.javaxServiceReg;
        if (reg != null && javaxReg != null) {
            final long count = this.changeCount.incrementAndGet();
            this.setAttribute(PROP_CHANGECOUNT, this.changeCount.get());
            if (this.updateChangeCountDelay <= 0L) {
                try {
                    reg.setProperties(this.attributes);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    javaxReg.setProperties(this.attributes);
                }
                catch (IllegalStateException illegalStateException) {}
            } else {
                Timer timer;
                Object object = this.changeCountTimerLock;
                synchronized (object) {
                    if (this.changeCountTimer == null) {
                        this.changeCountTimer = new Timer("Apache Felix Http Runtime Timer", true);
                    }
                    timer = this.changeCountTimer;
                }
                try {
                    timer.schedule(new TimerTask(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            if (HttpServiceRuntimeImpl.this.changeCount.get() == count) {
                                try {
                                    reg.setProperties(HttpServiceRuntimeImpl.this.attributes);
                                }
                                catch (IllegalStateException illegalStateException) {
                                    // empty catch block
                                }
                                try {
                                    javaxReg.setProperties(HttpServiceRuntimeImpl.this.attributes);
                                }
                                catch (IllegalStateException illegalStateException) {
                                    // empty catch block
                                }
                                Object object = HttpServiceRuntimeImpl.this.changeCountTimerLock;
                                synchronized (object) {
                                    if (HttpServiceRuntimeImpl.this.changeCount.get() == count && HttpServiceRuntimeImpl.this.changeCountTimer != null) {
                                        HttpServiceRuntimeImpl.this.changeCountTimer.cancel();
                                        HttpServiceRuntimeImpl.this.changeCountTimer = null;
                                    }
                                }
                            }
                        }
                    }, this.updateChangeCountDelay);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

