/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.logger;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.felix.http.base.internal.logger.AbstractLogger;
import org.apache.felix.http.base.internal.logger.LogServiceLogger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class JDK14Logger
extends AbstractLogger {
    private final Logger defaultLogger = Logger.getLogger(LogServiceLogger.class.getName());
    private final Level defaultLevel = Level.OFF;
    private BundleContext context;

    public JDK14Logger(BundleContext context) {
        this.context = context;
    }

    public void log(ServiceReference ref, int level, String message, Throwable cause) {
        Object service = null;
        Class<?> clazz = null;
        Logger logger = null;
        if (ref != null) {
            service = this.context.getService(ref);
        }
        if (service != null) {
            clazz = service.getClass();
        }
        logger = clazz != null ? Logger.getLogger(clazz.getName()) : this.defaultLogger;
        Level logLevel = this.defaultLevel;
        switch (level) {
            case 4: {
                logLevel = Level.FINE;
                break;
            }
            case 3: {
                logLevel = Level.INFO;
                break;
            }
            case 2: {
                logLevel = Level.WARNING;
                break;
            }
            case 1: {
                logLevel = Level.SEVERE;
            }
        }
        if (cause != null) {
            logger.log(logLevel, message, cause);
        } else {
            logger.log(logLevel, message);
        }
    }
}

