/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.dispatch;

import java.io.IOException;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.dispatch.InvocationChain;
import org.apache.felix.http.base.internal.dispatch.RequestInfo;
import org.apache.felix.http.base.internal.dispatch.ServletRequestWrapper;
import org.apache.felix.http.base.internal.dispatch.ServletResponseWrapper;
import org.apache.felix.http.base.internal.handler.FilterHandler;
import org.apache.felix.http.base.internal.handler.HttpSessionWrapper;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.base.internal.registry.HandlerRegistry;
import org.apache.felix.http.base.internal.registry.PathResolution;
import org.apache.felix.http.base.internal.registry.PerContextHandlerRegistry;
import org.apache.felix.http.base.internal.whiteboard.WhiteboardManager;

public final class Dispatcher {
    private final HandlerRegistry handlerRegistry;
    private volatile WhiteboardManager whiteboardManager;

    public Dispatcher(HandlerRegistry handlerRegistry) {
        this.handlerRegistry = handlerRegistry;
    }

    public void setWhiteboardManager(@CheckForNull WhiteboardManager service) {
        this.whiteboardManager = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String requestURI;
        PathResolution pr;
        String path;
        WhiteboardManager mgr = this.whiteboardManager;
        if (mgr == null) {
            res.sendError(404);
            return;
        }
        HttpSession session = req.getSession(false);
        if (session != null) {
            Set<Long> ids = HttpSessionWrapper.getExpiredSessionContextIds(session);
            mgr.sessionDestroyed(session, ids);
        }
        if ((path = req.getServletPath()) == null) {
            path = "";
        }
        if (req.getPathInfo() != null) {
            path = path.concat(req.getPathInfo());
        }
        PerContextHandlerRegistry errorRegistry = (pr = this.handlerRegistry.resolveServlet(requestURI = path)) != null ? pr.handlerRegistry : this.handlerRegistry.getBestMatchingRegistry(requestURI);
        String servletName = pr != null ? pr.handler.getName() : null;
        ServletResponseWrapper wrappedResponse = new ServletResponseWrapper(req, res, servletName, errorRegistry);
        if (pr == null) {
            wrappedResponse.sendError(404);
            return;
        }
        ExtServletContext servletContext = pr.handler.getContext();
        RequestInfo requestInfo = new RequestInfo(pr.servletPath, pr.pathInfo, null, req.getRequestURI());
        ServletRequestWrapper wrappedRequest = new ServletRequestWrapper(req, servletContext, requestInfo, null, pr.handler.getContextServiceId(), pr.handler.getServletInfo().isAsyncSupported());
        FilterHandler[] filterHandlers = this.handlerRegistry.getFilters(pr, req.getDispatcherType(), pr.requestURI);
        try {
            if (servletContext.getServletRequestListener() != null) {
                servletContext.getServletRequestListener().requestInitialized(new ServletRequestEvent((ServletContext)servletContext, (ServletRequest)wrappedRequest));
            }
            InvocationChain filterChain = new InvocationChain(pr.handler, filterHandlers);
            filterChain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)wrappedResponse);
        }
        catch (Exception e) {
            SystemLogger.error("Exception while processing request to " + requestURI, e);
            req.setAttribute("javax.servlet.error.exception", (Object)e);
            req.setAttribute("javax.servlet.error.exception_type", (Object)e.getClass().getName());
            wrappedResponse.sendError(500);
        }
        finally {
            if (servletContext.getServletRequestListener() != null) {
                servletContext.getServletRequestListener().requestDestroyed(new ServletRequestEvent((ServletContext)servletContext, (ServletRequest)wrappedRequest));
            }
        }
    }
}

