/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.logger;

import org.apache.felix.http.base.internal.logger.AbstractLogger;
import org.apache.felix.http.base.internal.logger.ConsoleLogger;
import org.apache.felix.http.base.internal.logger.JDK14Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public final class LogServiceLogger
extends AbstractLogger {
    private final LogService defaultLogger;
    private final ServiceTracker tracker;
    private static final String JUL_LOGGER = "org.apache.felix.http.log.jul";

    public LogServiceLogger(BundleContext context) {
        String julLogOpt = context.getProperty(JUL_LOGGER);
        if (julLogOpt == null) {
            julLogOpt = System.getProperty(JUL_LOGGER);
        }
        this.defaultLogger = julLogOpt != null ? new JDK14Logger(context) : new ConsoleLogger();
        this.tracker = new ServiceTracker(context, LogService.class.getName(), null);
        this.tracker.open();
    }

    public void close() {
        this.tracker.close();
    }

    public void log(ServiceReference ref, int level, String message, Throwable cause) {
        LogService log = (LogService)this.tracker.getService();
        if (log != null) {
            log.log(ref, level, message, cause);
        } else {
            this.defaultLogger.log(ref, level, message, cause);
        }
    }
}

