/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.service;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.dispatch.RequestDispatcherImpl;
import org.apache.felix.http.base.internal.dispatch.RequestInfo;
import org.apache.felix.http.base.internal.handler.ServletHandler;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.base.internal.registry.PathResolution;
import org.apache.felix.http.base.internal.registry.PerContextHandlerRegistry;
import org.apache.felix.http.base.internal.registry.ServletResolution;
import org.apache.felix.http.base.internal.util.MimeTypes;
import org.apache.felix.http.base.internal.util.UriUtils;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;

public class ServletContextImpl
implements ExtServletContext {
    private final Bundle bundle;
    private final ServletContext context;
    private final HttpContext httpContext;
    private final Map<String, Object> attributes;
    private final PerContextHandlerRegistry handlerRegistry;

    public ServletContextImpl(Bundle bundle, ServletContext context, HttpContext httpContext, boolean sharedAttributes, PerContextHandlerRegistry registry) {
        this.bundle = bundle;
        this.context = context;
        this.httpContext = httpContext;
        this.attributes = sharedAttributes ? null : new ConcurrentHashMap();
        this.handlerRegistry = registry;
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> type) {
        throw new UnsupportedOperationException();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        throw new UnsupportedOperationException();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        throw new UnsupportedOperationException();
    }

    public void addListener(Class<? extends EventListener> type) {
        throw new UnsupportedOperationException();
    }

    public void addListener(String className) {
        throw new UnsupportedOperationException();
    }

    public <T extends EventListener> void addListener(T listener) {
        throw new UnsupportedOperationException();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> type) {
        throw new UnsupportedOperationException();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        throw new UnsupportedOperationException();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        throw new UnsupportedOperationException();
    }

    public <T extends Filter> T createFilter(Class<T> type) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public <T extends EventListener> T createListener(Class<T> type) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public <T extends Servlet> T createServlet(Class<T> type) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public void declareRoles(String ... roleNames) {
        this.context.declareRoles(roleNames);
    }

    public String getVirtualServerName() {
        return this.context.getVirtualServerName();
    }

    public Object getAttribute(String name) {
        return this.attributes != null ? this.attributes.get(name) : this.context.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.attributes != null ? Collections.enumeration(this.attributes.keySet()) : this.context.getAttributeNames();
    }

    public ClassLoader getClassLoader() {
        return this.bundle.getClass().getClassLoader();
    }

    public ServletContext getContext(String uri) {
        return this.context.getContext(uri);
    }

    public String getContextPath() {
        return this.context.getContextPath();
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return this.context.getDefaultSessionTrackingModes();
    }

    public int getEffectiveMajorVersion() {
        return this.context.getEffectiveMajorVersion();
    }

    public int getEffectiveMinorVersion() {
        return this.context.getEffectiveMinorVersion();
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return this.context.getEffectiveSessionTrackingModes();
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        return this.context.getFilterRegistration(filterName);
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return this.context.getFilterRegistrations();
    }

    public String getInitParameter(String name) {
        return this.context.getInitParameter(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return this.context.getInitParameterNames();
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        throw new UnsupportedOperationException();
    }

    public int getMajorVersion() {
        return this.context.getMajorVersion();
    }

    public String getMimeType(String file) {
        String type = this.httpContext.getMimeType(file);
        if (type != null) {
            return type;
        }
        return MimeTypes.get().getByFile(file);
    }

    public int getMinorVersion() {
        return this.context.getMinorVersion();
    }

    public String getRealPath(String name) {
        URL url = this.getResource(name);
        if (url == null) {
            return null;
        }
        return url.toExternalForm();
    }

    public URL getResource(String path) {
        return this.httpContext.getResource(this.normalizeResourcePath(path));
    }

    public InputStream getResourceAsStream(String path) {
        URL res = this.getResource(path);
        if (res != null) {
            try {
                return res.openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public Set<String> getResourcePaths(String path) {
        Enumeration paths = this.bundle.getEntryPaths(this.normalizePath(path));
        if (paths == null || !paths.hasMoreElements()) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        while (paths.hasMoreElements()) {
            set.add((String)paths.nextElement());
        }
        return set;
    }

    public String getServerInfo() {
        return this.context.getServerInfo();
    }

    public Servlet getServlet(String name) throws ServletException {
        return this.context.getServlet(name);
    }

    public String getServletContextName() {
        return "org.osgi.service.http";
    }

    public Enumeration<String> getServletNames() {
        return this.context.getServletNames();
    }

    public ServletRegistration getServletRegistration(String servletName) {
        return this.context.getServletRegistration(servletName);
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return this.context.getServletRegistrations();
    }

    public Enumeration<Servlet> getServlets() {
        return this.context.getServlets();
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return this.context.getSessionCookieConfig();
    }

    @Override
    public HttpSessionListener getHttpSessionListener() {
        return this.handlerRegistry.getEventListenerRegistry();
    }

    @Override
    public HttpSessionAttributeListener getHttpSessionAttributeListener() {
        return this.handlerRegistry.getEventListenerRegistry();
    }

    @Override
    public ServletRequestListener getServletRequestListener() {
        return this.handlerRegistry.getEventListenerRegistry();
    }

    @Override
    public ServletRequestAttributeListener getServletRequestAttributeListener() {
        return this.handlerRegistry.getEventListenerRegistry();
    }

    @Override
    public boolean handleSecurity(HttpServletRequest req, HttpServletResponse res) throws IOException {
        return this.httpContext.handleSecurity(req, res);
    }

    @Override
    public void finishSecurity(HttpServletRequest req, HttpServletResponse res) {
    }

    public void log(Exception cause, String message) {
        SystemLogger.error(message, cause);
    }

    public void log(String message) {
        SystemLogger.info(message);
    }

    public void log(String message, Throwable cause) {
        SystemLogger.error(message, cause);
    }

    public void removeAttribute(String name) {
        Object oldValue;
        if (this.attributes != null) {
            oldValue = this.attributes.remove(name);
        } else {
            oldValue = this.context.getAttribute(name);
            this.context.removeAttribute(name);
        }
        if (oldValue != null) {
            this.handlerRegistry.getEventListenerRegistry().attributeRemoved(new ServletContextAttributeEvent((ServletContext)this, name, oldValue));
        }
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            this.removeAttribute(name);
        } else if (name != null) {
            Object oldValue;
            if (this.attributes != null) {
                oldValue = this.attributes.put(name, value);
            } else {
                oldValue = this.context.getAttribute(name);
                this.context.setAttribute(name, value);
            }
            if (oldValue == null) {
                this.handlerRegistry.getEventListenerRegistry().attributeAdded(new ServletContextAttributeEvent((ServletContext)this, name, value));
            } else {
                this.handlerRegistry.getEventListenerRegistry().attributeReplaced(new ServletContextAttributeEvent((ServletContext)this, name, oldValue));
            }
        }
    }

    public boolean setInitParameter(String name, String value) {
        return this.context.setInitParameter(name, value);
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> modes) {
        this.context.setSessionTrackingModes(modes);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        RequestDispatcherImpl dispatcher;
        if (name == null) {
            return null;
        }
        ServletHandler servletHandler = this.handlerRegistry.resolveServletByName(name);
        if (servletHandler != null) {
            ServletResolution resolution = new ServletResolution();
            resolution.handler = servletHandler;
            resolution.handlerRegistry = this.handlerRegistry;
            RequestInfo requestInfo = new RequestInfo("", null, null, null);
            dispatcher = new RequestDispatcherImpl(resolution, requestInfo);
        } else {
            dispatcher = null;
        }
        return dispatcher;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        RequestDispatcherImpl dispatcher;
        String encodedRequestURI;
        String requestURI;
        PathResolution pathResolution;
        if (path == null || !path.startsWith("/") && !"".equals(path)) {
            return null;
        }
        String query = null;
        int q = 0;
        q = path.indexOf(63);
        if (q > 0) {
            query = path.substring(q + 1);
            path = path.substring(0, q);
        }
        if ((pathResolution = this.handlerRegistry.resolve(requestURI = UriUtils.decodePath(encodedRequestURI = path == null ? "" : UriUtils.removeDotSegments(path)))) != null) {
            ServletResolution resolution = new ServletResolution();
            resolution.handler = pathResolution.handler;
            resolution.handlerRegistry = this.handlerRegistry;
            RequestInfo requestInfo = new RequestInfo(pathResolution.servletPath, pathResolution.pathInfo, query, UriUtils.concat(this.getContextPath(), encodedRequestURI));
            dispatcher = new RequestDispatcherImpl(resolution, requestInfo);
        } else {
            dispatcher = null;
        }
        return dispatcher;
    }

    private String normalizePath(String path) {
        if (path == null) {
            return null;
        }
        String normalizedPath = this.normalizeResourcePath(path);
        if (normalizedPath.startsWith("/") && normalizedPath.length() > 1) {
            normalizedPath = normalizedPath.substring(1);
        }
        return normalizedPath;
    }

    private String normalizeResourcePath(String path) {
        if (path == null) {
            return null;
        }
        String normalizedPath = path.trim().replaceAll("/+", "/");
        return normalizedPath;
    }
}

