/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.jetty.internal;

import java.util.Dictionary;
import java.util.Properties;
import org.osgi.framework.BundleContext;

public final class JettyConfig {
    private static final String HTTP_PORT = "org.osgi.service.http.port";
    private static final String HTTPS_PORT = "org.osgi.service.http.port.secure";
    private static final String FELIX_HTTP_DEBUG = "org.apache.felix.http.debug";
    private static final String HTTP_DEBUG = "org.apache.felix.http.jetty.debug";
    private static final String FELIX_KEYSTORE = "org.apache.felix.https.keystore";
    private static final String OSCAR_KEYSTORE = "org.ungoverned.osgi.bundle.https.keystore";
    private static final String FELIX_KEYSTORE_PASSWORD = "org.apache.felix.https.keystore.password";
    private static final String OSCAR_KEYSTORE_PASSWORD = "org.ungoverned.osgi.bundle.https.password";
    private static final String FELIX_KEYSTORE_KEY_PASSWORD = "org.apache.felix.https.keystore.key.password";
    private static final String OSCAR_KEYSTORE_KEY_PASSWORD = "org.ungoverned.osgi.bundle.https.key.password";
    private static final String FELIX_HTTPS_ENABLE = "org.apache.felix.https.enable";
    private static final String OSCAR_HTTPS_ENABLE = "org.ungoverned.osgi.bundle.https.enable";
    private static final String FELIX_HTTP_ENABLE = "org.apache.felix.http.enable";
    private static final String FELIX_TRUSTSTORE = "org.apache.felix.https.truststore";
    private static final String FELIX_TRUSTSTORE_PASSWORD = "org.apache.felix.https.truststore.password";
    private static final String FELIX_HTTPS_CLIENT_CERT = "org.apache.felix.https.clientcertificate";
    private final BundleContext context;
    private boolean debug;
    private int httpPort;
    private int httpsPort;
    private String keystore;
    private String password;
    private String keyPassword;
    private boolean useHttps;
    private String truststore;
    private String trustPassword;
    private boolean useHttp;
    private String clientcert;

    public JettyConfig(BundleContext context) {
        this.context = context;
        this.reset();
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isUseHttp() {
        return this.useHttp;
    }

    public boolean isUseHttps() {
        return this.useHttps;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public String getKeystore() {
        return this.keystore;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTruststore() {
        return this.truststore;
    }

    public String getTrustPassword() {
        return this.trustPassword;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public String getClientcert() {
        return this.clientcert;
    }

    public void reset() {
        this.update(null);
    }

    public void update(Dictionary props) {
        if (props == null) {
            props = new Properties();
        }
        this.debug = this.getBooleanProperty(props, FELIX_HTTP_DEBUG, this.getBooleanProperty(props, HTTP_DEBUG, false));
        this.httpPort = this.getIntProperty(props, HTTP_PORT, 8080);
        this.httpsPort = this.getIntProperty(props, HTTPS_PORT, 433);
        this.keystore = this.getProperty(props, FELIX_KEYSTORE, this.context.getProperty(OSCAR_KEYSTORE));
        this.password = this.getProperty(props, FELIX_KEYSTORE_PASSWORD, this.context.getProperty(OSCAR_KEYSTORE_PASSWORD));
        this.keyPassword = this.getProperty(props, FELIX_KEYSTORE_KEY_PASSWORD, this.context.getProperty(OSCAR_KEYSTORE_KEY_PASSWORD));
        this.useHttps = this.getBooleanProperty(props, FELIX_HTTPS_ENABLE, this.getBooleanProperty(props, OSCAR_HTTPS_ENABLE, false));
        this.useHttp = this.getBooleanProperty(props, FELIX_HTTP_ENABLE, true);
        this.truststore = this.getProperty(props, FELIX_TRUSTSTORE, null);
        this.trustPassword = this.getProperty(props, FELIX_TRUSTSTORE_PASSWORD, null);
        this.clientcert = this.getProperty(props, FELIX_HTTPS_CLIENT_CERT, "none");
    }

    private String getProperty(Dictionary props, String name, String defValue) {
        String value = (String)props.get(name);
        if (value == null) {
            value = this.context.getProperty(name);
        }
        return value != null ? value : defValue;
    }

    private boolean getBooleanProperty(Dictionary props, String name, boolean defValue) {
        String value = this.getProperty(props, name, null);
        if (value != null) {
            return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes");
        }
        return defValue;
    }

    private int getIntProperty(Dictionary props, String name, int defValue) {
        try {
            return Integer.parseInt(this.getProperty(props, name, null));
        }
        catch (Exception e) {
            return defValue;
        }
    }
}

