/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.handler;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.handler.AbstractHandler;
import org.apache.felix.http.base.internal.handler.FilterConfigImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilterHandler
extends AbstractHandler
implements Comparable<FilterHandler> {
    private final Filter filter;
    private final String pattern;
    private final int ranking;

    public FilterHandler(ExtServletContext context, Filter filter, String pattern, int ranking) {
        super(context);
        this.filter = filter;
        this.pattern = pattern;
        this.ranking = ranking;
    }

    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void init() throws ServletException {
        String name = "filter_" + this.getId();
        FilterConfigImpl config = new FilterConfigImpl(name, this.getContext(), this.getInitParams());
        this.filter.init(config);
    }

    @Override
    public void destroy() {
        this.filter.destroy();
    }

    public boolean matches(String uri) {
        return uri.matches(this.pattern);
    }

    public void handle(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws ServletException, IOException {
        boolean matches = this.matches(req.getPathInfo());
        if (matches) {
            this.doHandle(req, res, chain);
        } else {
            chain.doFilter(req, res);
        }
    }

    private void doHandle(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws ServletException, IOException {
        if (!this.getContext().handleSecurity(req, res)) {
            res.sendError(403);
        } else {
            this.filter.doFilter(req, res, chain);
        }
    }

    @Override
    public int compareTo(FilterHandler other) {
        return other.ranking - this.ranking;
    }
}

