/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.jetty.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JettyConfig {
    private static final String HTTP_PORT = "org.osgi.service.http.port";
    private static final String HTTPS_PORT = "org.osgi.service.http.port.secure";
    private static final String FELIX_HTTP_DEBUG = "org.apache.felix.http.debug";
    private static final String HTTP_DEBUG = "org.apache.felix.http.jetty.debug";
    private static final String FELIX_KEYSTORE = "org.apache.felix.https.keystore";
    private static final String OSCAR_KEYSTORE = "org.ungoverned.osgi.bundle.https.keystore";
    private static final String FELIX_KEYSTORE_PASSWORD = "org.apache.felix.https.keystore.password";
    private static final String OSCAR_KEYSTORE_PASSWORD = "org.ungoverned.osgi.bundle.https.password";
    private static final String FELIX_KEYSTORE_KEY_PASSWORD = "org.apache.felix.https.keystore.key.password";
    private static final String OSCAR_KEYSTORE_KEY_PASSWORD = "org.ungoverned.osgi.bundle.https.key.password";
    private static final String FELIX_HTTPS_ENABLE = "org.apache.felix.https.enable";
    private static final String OSCAR_HTTPS_ENABLE = "org.ungoverned.osgi.bundle.https.enable";
    private static final String FELIX_HTTP_ENABLE = "org.apache.felix.http.enable";
    private static final String FELIX_TRUSTSTORE = "org.apache.felix.https.truststore";
    private static final String FELIX_TRUSTSTORE_PASSWORD = "org.apache.felix.https.truststore.password";
    private static final String FELIX_HTTPS_CLIENT_CERT = "org.apache.felix.https.clientcertificate";
    public static final String FELIX_HTTP_NIO = "org.apache.felix.http.nio";
    public static final String FELIX_HTTPS_NIO = "org.apache.felix.https.nio";
    private final BundleContext context;
    private boolean debug;
    private int httpPort;
    private int httpsPort;
    private String keystore;
    private String password;
    private String keyPassword;
    private boolean useHttps;
    private String truststore;
    private String trustPassword;
    private boolean useHttp;
    private String clientcert;
    private boolean useHttpNio;
    private boolean useHttpsNio;

    public JettyConfig(BundleContext context) {
        this.context = context;
        this.reset();
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isUseHttp() {
        return this.useHttp && this.getHttpPort() > 0;
    }

    public boolean isUseHttpNio() {
        return this.useHttpNio;
    }

    public boolean isUseHttps() {
        return this.useHttps && this.getHttpsPort() > 0;
    }

    public boolean isUseHttpsNio() {
        return this.useHttpsNio;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public String getKeystore() {
        return this.keystore;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTruststore() {
        return this.truststore;
    }

    public String getTrustPassword() {
        return this.trustPassword;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public String getClientcert() {
        return this.clientcert;
    }

    public void reset() {
        this.update(null);
    }

    public void update(Dictionary props) {
        if (props == null) {
            props = new Properties();
        }
        this.debug = this.getBooleanProperty(props, FELIX_HTTP_DEBUG, this.getBooleanProperty(props, HTTP_DEBUG, false));
        this.httpPort = this.getIntProperty(props, HTTP_PORT, 8080);
        this.httpsPort = this.getIntProperty(props, HTTPS_PORT, 433);
        this.keystore = this.getProperty(props, FELIX_KEYSTORE, this.context.getProperty(OSCAR_KEYSTORE));
        this.password = this.getProperty(props, FELIX_KEYSTORE_PASSWORD, this.context.getProperty(OSCAR_KEYSTORE_PASSWORD));
        this.keyPassword = this.getProperty(props, FELIX_KEYSTORE_KEY_PASSWORD, this.context.getProperty(OSCAR_KEYSTORE_KEY_PASSWORD));
        this.useHttps = this.getBooleanProperty(props, FELIX_HTTPS_ENABLE, this.getBooleanProperty(props, OSCAR_HTTPS_ENABLE, false));
        this.useHttp = this.getBooleanProperty(props, FELIX_HTTP_ENABLE, true);
        this.truststore = this.getProperty(props, FELIX_TRUSTSTORE, null);
        this.trustPassword = this.getProperty(props, FELIX_TRUSTSTORE_PASSWORD, null);
        this.clientcert = this.getProperty(props, FELIX_HTTPS_CLIENT_CERT, "none");
        this.useHttpNio = this.getBooleanProperty(props, FELIX_HTTP_NIO, true);
        this.useHttpsNio = this.getBooleanProperty(props, FELIX_HTTPS_NIO, this.useHttpNio);
    }

    private String getProperty(Dictionary props, String name, String defValue) {
        Object value = props.get(name);
        if (value == null) {
            value = this.context.getProperty(name);
        }
        return value != null ? String.valueOf(value) : defValue;
    }

    private boolean getBooleanProperty(Dictionary props, String name, boolean defValue) {
        String value = this.getProperty(props, name, null);
        if (value != null) {
            return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes");
        }
        return defValue;
    }

    private int getIntProperty(Dictionary props, String name, int defValue) {
        try {
            return Integer.parseInt(this.getProperty(props, name, null));
        }
        catch (Exception e) {
            return defValue;
        }
    }

    public void setServiceProperties(Hashtable<String, Object> props) {
        props.put(HTTP_PORT, String.valueOf(this.httpPort));
        props.put(HTTPS_PORT, String.valueOf(this.httpsPort));
        props.put(FELIX_HTTP_ENABLE, String.valueOf(this.useHttp));
        props.put(FELIX_HTTPS_ENABLE, String.valueOf(this.useHttps));
    }
}

