/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.internal.Script;
import org.junit.Assert;
import org.junit.Test;

public class ScriptCallableTest
extends JexlTestCase {
    public ScriptCallableTest() {
        super("ScriptCallableTest");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFuture() throws Exception {
        JexlScript e = this.JEXL.createScript("while(true);");
        FutureTask future = new FutureTask(e.callable(null));
        ExecutorService executor = Executors.newFixedThreadPool(1);
        executor.submit(future);
        Integer t = 42;
        try {
            t = future.get(100L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"should have timed out");
        }
        catch (TimeoutException xtimeout) {
            future.cancel(true);
        }
        finally {
            executor.shutdown();
        }
        Assert.assertTrue((boolean)future.isCancelled());
        Assert.assertEquals((Object)42, (Object)t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCallableCancel() throws Exception {
        List<Runnable> lr;
        Semaphore latch = new Semaphore(0);
        MapContext ctxt = new MapContext();
        ctxt.set("latch", (Object)latch);
        JexlScript e = this.JEXL.createScript("latch.release(); while(true);");
        Script.Callable c = (Script.Callable)e.callable((JexlContext)ctxt);
        Integer t = 42;
        Callable<Object> kc = () -> {
            latch.acquire();
            return c.cancel();
        };
        ExecutorService executor = Executors.newFixedThreadPool(2);
        Future future = executor.submit(c);
        Future<Object> kfc = executor.submit(kc);
        try {
            Assert.assertTrue((boolean)((Boolean)kfc.get()));
            t = future.get();
            Assert.fail((String)"should have been cancelled");
        }
        catch (ExecutionException xexec) {
            Assert.assertTrue((boolean)(xexec.getCause() instanceof JexlException.Cancel));
        }
        finally {
            lr = executor.shutdownNow();
        }
        Assert.assertTrue((boolean)c.isCancelled());
        Assert.assertTrue((lr == null || lr.isEmpty() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCallableCancellation() throws Exception {
        List<Runnable> lr;
        Semaphore latch = new Semaphore(0);
        AtomicBoolean cancel = new AtomicBoolean(false);
        CancellationContext ctxt = new CancellationContext(cancel);
        ctxt.set("latch", latch);
        JexlScript e = this.JEXL.createScript("latch.release(); while(true);");
        Script.Callable c = (Script.Callable)e.callable((JexlContext)ctxt);
        Integer t = 42;
        Callable<Object> kc = () -> {
            latch.acquire();
            return cancel.compareAndSet(false, true);
        };
        ExecutorService executor = Executors.newFixedThreadPool(2);
        Future future = executor.submit(c);
        Future<Object> kfc = executor.submit(kc);
        try {
            Assert.assertTrue((boolean)((Boolean)kfc.get()));
            t = future.get();
            Assert.fail((String)"should have been cancelled");
        }
        catch (ExecutionException xexec) {
            Assert.assertTrue((boolean)(xexec.getCause() instanceof JexlException.Cancel));
        }
        finally {
            lr = executor.shutdownNow();
        }
        Assert.assertTrue((boolean)c.isCancelled());
        Assert.assertTrue((lr == null || lr.isEmpty() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCallableTimeout() throws Exception {
        List<Runnable> lr = null;
        Semaphore latch = new Semaphore(0);
        MapContext ctxt = new MapContext();
        ctxt.set("latch", (Object)latch);
        JexlScript e = this.JEXL.createScript("latch.release(); while(true);");
        Callable c = e.callable((JexlContext)ctxt);
        Integer t = 42;
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Future future = executor.submit(c);
        try {
            latch.acquire();
            t = future.get(100L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"should have timed out");
        }
        catch (TimeoutException xtimeout) {
            future.cancel(true);
        }
        finally {
            lr = executor.shutdownNow();
        }
        Assert.assertTrue((boolean)future.isCancelled());
        Assert.assertEquals((Object)42, (Object)t);
        Assert.assertTrue((boolean)lr.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCallableClosure() throws Exception {
        List<Runnable> lr = null;
        JexlScript e = this.JEXL.createScript("function(t) {while(t);}");
        Callable c = e.callable(null, new Object[]{Boolean.TRUE});
        Integer t = 42;
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Future future = executor.submit(c);
        try {
            t = future.get(100L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"should have timed out");
        }
        catch (TimeoutException xtimeout) {
            future.cancel(true);
        }
        finally {
            lr = executor.shutdownNow();
        }
        Assert.assertTrue((boolean)future.isCancelled());
        Assert.assertEquals((Object)42, (Object)t);
        Assert.assertTrue((boolean)lr.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoWait() throws Exception {
        List<Runnable> lr = null;
        JexlScript e = this.JEXL.createScript("wait(0)");
        Callable c = e.callable((JexlContext)new TestContext());
        ExecutorService executor = Executors.newFixedThreadPool(1);
        try {
            Future future = executor.submit(c);
            Object t = future.get(2L, TimeUnit.SECONDS);
            Assert.assertTrue((boolean)future.isDone());
            Assert.assertEquals((Object)0, t);
        }
        finally {
            lr = executor.shutdownNow();
        }
        Assert.assertTrue((boolean)lr.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWait() throws Exception {
        List<Runnable> lr = null;
        JexlScript e = this.JEXL.createScript("wait(1)");
        Callable c = e.callable((JexlContext)new TestContext());
        ExecutorService executor = Executors.newFixedThreadPool(1);
        try {
            Future future = executor.submit(c);
            Object t = future.get(2L, TimeUnit.SECONDS);
            Assert.assertEquals((Object)1, t);
        }
        finally {
            lr = executor.shutdownNow();
        }
        Assert.assertTrue((boolean)lr.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelWait() throws Exception {
        List<Runnable> lr = null;
        JexlScript e = this.JEXL.createScript("wait(10)");
        Callable c = e.callable((JexlContext)new TestContext());
        ExecutorService executor = Executors.newFixedThreadPool(1);
        try {
            Future future = executor.submit(c);
            Integer t = 42;
            try {
                t = future.get(100L, TimeUnit.MILLISECONDS);
                Assert.fail((String)"should have timed out");
            }
            catch (TimeoutException xtimeout) {
                future.cancel(true);
            }
            Assert.assertTrue((boolean)future.isCancelled());
            Assert.assertEquals((Object)42, (Object)t);
        }
        finally {
            lr = executor.shutdownNow();
        }
        Assert.assertTrue((boolean)lr.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelWaitInterrupt() throws Exception {
        List<Runnable> lr = null;
        JexlScript e = this.JEXL.createScript("waitInterrupt(42)");
        Callable c = e.callable((JexlContext)new TestContext());
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Future future = executor.submit(c);
        Integer t = 42;
        try {
            t = future.get(100L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"should have timed out");
        }
        catch (TimeoutException xtimeout) {
            future.cancel(true);
        }
        finally {
            lr = executor.shutdownNow();
        }
        Assert.assertTrue((boolean)future.isCancelled());
        Assert.assertEquals((Object)42, (Object)t);
        Assert.assertTrue((boolean)lr.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelForever() throws Exception {
        List<Runnable> lr = null;
        Semaphore latch = new Semaphore(0);
        TestContext ctxt = new TestContext();
        ctxt.set("latch", latch);
        JexlScript e = this.JEXL.createScript("latch.release(); runForever()");
        Callable c = e.callable((JexlContext)ctxt);
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Future future = executor.submit(c);
        Integer t = 42;
        try {
            latch.acquire();
            t = future.get(100L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"should have timed out");
        }
        catch (TimeoutException xtimeout) {
            future.cancel(true);
        }
        finally {
            lr = executor.shutdownNow();
        }
        Assert.assertTrue((boolean)future.isCancelled());
        Assert.assertEquals((Object)42, (Object)t);
        Assert.assertTrue((boolean)lr.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelLoopWait() throws Exception {
        List<Runnable> lr = null;
        JexlScript e = this.JEXL.createScript("while (true) { wait(10) }");
        Callable c = e.callable((JexlContext)new TestContext());
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Future future = executor.submit(c);
        Integer t = 42;
        try {
            t = future.get(100L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"should have timed out");
        }
        catch (TimeoutException xtimeout) {
            future.cancel(true);
        }
        finally {
            lr = executor.shutdownNow();
        }
        Assert.assertTrue((boolean)future.isCancelled());
        Assert.assertEquals((Object)42, (Object)t);
        Assert.assertTrue((boolean)lr.isEmpty());
    }

    @Test
    public void testInterruptVerboseStrict() throws Exception {
        this.runInterrupt(new JexlBuilder().silent(false).strict(true).create());
    }

    @Test
    public void testInterruptVerboseLenient() throws Exception {
        this.runInterrupt(new JexlBuilder().silent(false).strict(false).create());
    }

    @Test
    public void testInterruptSilentStrict() throws Exception {
        this.runInterrupt(new JexlBuilder().silent(true).strict(true).create());
    }

    @Test
    public void testInterruptSilentLenient() throws Exception {
        this.runInterrupt(new JexlBuilder().silent(true).strict(false).create());
    }

    @Test
    public void testInterruptCancellable() throws Exception {
        this.runInterrupt(new JexlBuilder().silent(true).strict(true).cancellable(true).create());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInterrupt(JexlEngine jexl) throws Exception {
        List<Runnable> lr = null;
        ExecutorService exec = Executors.newFixedThreadPool(2);
        try {
            JexlScript swhile;
            Object t;
            TestContext ctxt;
            block20: {
                JexlScript ssleep;
                Future f;
                block19: {
                    Script.Callable c;
                    block18: {
                        JexlScript sint;
                        block17: {
                            ctxt = new TestContext();
                            sint = jexl.createScript("interrupt(); return 42");
                            t = null;
                            c = (Script.Callable)sint.callable((JexlContext)ctxt);
                            try {
                                t = c.call();
                                if (c.isCancellable()) {
                                    Assert.fail((String)"should have thrown a Cancel");
                                }
                            }
                            catch (JexlException.Cancel xjexl) {
                                if (c.isCancellable()) break block17;
                                Assert.fail((String)("should not have thrown " + (Object)((Object)xjexl)));
                            }
                        }
                        Assert.assertTrue((boolean)c.isCancelled());
                        Assert.assertNotEquals((Object)42, (Object)t);
                        f = null;
                        c = (Script.Callable)sint.callable((JexlContext)ctxt);
                        try {
                            f = exec.submit(c);
                            t = f.get();
                            if (c.isCancellable()) {
                                Assert.fail((String)"should have thrown a Cancel");
                            }
                        }
                        catch (ExecutionException xexec) {
                            if (c.isCancellable()) break block18;
                            Assert.fail((String)("should not have thrown " + xexec));
                        }
                    }
                    Assert.assertTrue((boolean)c.isCancelled());
                    Assert.assertNotEquals((Object)42, (Object)t);
                    ssleep = jexl.createScript("sleep(30000); return 42");
                    try {
                        f = exec.submit(ssleep.callable((JexlContext)ctxt));
                        t = f.get(100L, TimeUnit.MILLISECONDS);
                        Assert.fail((String)"should timeout");
                    }
                    catch (TimeoutException xtimeout) {
                        if (f == null) break block19;
                        f.cancel(true);
                    }
                }
                Assert.assertNotEquals((Object)42, (Object)t);
                try {
                    Future fc = exec.submit(ssleep.callable((JexlContext)ctxt));
                    Runnable cancels = () -> {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        fc.cancel(true);
                    };
                    exec.submit(cancels);
                    t = f.get(100L, TimeUnit.MILLISECONDS);
                    Assert.fail((String)"should be cancelled");
                }
                catch (CancellationException fc) {
                    // empty catch block
                }
                swhile = jexl.createScript("while(true); return 42");
                try {
                    f = exec.submit(swhile.callable((JexlContext)ctxt));
                    t = f.get(100L, TimeUnit.MILLISECONDS);
                    Assert.fail((String)"should timeout");
                }
                catch (TimeoutException xtimeout) {
                    if (f == null) break block20;
                    f.cancel(true);
                }
            }
            Assert.assertNotEquals((Object)42, (Object)t);
            try {
                Future fc = exec.submit(swhile.callable((JexlContext)ctxt));
                Runnable cancels = () -> {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    fc.cancel(true);
                };
                exec.submit(cancels);
                t = fc.get();
                Assert.fail((String)"should be cancelled");
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
            Assert.assertNotEquals((Object)42, (Object)t);
        }
        finally {
            lr = exec.shutdownNow();
        }
        Assert.assertTrue((boolean)lr.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHangs() throws Exception {
        JexlScript e = this.JEXL.createScript("hangs()");
        Callable c = e.callable((JexlContext)new TestContext());
        ExecutorService executor = Executors.newFixedThreadPool(1);
        try {
            Future future = executor.submit(c);
            Object t = future.get(1L, TimeUnit.SECONDS);
            Assert.fail((String)"hangs should not be solved");
        }
        catch (ExecutionException xexec) {
            Assert.assertTrue((boolean)(xexec.getCause() instanceof JexlException.Method));
        }
        finally {
            executor.shutdown();
        }
    }

    @Test
    public void testTimeout() throws Exception {
        JexlScript script = this.JEXL.createScript("(flag)->{ @timeout(100) { while(flag); return 42 }; 'cancelled' }");
        AnnotationContext ctxt = new AnnotationContext();
        Object result = null;
        try {
            result = script.execute((JexlContext)ctxt, new Object[]{true});
        }
        catch (Exception xany) {
            if (xany.getCause() != null) {
                Assert.fail((String)xany.getCause().toString());
            }
            Assert.fail((String)xany.toString());
        }
        Assert.assertEquals((Object)"cancelled", (Object)result);
        result = script.execute((JexlContext)ctxt, new Object[]{false});
        Assert.assertEquals((Object)42, (Object)result);
        script = this.JEXL.createScript("(flag)->{ @timeout(100, 'cancelled') { while(flag); 42; } }");
        try {
            result = script.execute((JexlContext)ctxt, new Object[]{true});
        }
        catch (Exception xany) {
            Assert.fail((String)xany.toString());
        }
        Assert.assertEquals((Object)"cancelled", (Object)result);
        result = script.execute((JexlContext)ctxt, new Object[]{false});
        Assert.assertEquals((Object)42, (Object)result);
        script = this.JEXL.createScript("@timeout(100) {sleep(1000); 42; } -42;");
        try {
            result = script.execute((JexlContext)ctxt);
        }
        catch (Exception xany) {
            Assert.fail((String)xany.toString());
        }
        Assert.assertEquals((Object)-42, (Object)result);
        script = this.JEXL.createScript("@timeout(100) {sleep(1000); return 42; } return -42;");
        try {
            result = script.execute((JexlContext)ctxt);
        }
        catch (Exception xany) {
            Assert.fail((String)xany.toString());
        }
        Assert.assertEquals((Object)-42, (Object)result);
        script = this.JEXL.createScript("@timeout(1000) {sleep(100); return 42; } return -42;");
        try {
            result = script.execute((JexlContext)ctxt);
        }
        catch (Exception xany) {
            Assert.fail((String)xany.toString());
        }
        Assert.assertEquals((Object)42, (Object)result);
    }

    public static class AnnotationContext
    extends MapContext
    implements JexlContext.AnnotationProcessor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object processAnnotation(String name, Object[] args, Callable<Object> statement) throws Exception {
            if ("timeout".equals(name) && args != null && args.length > 0) {
                Object def;
                long ms = args[0] instanceof Number ? ((Number)args[0]).longValue() : Long.parseLong(args[0].toString());
                Object object = def = args.length > 1 ? args[1] : null;
                if (ms > 0L) {
                    ExecutorService executor = Executors.newFixedThreadPool(1);
                    Future<Object> future = null;
                    try {
                        future = executor.submit(statement);
                        Object object2 = future.get(ms, TimeUnit.MILLISECONDS);
                        return object2;
                    }
                    catch (TimeoutException xtimeout) {
                        if (future != null) {
                            future.cancel(true);
                        }
                    }
                    finally {
                        executor.shutdown();
                    }
                }
                return def;
            }
            return statement.call();
        }

        public void sleep(long ms) throws InterruptedException {
            Thread.sleep(ms);
        }
    }

    public static class TestContext
    extends MapContext
    implements JexlContext.NamespaceResolver {
        public Object resolveNamespace(String name) {
            return name == null ? this : null;
        }

        public int wait(int s) throws InterruptedException {
            Thread.sleep(1000 * s);
            return s;
        }

        public int waitInterrupt(int s) {
            try {
                Thread.sleep(1000 * s);
                return s;
            }
            catch (InterruptedException xint) {
                Thread.currentThread().interrupt();
                return -1;
            }
        }

        public int runForever() {
            while (!Thread.currentThread().isInterrupted()) {
            }
            return 1;
        }

        public int interrupt() throws InterruptedException {
            Thread.currentThread().interrupt();
            return 42;
        }

        public void sleep(long millis) throws InterruptedException {
            Thread.sleep(millis);
        }

        public int hangs(Object t) {
            return 1;
        }
    }

    public static class CancellationContext
    extends MapContext
    implements JexlContext.CancellationHandle {
        private final AtomicBoolean cancellation;

        CancellationContext(AtomicBoolean c) {
            this.cancellation = c;
        }

        public AtomicBoolean getCancellation() {
            return this.cancellation;
        }
    }
}

