/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlEvalContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlOptions;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.ObjectContext;
import org.apache.commons.jexl3.ReadonlyContext;
import org.apache.commons.jexl3.parser.StringParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;

public class VarTest
extends JexlTestCase {
    static final Log LOGGER = LogFactory.getLog((String)VarTest.class.getName());
    public static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");

    public VarTest() {
        super("VarTest");
    }

    @Test
    public void testStrict() throws Exception {
        Object o2;
        JexlEvalContext env = new JexlEvalContext();
        JexlOptions options = env.getEngineOptions();
        ReadonlyContext ctxt = new ReadonlyContext(env, options);
        options.setStrict(true);
        options.setSilent(false);
        options.setSafe(false);
        JexlScript e = this.JEXL.createScript("x");
        try {
            o2 = e.execute((JexlContext)ctxt);
            Assert.fail((String)"should have thrown an unknown var exception");
        }
        catch (JexlException o2) {
            // empty catch block
        }
        e = this.JEXL.createScript("x = 42");
        try {
            o2 = e.execute((JexlContext)ctxt);
            Assert.fail((String)"should have thrown a readonly context exception");
        }
        catch (JexlException o3) {
            // empty catch block
        }
        env.set("x", "fourty-two");
        e = this.JEXL.createScript("x.theAnswerToEverything()");
        try {
            o2 = e.execute((JexlContext)ctxt);
            Assert.fail((String)"should have thrown an unknown method exception");
        }
        catch (JexlException jexlException) {
            // empty catch block
        }
    }

    @Test
    public void testLocalBasic() throws Exception {
        JexlScript e = this.JEXL.createScript("var x; x = 42");
        Object o = e.execute(null);
        Assert.assertEquals((String)"Result is not 42", (Object)new Integer(42), (Object)o);
    }

    @Test
    public void testLocalSimple() throws Exception {
        JexlScript e = this.JEXL.createScript("var x = 21; x + x");
        Object o = e.execute(null);
        Assert.assertEquals((String)"Result is not 42", (Object)new Integer(42), (Object)o);
    }

    @Test
    public void testLocalFor() throws Exception {
        JexlScript e = this.JEXL.createScript("var y  = 0; for(var x : [5, 17, 20]) { y = y + x; } y;");
        Object o = e.execute(null);
        Assert.assertEquals((String)"Result is not 42", (Object)new Integer(42), (Object)o);
    }

    @Test
    public void testLocalForFunc() throws Exception {
        NumbersContext jc = new NumbersContext();
        JexlScript e = this.JEXL.createScript("var y  = 0; for(var x : numbers()) { y = y + x; } y;");
        Object o = e.execute((JexlContext)jc);
        Assert.assertEquals((String)"Result is not 42", (Object)new Integer(42), (Object)o);
    }

    @Test
    public void testLocalForFuncReturn() throws Exception {
        NumbersContext jc = new NumbersContext();
        JexlScript e = this.JEXL.createScript("var y  = 42; for(var x : numbers()) { if (x > 10) return x } y;");
        Object o = e.execute((JexlContext)jc);
        Assert.assertEquals((String)"Result is not 17", (Object)new Integer(17), (Object)o);
        Assert.assertTrue((String)this.toString(e.getVariables()), (boolean)e.getVariables().isEmpty());
    }

    String toString(Set<List<String>> refs) {
        StringBuilder strb = new StringBuilder("{");
        int r = 0;
        for (List<String> strs : refs) {
            if (r++ > 0) {
                strb.append(", ");
            }
            strb.append("{");
            for (int s = 0; s < strs.size(); ++s) {
                if (s > 0) {
                    strb.append(", ");
                }
                strb.append('\"');
                strb.append(strs.get(s));
                strb.append('\"');
            }
            strb.append("}");
        }
        strb.append("}");
        return strb.toString();
    }

    Set<List<String>> mkref(String[][] refs) {
        HashSet<List<String>> set = new HashSet<List<String>>();
        for (String[] ref : refs) {
            set.add(Arrays.asList(ref));
        }
        return set;
    }

    boolean eq(Set<List<String>> lhs, Set<List<String>> rhs) {
        if (lhs.size() != rhs.size()) {
            return false;
        }
        List<String> llhs = this.stringify(lhs);
        List<String> lrhs = this.stringify(rhs);
        for (int s = 0; s < llhs.size(); ++s) {
            String r;
            String l = llhs.get(s);
            if (l.equals(r = lrhs.get(s))) continue;
            return false;
        }
        return true;
    }

    List<String> stringify(Set<List<String>> sls) {
        ArrayList<String> ls = new ArrayList<String>();
        for (List<String> l : sls) {
            StringBuilder strb = new StringBuilder();
            for (String s : l) {
                strb.append(s);
                strb.append('|');
            }
            ls.add(strb.toString());
        }
        ls.sort(null);
        return ls;
    }

    @Test
    public void testRefs() throws Exception {
        JexlScript e = this.JEXL.createScript("a[b]['c']");
        Set vars = e.getVariables();
        Set<List<String>> expect = this.mkref(new String[][]{{"a"}, {"b"}});
        Assert.assertTrue((boolean)this.eq(expect, vars));
        e = this.JEXL.createScript("a.'b + c'");
        vars = e.getVariables();
        expect = this.mkref(new String[][]{{"a", "b + c"}});
        Assert.assertTrue((boolean)this.eq(expect, vars));
        e = this.JEXL.createScript("e[f]");
        vars = e.getVariables();
        expect = this.mkref(new String[][]{{"e"}, {"f"}});
        Assert.assertTrue((boolean)this.eq(expect, vars));
        e = this.JEXL.createScript("e[f][g]");
        vars = e.getVariables();
        expect = this.mkref(new String[][]{{"e"}, {"f"}, {"g"}});
        Assert.assertTrue((boolean)this.eq(expect, vars));
        e = this.JEXL.createScript("e['f'].goo");
        vars = e.getVariables();
        expect = this.mkref(new String[][]{{"e", "f", "goo"}});
        Assert.assertTrue((boolean)this.eq(expect, vars));
        e = this.JEXL.createScript("e['f']");
        vars = e.getVariables();
        expect = this.mkref(new String[][]{{"e", "f"}});
        Assert.assertTrue((boolean)this.eq(expect, vars));
        e = this.JEXL.createScript("e[f]['g']");
        vars = e.getVariables();
        expect = this.mkref(new String[][]{{"e"}, {"f"}});
        Assert.assertTrue((boolean)this.eq(expect, vars));
        e = this.JEXL.createScript("e['f']['g']");
        vars = e.getVariables();
        expect = this.mkref(new String[][]{{"e", "f", "g"}});
        Assert.assertTrue((boolean)this.eq(expect, vars));
        e = this.JEXL.createScript("a['b'].c['d'].e");
        vars = e.getVariables();
        expect = this.mkref(new String[][]{{"a", "b", "c", "d", "e"}});
        Assert.assertTrue((boolean)this.eq(expect, vars));
        e = this.JEXL.createScript("a + b.c + b.c.d + e['f']");
        vars = e.getVariables();
        expect = this.mkref(new String[][]{{"a"}, {"b", "c"}, {"b", "c", "d"}, {"e", "f"}});
        Assert.assertTrue((boolean)this.eq(expect, vars));
        e = this.JEXL.createScript("D[E[F]]");
        vars = e.getVariables();
        expect = this.mkref(new String[][]{{"D"}, {"E"}, {"F"}});
        Assert.assertTrue((boolean)this.eq(expect, vars));
        e = this.JEXL.createScript("D[E[F[G[H]]]]");
        vars = e.getVariables();
        expect = this.mkref(new String[][]{{"D"}, {"E"}, {"F"}, {"G"}, {"H"}});
        Assert.assertTrue((boolean)this.eq(expect, vars));
        e = this.JEXL.createScript(" A + B[C] + D[E[F]] + x[y[z]] ");
        vars = e.getVariables();
        expect = this.mkref(new String[][]{{"A"}, {"B"}, {"C"}, {"D"}, {"E"}, {"F"}, {"x"}, {"y"}, {"z"}});
        Assert.assertTrue((boolean)this.eq(expect, vars));
        e = this.JEXL.createScript(" A + B[C] + D.E['F'] + x[y.z] ");
        vars = e.getVariables();
        expect = this.mkref(new String[][]{{"A"}, {"B"}, {"C"}, {"D", "E", "F"}, {"x"}, {"y", "z"}});
        Assert.assertTrue((boolean)this.eq(expect, vars));
        e = this.JEXL.createScript("(A)");
        vars = e.getVariables();
        expect = this.mkref(new String[][]{{"A"}});
        Assert.assertTrue((boolean)this.eq(expect, vars));
        e = this.JEXL.createScript("not(A)");
        vars = e.getVariables();
        expect = this.mkref(new String[][]{{"A"}});
        Assert.assertTrue((boolean)this.eq(expect, vars));
        e = this.JEXL.createScript("not((A))");
        vars = e.getVariables();
        expect = this.mkref(new String[][]{{"A"}});
        Assert.assertTrue((boolean)this.eq(expect, vars));
        e = this.JEXL.createScript("a[b]['c']");
        vars = e.getVariables();
        expect = this.mkref(new String[][]{{"a"}, {"b"}});
        Assert.assertTrue((boolean)this.eq(expect, vars));
        e = this.JEXL.createScript("a['b'][c]");
        vars = e.getVariables();
        expect = this.mkref(new String[][]{{"a", "b"}, {"c"}});
        Assert.assertTrue((boolean)this.eq(expect, vars));
        e = this.JEXL.createScript("a[b].c");
        vars = e.getVariables();
        expect = this.mkref(new String[][]{{"a"}, {"b"}});
        Assert.assertTrue((boolean)this.eq(expect, vars));
        e = this.JEXL.createScript("a[b].c[d]");
        vars = e.getVariables();
        expect = this.mkref(new String[][]{{"a"}, {"b"}, {"d"}});
        Assert.assertTrue((boolean)this.eq(expect, vars));
        e = this.JEXL.createScript("a[b][e].c[d][f]");
        vars = e.getVariables();
        expect = this.mkref(new String[][]{{"a"}, {"b"}, {"d"}, {"e"}, {"f"}});
        Assert.assertTrue((boolean)this.eq(expect, vars));
    }

    @Test
    public void testVarCollectNotAll() throws Exception {
        JexlEngine jexl = new JexlBuilder().strict(true).silent(false).cache(32).collectAll(false).create();
        JexlScript e = jexl.createScript("a['b'][c]");
        Set vars = e.getVariables();
        Set<List<String>> expect = this.mkref(new String[][]{{"a"}, {"c"}});
        Assert.assertTrue((boolean)this.eq(expect, vars));
        e = jexl.createScript(" A + B[C] + D[E[F]] + x[y[z]] ");
        vars = e.getVariables();
        expect = this.mkref(new String[][]{{"A"}, {"B"}, {"C"}, {"D"}, {"E"}, {"F"}, {"x"}, {"y"}, {"z"}});
        Assert.assertTrue((boolean)this.eq(expect, vars));
        e = jexl.createScript("e['f']['g']");
        vars = e.getVariables();
        expect = this.mkref(new String[][]{{"e"}});
        Assert.assertTrue((boolean)this.eq(expect, vars));
        e = jexl.createScript("a[b][e].c[d][f]");
        vars = e.getVariables();
        expect = this.mkref(new String[][]{{"a"}, {"b"}, {"d"}, {"e"}, {"f"}});
        Assert.assertTrue((boolean)this.eq(expect, vars));
        e = jexl.createScript("a + b.c + b.c.d + e['f']");
        vars = e.getVariables();
        expect = this.mkref(new String[][]{{"a"}, {"b", "c"}, {"b", "c", "d"}, {"e"}});
        Assert.assertTrue((boolean)this.eq(expect, vars));
    }

    @Test
    public void testMix() throws Exception {
        JexlScript e = this.JEXL.createScript("if (x) { y } else { var z = 2 * x}", new String[]{"x"});
        Set vars = e.getVariables();
        String[] parms = e.getParameters();
        String[] locals = e.getLocalVariables();
        Assert.assertTrue((boolean)this.eq(this.mkref(new String[][]{{"y"}}), vars));
        Assert.assertEquals((long)1L, (long)parms.length);
        Assert.assertEquals((Object)"x", (Object)parms[0]);
        Assert.assertEquals((long)1L, (long)locals.length);
        Assert.assertEquals((Object)"z", (Object)locals[0]);
    }

    private static String[] readIdentifiers(String str) {
        ArrayList<String> ids = new ArrayList<String>();
        StringBuilder strb = null;
        String id = null;
        int kind = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (strb == null) {
                if (c != '{' && c != '(' && c != '[') continue;
                strb = new StringBuilder();
                kind = c;
                continue;
            }
            if (id != null && c == ']' || c == ')' || kind != 123 && c == ',' || kind == 123 && c == ':') {
                ids.add(id);
                id = null;
                continue;
            }
            if (c != '\'' && c != '\"') continue;
            strb.append(c);
            int l = StringParser.readString((StringBuilder)strb, (CharSequence)str, (int)(i + 1), (char)c);
            if (l <= 0) continue;
            id = strb.substring(1, strb.length() - 1);
            strb.delete(0, l + 1);
            i = l;
        }
        return ids.toArray(new String[0]);
    }

    @Test
    public void testReferenceLiteral() throws Exception {
        JexlEngine jexld = new JexlBuilder().collectMode(2).create();
        MapContext ctxt = new MapContext();
        ctxt.set("moon.landing", (Object)new VarDate("1969-07-20"));
        JexlScript script = jexld.createScript("moon.landing[['yyyy', 'MM', 'dd']]");
        List result = (List)script.execute((JexlContext)ctxt);
        Assert.assertEquals(Arrays.asList("1969", "7", "20"), (Object)result);
        Set vars = script.getVariables();
        Assert.assertEquals((long)1L, (long)vars.size());
        List var = (List)vars.iterator().next();
        Assert.assertEquals((Object)"moon", var.get(0));
        Assert.assertEquals((Object)"landing", var.get(1));
        Assert.assertArrayEquals((Object[])new String[]{"yyyy", "MM", "dd"}, (Object[])VarTest.readIdentifiers((String)var.get(2)));
        script = jexld.createScript("moon.landing[ { 'yyyy' : 'year', 'MM' : 'month', 'dd' : 'day' } ]");
        Map mapr = (Map)script.execute((JexlContext)ctxt);
        Assert.assertEquals((long)3L, (long)mapr.size());
        Assert.assertEquals((Object)"1969", mapr.get("year"));
        Assert.assertEquals((Object)"7", mapr.get("month"));
        Assert.assertEquals((Object)"20", mapr.get("day"));
        vars = script.getVariables();
        Assert.assertEquals((long)1L, (long)vars.size());
        var = (List)vars.iterator().next();
        Assert.assertEquals((Object)"moon", var.get(0));
        Assert.assertEquals((Object)"landing", var.get(1));
        Assert.assertArrayEquals((Object[])new String[]{"yyyy", "MM", "dd"}, (Object[])VarTest.readIdentifiers((String)var.get(2)));
    }

    @Test
    public void testLiteral() throws Exception {
        JexlBuilder builder = new JexlBuilder().collectMode(2);
        Assert.assertEquals((long)2L, (long)builder.collectMode());
        Assert.assertTrue((boolean)builder.collectAll());
        JexlEngine jexld = builder.create();
        JexlScript e = jexld.createScript("x.y[['z', 't']]");
        Set vars = e.getVariables();
        Assert.assertEquals((long)1L, (long)vars.size());
        Assert.assertTrue((boolean)this.eq(this.mkref(new String[][]{{"x", "y", "[ 'z', 't' ]"}}), vars));
        e = jexld.createScript("x.y[{'z': 't'}]");
        vars = e.getVariables();
        Assert.assertEquals((long)1L, (long)vars.size());
        Assert.assertTrue((boolean)this.eq(this.mkref(new String[][]{{"x", "y", "{ 'z' : 't' }"}}), vars));
        e = jexld.createScript("x.y.'{ \\'z\\' : \\'t\\' }'");
        vars = e.getVariables();
        Assert.assertEquals((long)1L, (long)vars.size());
        Assert.assertTrue((boolean)this.eq(this.mkref(new String[][]{{"x", "y", "{ 'z' : 't' }"}}), vars));
        builder = builder.collectAll(true);
        Assert.assertEquals((long)1L, (long)builder.collectMode());
        Assert.assertTrue((boolean)builder.collectAll());
        jexld = builder.create();
        e = jexld.createScript("x.y[{'z': 't'}]");
        vars = e.getVariables();
        Assert.assertEquals((long)1L, (long)vars.size());
        Assert.assertTrue((boolean)this.eq(this.mkref(new String[][]{{"x", "y"}}), vars));
        e = jexld.createScript("x.y[['z', 't']]");
        vars = e.getVariables();
        Assert.assertEquals((long)1L, (long)vars.size());
        Assert.assertTrue((boolean)this.eq(this.mkref(new String[][]{{"x", "y"}}), vars));
        e = jexld.createScript("x.y['z']");
        vars = e.getVariables();
        Assert.assertEquals((long)1L, (long)vars.size());
        Assert.assertTrue((boolean)this.eq(this.mkref(new String[][]{{"x", "y", "z"}}), vars));
        e = jexld.createScript("x.y[42]");
        vars = e.getVariables();
        Assert.assertEquals((long)1L, (long)vars.size());
        Assert.assertTrue((boolean)this.eq(this.mkref(new String[][]{{"x", "y", "42"}}), vars));
    }

    @Test
    public void testSyntacticVariations() throws Exception {
        JexlScript script = this.JEXL.createScript("sum(TOTAL) - partial.sum() + partial['sub'].avg() - sum(partial.sub)");
        Set vars = script.getVariables();
        Assert.assertEquals((long)3L, (long)vars.size());
    }

    @Test
    public void testObjectContext() throws Exception {
        TheVarContext vars = new TheVarContext();
        ObjectContext jc = new ObjectContext(this.JEXL, (Object)vars);
        try {
            JexlScript script = this.JEXL.createScript("x = 3");
            Object result = script.execute((JexlContext)jc);
            Assert.assertEquals((long)3L, (long)vars.getX());
            Assert.assertEquals((Object)3, (Object)result);
            script = this.JEXL.createScript("x == 3");
            result = script.execute((JexlContext)jc);
            Assert.assertTrue((boolean)((Boolean)result));
            Assert.assertTrue((boolean)jc.has("x"));
            script = this.JEXL.createScript("color = 'blue'");
            result = script.execute((JexlContext)jc);
            Assert.assertEquals((Object)"blue", (Object)vars.getColor());
            Assert.assertEquals((Object)"blue", (Object)result);
            script = this.JEXL.createScript("color == 'blue'");
            result = script.execute((JexlContext)jc);
            Assert.assertTrue((boolean)((Boolean)result));
            Assert.assertTrue((boolean)jc.has("color"));
        }
        catch (JexlException.Method ambiguous) {
            Assert.fail((String)"total() is solvable");
        }
    }

    static {
        SDF.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public static class TheVarContext {
        private int x;
        private String color;

        public void setX(int x) {
            this.x = x;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public int getX() {
            return this.x;
        }

        public String getColor() {
            return this.color;
        }
    }

    public static class VarDate {
        private final Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));

        public VarDate(String date) throws Exception {
            this(SDF.parse(date));
        }

        public VarDate(Date date) {
            this.cal.setTime(date);
            this.cal.setLenient(true);
        }

        public String get(String property) {
            if ("yyyy".equals(property)) {
                return Integer.toString(this.cal.get(1));
            }
            if ("MM".equals(property)) {
                return Integer.toString(this.cal.get(2) + 1);
            }
            if ("dd".equals(property)) {
                return Integer.toString(this.cal.get(5));
            }
            return null;
        }

        public List<String> get(String[] keys) {
            return this.get(Arrays.asList(keys));
        }

        public List<String> get(List<String> keys) {
            ArrayList<String> values = new ArrayList<String>();
            for (String key : keys) {
                String value = this.get(key);
                if (value == null) continue;
                values.add(value);
            }
            return values;
        }

        public Map<String, Object> get(Map<String, String> map) {
            LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String value = this.get(entry.getKey());
                if (value == null) continue;
                values.put(entry.getValue(), value);
            }
            return values;
        }
    }

    public static class NumbersContext
    extends MapContext
    implements JexlContext.NamespaceResolver {
        public Object resolveNamespace(String name) {
            return name == null ? this : null;
        }

        public Object numbers() {
            return new int[]{5, 17, 20};
        }
    }
}

