/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.commons.jexl3.ClassCreatorTest;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;

public class ClassCreator {
    private final File base;
    private File packageDir = null;
    private int seed = 0;
    private String ctorBody = "";
    private String className = null;
    private String sourceName = null;
    private ClassLoader loader = null;
    public static final boolean canRun = true;
    static final String JEXL_PACKAGE = "org.apache.commons.jexl3";
    static final String GEN_PACKAGE = "org.apache.commons.jexl3.generated";
    static final String GEN_PATH = "/" + "org.apache.commons.jexl3.generated".replace(".", "/");
    static final String GEN_CLASS = "org.apache.commons.jexl3.generated.";

    private static boolean comSunToolsJavacMain() {
        try {
            Class<?> javac = ClassCreatorTest.class.getClassLoader().loadClass("com.sun.tools.javac.Main");
            return javac != null;
        }
        catch (Exception xany) {
            return false;
        }
    }

    public ClassCreator(JexlEngine theJexl, File theBase) throws Exception {
        this.base = theBase;
    }

    public void clear() {
        this.seed = 0;
        this.ctorBody = "";
        this.packageDir = null;
        this.className = null;
        this.sourceName = null;
        this.packageDir = null;
        this.loader = null;
    }

    public void setSeed(int s) {
        this.seed = s;
        this.className = "foo" + s;
        this.sourceName = this.className + ".java";
        this.packageDir = new File(this.base, this.seed + GEN_PATH);
        this.packageDir.mkdirs();
        this.loader = null;
    }

    public void setCtorBody(String arg) {
        this.ctorBody = arg;
    }

    public String getClassName() {
        return GEN_CLASS + this.className;
    }

    public Class<?> getClassInstance() throws Exception {
        return this.getClassLoader().loadClass(this.getClassName());
    }

    public ClassLoader getClassLoader() throws Exception {
        if (this.loader == null) {
            URL classpath = new File(this.base, Integer.toString(this.seed)).toURI().toURL();
            this.loader = new URLClassLoader(new URL[]{classpath}, this.getClass().getClassLoader());
        }
        return this.loader;
    }

    public Class<?> createClass() throws Exception {
        return this.createClass(false);
    }

    public Class<?> createClass(boolean ftor) throws Exception {
        this.generate(ftor);
        Class<?> clazz = this.compile();
        if (clazz == null) {
            throw new Exception("failed to compile foo" + this.seed);
        }
        if (ftor) {
            return clazz;
        }
        Object v = this.validate(clazz);
        if (v instanceof Integer && (Integer)v == this.seed) {
            return clazz;
        }
        throw new Exception("failed to validate foo" + this.seed);
    }

    Object newInstance(Class<?> clazz, JexlContext ctxt) throws Exception {
        return clazz.getConstructor(JexlContext.class).newInstance(ctxt);
    }

    void generate(boolean ftor) throws Exception {
        try (FileWriter writer = new FileWriter(new File(this.packageDir, this.sourceName), false);){
            writer.write("package ");
            writer.write(GEN_PACKAGE);
            writer.write(";\n");
            if (ftor) {
                writer.write("import org.apache.commons.jexl3.JexlContext;");
                writer.write(";\n");
            }
            writer.write("public class " + this.className);
            writer.write(" {\n");
            if (ftor) {
                writer.write("public " + this.className + "(JexlContext ctxt) {\n");
                writer.write(this.ctorBody);
                writer.write(" }\n");
            }
            writer.write("private int value =");
            writer.write(Integer.toString(this.seed));
            writer.write(";\n");
            writer.write(" public void setValue(int v) {");
            writer.write(" value = v;");
            writer.write(" }\n");
            writer.write(" public int getValue() {");
            writer.write(" return value;");
            writer.write(" }\n");
            writer.write(" }\n");
            writer.flush();
        }
    }

    Class<?> compile() throws Exception {
        String source = this.packageDir.getPath() + "/" + this.sourceName;
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnosticsCollector = new DiagnosticCollector();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnosticsCollector, null, null);
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromStrings(Collections.singletonList(source));
        ArrayList<String> options = new ArrayList<String>();
        options.add("-classpath");
        String currentDir = new File(".").getAbsolutePath();
        String classpath = currentDir + File.separator + "target" + File.separator + "classes" + System.getProperty("path.separator") + System.getProperty("surefire.test.class.path");
        options.add(classpath);
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnosticsCollector, options, null, compilationUnits);
        boolean success = task.call();
        fileManager.close();
        if (success) {
            return this.getClassLoader().loadClass(GEN_CLASS + this.className);
        }
        List diagnostics = diagnosticsCollector.getDiagnostics();
        for (Diagnostic diagnostic : diagnostics) {
            System.out.println(diagnostic.getMessage(null));
        }
        return null;
    }

    Object validate(Class<?> clazz) throws Exception {
        Class[] params = new Class[]{};
        Object[] paramsObj = new Object[]{};
        Object iClass = clazz.newInstance();
        Method thisMethod = clazz.getDeclaredMethod("getValue", params);
        return thisMethod.invoke(iClass, paramsObj);
    }
}

