/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.scripting;

import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.introspection.JexlPermissions;
import org.apache.commons.jexl3.scripting.JexlScriptEngine;
import org.apache.commons.jexl3.scripting.JexlScriptEngineFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JexlScriptEngineTest {
    private static final List<String> NAMES = Arrays.asList("JEXL", "Jexl", "jexl", "JEXL2", "Jexl2", "jexl2", "JEXL3", "Jexl3", "jexl3");
    private static final List<String> EXTENSIONS = Arrays.asList("jexl", "jexl2", "jexl3");
    private static final List<String> MIMES = Arrays.asList("application/x-jexl", "application/x-jexl2", "application/x-jexl3");

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
        JexlBuilder.setDefaultPermissions(null);
        JexlScriptEngine.setInstance(null);
        JexlScriptEngine.setPermissions(null);
    }

    @Test
    public void testScriptEngineFactory() throws Exception {
        JexlScriptEngineFactory factory = new JexlScriptEngineFactory();
        Assert.assertEquals((Object)"JEXL Engine", (Object)factory.getParameter("javax.script.engine"));
        Assert.assertEquals((Object)"3.3", (Object)factory.getParameter("javax.script.engine_version"));
        Assert.assertEquals((Object)"JEXL", (Object)factory.getParameter("javax.script.language"));
        Assert.assertEquals((Object)"3.3", (Object)factory.getParameter("javax.script.language_version"));
        Assert.assertNull((Object)factory.getParameter("THREADING"));
        Assert.assertEquals(NAMES, (Object)factory.getParameter("javax.script.name"));
        Assert.assertEquals(EXTENSIONS, (Object)factory.getExtensions());
        Assert.assertEquals(MIMES, (Object)factory.getMimeTypes());
        Assert.assertEquals((Object)"42;", (Object)factory.getProgram(new String[]{"42"}));
        Assert.assertEquals((Object)"str.substring(3,4)", (Object)factory.getMethodCallSyntax("str", "substring", new String[]{"3", "4"}));
    }

    @Test
    public void testScriptingGetBy() throws Exception {
        ScriptEngine engine;
        ScriptEngineManager manager = new ScriptEngineManager();
        Assert.assertNotNull((String)"Manager should not be null", (Object)manager);
        for (String name : NAMES) {
            engine = manager.getEngineByName(name);
            Assert.assertNotNull((String)"Engine should not be null (name)", (Object)engine);
        }
        for (String extension : EXTENSIONS) {
            engine = manager.getEngineByExtension(extension);
            Assert.assertNotNull((String)"Engine should not be null (extension)", (Object)engine);
        }
        for (String mime : MIMES) {
            engine = manager.getEngineByMimeType(mime);
            Assert.assertNotNull((String)"Engine should not be null (mime)", (Object)engine);
        }
    }

    @Test
    public void testScripting() throws Exception {
        ScriptEngineManager manager = new ScriptEngineManager();
        Assert.assertNotNull((String)"Manager should not be null", (Object)manager);
        ScriptEngine engine = manager.getEngineByName("jexl3");
        Integer initialValue = 123;
        Assert.assertEquals((Object)initialValue, (Object)engine.eval("123"));
        Assert.assertEquals((Object)initialValue, (Object)engine.eval("0;123"));
        try {
            Long time2 = (Long)engine.eval("sys=context.class.forName(\"java.lang.System\");now=sys.currentTimeMillis();");
            Assert.fail((String)"default engine no longer accesses System classes");
        }
        catch (ScriptException xscript) {
            JexlException.Method xjexl = (JexlException.Method)xscript.getCause();
            Assert.assertEquals((Object)"forName", (Object)xjexl.getMethod());
        }
        engine.put("value", initialValue);
        Assert.assertEquals((Object)initialValue, (Object)engine.get("value"));
        Integer newValue = 124;
        Assert.assertEquals((Object)newValue, (Object)engine.eval("old=value;value=value+1"));
        Assert.assertEquals((Object)initialValue, (Object)engine.get("old"));
        Assert.assertEquals((Object)newValue, (Object)engine.get("value"));
        Assert.assertEquals((Object)engine.getContext(), (Object)engine.get("context"));
        Assert.assertEquals((Object)engine.getContext().getReader(), (Object)engine.eval("JEXL.in"));
        Assert.assertEquals((Object)engine.getContext().getWriter(), (Object)engine.eval("JEXL.out"));
        Assert.assertEquals((Object)engine.getContext().getErrorWriter(), (Object)engine.eval("JEXL.err"));
        Assert.assertEquals(System.class, (Object)engine.eval("JEXL.System"));
    }

    @Test
    public void testScriptingInstance0() throws Exception {
        JexlScriptEngine.setPermissions((JexlPermissions)JexlPermissions.UNRESTRICTED);
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("jexl3");
        Long time2 = (Long)engine.eval("sys=context.class.forName(\"java.lang.System\");now=sys.currentTimeMillis();");
        Assert.assertTrue((time2 <= System.currentTimeMillis() ? 1 : 0) != 0);
    }

    @Test
    public void testScriptingPermissions1() throws Exception {
        JexlBuilder.setDefaultPermissions((JexlPermissions)JexlPermissions.UNRESTRICTED);
        JexlScriptEngine.setPermissions(null);
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("jexl3");
        Long time2 = (Long)engine.eval("sys=context.class.forName(\"java.lang.System\");now=sys.currentTimeMillis();");
        Assert.assertTrue((time2 <= System.currentTimeMillis() ? 1 : 0) != 0);
    }

    @Test
    public void testNulls() throws Exception {
        ScriptEngineManager manager = new ScriptEngineManager();
        Assert.assertNotNull((String)"Manager should not be null", (Object)manager);
        ScriptEngine engine = manager.getEngineByName("jexl3");
        Assert.assertNotNull((String)"Engine should not be null (name)", (Object)engine);
        Assert.assertNotNull((Object)engine.getFactory());
        try {
            engine.eval((String)null);
            Assert.fail((String)"Should have caused NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            engine.eval((Reader)null);
            Assert.fail((String)"Should have caused NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        ScriptContext ctxt = null;
        try {
            engine.eval((String)null, ctxt);
            Assert.fail((String)"Should have caused NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            engine.eval((Reader)null, ctxt);
            Assert.fail((String)"Should have caused NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testScopes() throws Exception {
        ScriptEngineManager manager = new ScriptEngineManager();
        Assert.assertNotNull((String)"Manager should not be null", (Object)manager);
        ScriptEngine engine = manager.getEngineByName("JEXL");
        Assert.assertNotNull((String)"Engine should not be null (JEXL)", (Object)engine);
        manager.put("global", 1);
        engine.put("local", 10);
        manager.put("both", 7);
        engine.put("both", 7);
        engine.eval("local=local+1");
        engine.eval("global=global+1");
        engine.eval("both=both+1");
        engine.eval("newvar=42;");
        Assert.assertEquals((Object)2, (Object)manager.get("global"));
        Assert.assertEquals((Object)11, (Object)engine.get("local"));
        Assert.assertEquals((Object)7, (Object)manager.get("both"));
        Assert.assertEquals((Object)8, (Object)engine.get("both"));
        Assert.assertEquals((Object)42, (Object)engine.get("newvar"));
        Assert.assertNull((Object)manager.get("newvar"));
    }

    @Test
    public void testErrors() throws Exception {
        ScriptEngineManager manager = new ScriptEngineManager();
        JexlScriptEngine engine = (JexlScriptEngine)manager.getEngineByName("JEXL");
        ScriptContext ctxt = engine.getContext();
        engine.put("errors", (Object)new Errors());
        try {
            engine.eval("errors.npe()");
        }
        catch (ScriptException xscript) {
            Assert.assertTrue((boolean)(xscript.getCause() instanceof NullPointerException));
        }
        try {
            engine.eval("errors.illegal()", ctxt);
        }
        catch (ScriptException xscript) {
            Assert.assertTrue((boolean)(xscript.getCause() instanceof IllegalArgumentException));
        }
        CompiledScript script0 = engine.compile("errors.npe()");
        try {
            script0.eval();
        }
        catch (ScriptException xscript) {
            Assert.assertTrue((boolean)(xscript.getCause() instanceof NullPointerException));
        }
        CompiledScript script1 = engine.compile("errors.illegal()");
        try {
            script1.eval(ctxt);
        }
        catch (ScriptException xscript) {
            Assert.assertTrue((boolean)(xscript.getCause() instanceof IllegalArgumentException));
        }
    }

    @Test
    public void testCompile() throws Exception {
        Object result;
        CompiledScript script0;
        ScriptEngineManager manager = new ScriptEngineManager();
        JexlScriptEngine engine = (JexlScriptEngine)manager.getEngineByName("JEXL");
        ScriptContext ctxt = engine.getContext();
        String str = null;
        String reader = null;
        try {
            script0 = engine.compile(str);
            Assert.fail((String)"should have thrown npe");
        }
        catch (NullPointerException npe) {
            Assert.assertNotNull((Object)npe);
        }
        try {
            script0 = engine.compile(reader);
            Assert.fail((String)"should have thrown npe");
        }
        catch (NullPointerException npe) {
            Assert.assertNotNull((Object)npe);
        }
        try {
            script0 = engine.compile("3 + 4");
            Assert.assertEquals((Object)engine, (Object)script0.getEngine());
            result = script0.eval();
            Assert.assertEquals((Object)7, (Object)result);
            result = script0.eval();
            Assert.assertEquals((Object)7, (Object)result);
        }
        catch (ScriptException xscript) {
            Assert.assertTrue((boolean)(xscript.getCause() instanceof NullPointerException));
        }
        try {
            ctxt.setAttribute("x", 20, 100);
            ctxt.setAttribute("y", 22, 100);
            script0 = engine.compile("x + y");
            result = script0.eval();
            Assert.assertEquals((Object)42, (Object)result);
            ctxt.setAttribute("x", -20, 100);
            ctxt.setAttribute("y", -22, 100);
            result = script0.eval();
            Assert.assertEquals((Object)-42, (Object)result);
        }
        catch (ScriptException xscript) {
            Assert.assertTrue((boolean)(xscript.getCause() instanceof NullPointerException));
        }
    }

    @Test
    public void testDottedNames() throws Exception {
        ScriptEngineManager manager = new ScriptEngineManager();
        Assert.assertNotNull((String)"Manager should not be null", (Object)manager);
        ScriptEngine engine = manager.getEngineByName("JEXL");
        Assert.assertNotNull((String)"Engine should not be null (JEXL)", (Object)engine);
        engine.eval("this.is.a.test=null");
        Assert.assertNull((Object)engine.get("this.is.a.test"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)engine.eval("empty(this.is.a.test)"));
        Object mymap = engine.eval("testmap={ 'key1' : 'value1', 'key2' : 'value2' }");
        Assert.assertTrue((boolean)(mymap instanceof Map));
        Assert.assertEquals((long)2L, (long)((Map)mymap).size());
    }

    @Test
    public void testDirectNew() throws Exception {
        JexlScriptEngine engine = new JexlScriptEngine();
        Integer initialValue = 123;
        Assert.assertEquals((Object)initialValue, (Object)engine.eval("123"));
    }

    public static class Errors {
        public int npe() {
            throw new NullPointerException("jexl");
        }

        public int illegal() {
            throw new IllegalArgumentException("jexl");
        }
    }
}

