/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.util.ArrayList;
import org.apache.commons.validator.routines.DomainValidator;
import org.bitstrings.test.junit.runner.ClassLoaderPerTestRunner;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=ClassLoaderPerTestRunner.class)
public class DomainValidatorStartupTest {
    @Test
    public void testCannotUpdate() {
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_PLUS, (String[])new String[]{"ch"});
        DomainValidator dv = DomainValidator.getInstance();
        Assert.assertNotNull((Object)dv);
        try {
            DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_PLUS, (String[])new String[]{"ch"});
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testInstanceOverride() {
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_PLUS, (String[])new String[]{"gp"});
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_MINUS, (String[])new String[]{"com"});
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.COUNTRY_CODE_PLUS, (String[])new String[]{"cp"});
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.COUNTRY_CODE_MINUS, (String[])new String[]{"ch"});
        DomainValidator validator = DomainValidator.getInstance((boolean)false);
        Assert.assertTrue((boolean)validator.isValidGenericTld("gp"));
        Assert.assertFalse((boolean)validator.isValidGenericTld("com"));
        Assert.assertTrue((boolean)validator.isValidCountryCodeTld("cp"));
        Assert.assertFalse((boolean)validator.isValidCountryCodeTld("ch"));
        ArrayList<DomainValidator.Item> items = new ArrayList<DomainValidator.Item>();
        items.add(new DomainValidator.Item(DomainValidator.ArrayType.GENERIC_MINUS, new String[]{""}));
        items.add(new DomainValidator.Item(DomainValidator.ArrayType.COUNTRY_CODE_MINUS, new String[]{""}));
        validator = DomainValidator.getInstance((boolean)false, items);
        Assert.assertTrue((boolean)validator.isValidGenericTld("gp"));
        Assert.assertTrue((boolean)validator.isValidGenericTld("com"));
        Assert.assertTrue((boolean)validator.isValidCountryCodeTld("cp"));
        Assert.assertTrue((boolean)validator.isValidCountryCodeTld("ch"));
        validator = DomainValidator.getInstance((boolean)false);
        Assert.assertTrue((boolean)validator.isValidGenericTld("gp"));
        Assert.assertFalse((boolean)validator.isValidGenericTld("com"));
        Assert.assertTrue((boolean)validator.isValidCountryCodeTld("cp"));
        Assert.assertFalse((boolean)validator.isValidCountryCodeTld("ch"));
    }

    @Test
    public void testUpdateBaseArrayCC() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.COUNTRY_CODE_RO, (String[])new String[]{"com"}));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)"Cannot update the table: COUNTRY_CODE_RO")));
    }

    @Test
    public void testUpdateBaseArrayGeneric() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_RO, (String[])new String[]{"com"}));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)"Cannot update the table: GENERIC_RO")));
    }

    @Test
    public void testUpdateBaseArrayInfra() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.INFRASTRUCTURE_RO, (String[])new String[]{"com"}));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)"Cannot update the table: INFRASTRUCTURE_RO")));
    }

    @Test
    public void testUpdateBaseArrayLocal() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.LOCAL_RO, (String[])new String[]{"com"}));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)"Cannot update the table: LOCAL_RO")));
    }

    @Test
    public void testUpdateCountryCode1a() {
        DomainValidator validator = DomainValidator.getInstance();
        Assert.assertFalse((boolean)validator.isValidCountryCodeTld("com"));
    }

    @Test
    public void testUpdateCountryCode1b() {
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.COUNTRY_CODE_PLUS, (String[])new String[]{"com"});
        DomainValidator validator = DomainValidator.getInstance();
        Assert.assertTrue((boolean)validator.isValidCountryCodeTld("com"));
    }

    @Test
    public void testUpdateCountryCode2() {
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.COUNTRY_CODE_PLUS, (String[])new String[]{"com"});
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.COUNTRY_CODE_MINUS, (String[])new String[]{"com"});
        DomainValidator validator = DomainValidator.getInstance();
        Assert.assertFalse((boolean)validator.isValidCountryCodeTld("com"));
    }

    @Test
    public void testUpdateCountryCode3a() {
        DomainValidator validator = DomainValidator.getInstance();
        Assert.assertTrue((boolean)validator.isValidCountryCodeTld("ch"));
    }

    @Test
    public void testUpdateCountryCode3b() {
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.COUNTRY_CODE_MINUS, (String[])new String[]{"ch"});
        DomainValidator validator = DomainValidator.getInstance();
        Assert.assertFalse((boolean)validator.isValidCountryCodeTld("ch"));
    }

    @Test
    public void testUpdateCountryCode3c() {
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.COUNTRY_CODE_MINUS, (String[])new String[]{"ch"});
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.COUNTRY_CODE_MINUS, (String[])new String[]{"xx"});
        DomainValidator validator = DomainValidator.getInstance();
        Assert.assertTrue((boolean)validator.isValidCountryCodeTld("ch"));
    }

    @Test
    public void testUpdateGeneric1() {
        DomainValidator validator = DomainValidator.getInstance();
        Assert.assertFalse((boolean)validator.isValidGenericTld("ch"));
    }

    @Test
    public void testUpdateGeneric2() {
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_PLUS, (String[])new String[]{"ch"});
        DomainValidator validator = DomainValidator.getInstance();
        Assert.assertTrue((boolean)validator.isValidGenericTld("ch"));
    }

    @Test
    public void testUpdateGeneric3() {
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_PLUS, (String[])new String[]{"ch"});
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_MINUS, (String[])new String[]{"ch"});
        DomainValidator validator = DomainValidator.getInstance();
        Assert.assertFalse((boolean)validator.isValidGenericTld("ch"));
        Assert.assertTrue((boolean)validator.isValidGenericTld("com"));
    }

    @Test
    public void testUpdateGeneric4() {
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_PLUS, (String[])new String[]{"ch"});
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_MINUS, (String[])new String[]{"ch"});
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_MINUS, (String[])new String[]{"com"});
        DomainValidator validator = DomainValidator.getInstance();
        Assert.assertFalse((boolean)validator.isValidGenericTld("com"));
    }

    @Test
    public void testUpdateGeneric5() {
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_PLUS, (String[])new String[]{"ch"});
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_MINUS, (String[])new String[]{"ch"});
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_MINUS, (String[])new String[]{"com"});
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_MINUS, (String[])new String[]{"xx"});
        DomainValidator validator = DomainValidator.getInstance();
        Assert.assertTrue((boolean)validator.isValidGenericTld("com"));
    }

    @Test
    public void testVALIDATOR_412a() {
        DomainValidator validator = DomainValidator.getInstance();
        Assert.assertFalse((boolean)validator.isValidGenericTld("local"));
        Assert.assertFalse((boolean)validator.isValid("abc.local"));
        Assert.assertFalse((boolean)validator.isValidGenericTld("pvt"));
        Assert.assertFalse((boolean)validator.isValid("abc.pvt"));
    }

    @Test
    public void testVALIDATOR_412b() {
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_PLUS, (String[])new String[]{"local", "pvt"});
        DomainValidator validator = DomainValidator.getInstance();
        Assert.assertTrue((boolean)validator.isValidGenericTld("local"));
        Assert.assertTrue((boolean)validator.isValid("abc.local"));
        Assert.assertTrue((boolean)validator.isValidGenericTld("pvt"));
        Assert.assertTrue((boolean)validator.isValid("abc.pvt"));
    }

    @Test
    public void testVALIDATOR_412c() {
        DomainValidator validator = DomainValidator.getInstance((boolean)true);
        Assert.assertFalse((boolean)validator.isValidLocalTld("local"));
        Assert.assertFalse((boolean)validator.isValid("abc.local"));
        Assert.assertFalse((boolean)validator.isValidLocalTld("pvt"));
        Assert.assertFalse((boolean)validator.isValid("abc.pvt"));
    }

    @Test
    public void testVALIDATOR_412d() {
        DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.LOCAL_PLUS, (String[])new String[]{"local", "pvt"});
        DomainValidator validator = DomainValidator.getInstance((boolean)true);
        Assert.assertTrue((boolean)validator.isValidLocalTld("local"));
        Assert.assertTrue((boolean)validator.isValidLocalTld("pvt"));
        Assert.assertTrue((boolean)validator.isValid("abc.local"));
        Assert.assertTrue((boolean)validator.isValid("abc.pvt"));
    }
}

