/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.IOException;
import org.apache.commons.validator.AbstractCommonTest;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValueBean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.xml.sax.SAXException;

public class ExceptionTest
extends AbstractCommonTest {
    protected static String FORM_KEY = "exceptionForm";
    protected static String ACTION = "raiseException";

    @BeforeEach
    protected void setUp() throws IOException, SAXException {
        this.loadResources("ExceptionTest-config.xml");
    }

    @Test
    public void testValidatorException() {
        ValueBean info = new ValueBean();
        info.setValue("VALIDATOR");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)info);
        try {
            validator.validate();
            Assertions.fail((String)"ValidatorException should occur here!");
        }
        catch (ValidatorException expected) {
            Assertions.assertTrue((boolean)"VALIDATOR-EXCEPTION".equals(expected.getMessage()));
        }
    }

    public void XtestCheckedException() {
        ValueBean info = new ValueBean();
        info.setValue("CHECKED");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)info);
        try {
            validator.validate();
        }
        catch (ValidatorException expected) {
            Assertions.fail((String)"Checked exceptions are not wrapped in ValidatorException in Validator 1.x.");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)"CHECKED-EXCEPTION".equals(e.getMessage()));
        }
    }

    public void XtestRuntimeException() throws ValidatorException {
        ValueBean info = new ValueBean();
        info.setValue("RUNTIME");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)info);
        try {
            validator.validate();
        }
        catch (RuntimeException expected) {
            Assertions.fail((String)"RuntimeExceptions should be treated as validation failures in Validator 1.x.");
        }
    }
}

