/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.text.Format;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.validator.routines.AbstractCalendarValidator;
import org.apache.commons.validator.routines.AbstractCalendarValidatorTest;
import org.apache.commons.validator.routines.CalendarValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CalendarValidatorTest
extends AbstractCalendarValidatorTest {
    private static final int DATE_2005_11_23 = 20051123;
    private static final int TIME_12_03_45 = 120345;
    private CalendarValidator calValidator;

    @BeforeEach
    protected void setUp() {
        this.calValidator = new CalendarValidator();
        this.validator = this.calValidator;
    }

    @Test
    public void testAdjustToTimeZone() {
        Calendar calEST = CalendarValidatorTest.createCalendar(EST, 20051123, 120345);
        Date dateEST = calEST.getTime();
        Calendar calGMT = CalendarValidatorTest.createCalendar(GMT, 20051123, 120345);
        Date dateGMT = calGMT.getTime();
        Calendar calCET = CalendarValidatorTest.createCalendar(EET, 20051123, 120345);
        Date dateCET = calCET.getTime();
        Assertions.assertFalse((dateGMT.getTime() == dateCET.getTime() ? 1 : 0) != 0, (String)"Check GMT != CET");
        Assertions.assertFalse((dateGMT.getTime() == dateEST.getTime() ? 1 : 0) != 0, (String)"Check GMT != EST");
        Assertions.assertFalse((dateCET.getTime() == dateEST.getTime() ? 1 : 0) != 0, (String)"Check CET != EST");
        CalendarValidator.adjustToTimeZone((Calendar)calEST, (TimeZone)GMT);
        Assertions.assertEquals((Object)dateGMT, (Object)calEST.getTime(), (String)"EST to GMT");
        Assertions.assertFalse((dateEST == calEST.getTime() ? 1 : 0) != 0, (String)"Check EST = GMT");
        CalendarValidator.adjustToTimeZone((Calendar)calEST, (TimeZone)EST);
        Assertions.assertEquals((Object)dateEST, (Object)calEST.getTime(), (String)"back to EST");
        Assertions.assertFalse((dateGMT == calEST.getTime() ? 1 : 0) != 0, (String)"Check EST != GMT");
        CalendarValidator.adjustToTimeZone((Calendar)calCET, (TimeZone)GMT);
        Assertions.assertEquals((Object)dateGMT, (Object)calCET.getTime(), (String)"CET to GMT");
        Assertions.assertFalse((dateCET == calCET.getTime() ? 1 : 0) != 0, (String)"Check CET = GMT");
        CalendarValidator.adjustToTimeZone((Calendar)calCET, (TimeZone)EET);
        Assertions.assertEquals((Object)dateCET, (Object)calCET.getTime(), (String)"back to CET");
        Assertions.assertFalse((dateGMT == calCET.getTime() ? 1 : 0) != 0, (String)"Check CET != GMT");
        Calendar calUTC = CalendarValidatorTest.createCalendar(UTC, 20051123, 120345);
        Assertions.assertTrue((boolean)UTC.hasSameRules(GMT), (String)"SAME: UTC = GMT");
        Assertions.assertEquals((Object)calUTC.getTime(), (Object)calGMT.getTime(), (String)"SAME: Check time (A)");
        Assertions.assertFalse((boolean)GMT.equals(calUTC.getTimeZone()), (String)"SAME: Check GMT(A)");
        Assertions.assertTrue((boolean)UTC.equals(calUTC.getTimeZone()), (String)"SAME: Check UTC(A)");
        CalendarValidator.adjustToTimeZone((Calendar)calUTC, (TimeZone)GMT);
        Assertions.assertEquals((Object)calUTC.getTime(), (Object)calGMT.getTime(), (String)"SAME: Check time (B)");
        Assertions.assertTrue((boolean)GMT.equals(calUTC.getTimeZone()), (String)"SAME: Check GMT(B)");
        Assertions.assertFalse((boolean)UTC.equals(calUTC.getTimeZone()), (String)"SAME: Check UTC(B)");
    }

    @Test
    public void testCalendarValidatorMethods() {
        Locale.setDefault(Locale.US);
        Locale locale = Locale.GERMAN;
        String pattern = "yyyy-MM-dd";
        String patternVal = "2005-12-31";
        String germanVal = "31 Dez 2005";
        String germanPattern = "dd MMM yyyy";
        String localeVal = "31.12.2005";
        String defaultVal = "12/31/05";
        String XXXX = "XXXX";
        Date expected = CalendarValidatorTest.createCalendar(null, 20051231, 0).getTime();
        Assertions.assertEquals((Object)expected, (Object)CalendarValidator.getInstance().validate("12/31/05").getTime(), (String)"validate(A) default");
        Assertions.assertEquals((Object)expected, (Object)CalendarValidator.getInstance().validate("31.12.2005", locale).getTime(), (String)"validate(A) locale ");
        Assertions.assertEquals((Object)expected, (Object)CalendarValidator.getInstance().validate("2005-12-31", "yyyy-MM-dd").getTime(), (String)"validate(A) pattern");
        Assertions.assertEquals((Object)expected, (Object)CalendarValidator.getInstance().validate("31 Dez 2005", "dd MMM yyyy", Locale.GERMAN).getTime(), (String)"validate(A) both");
        Assertions.assertTrue((boolean)CalendarValidator.getInstance().isValid("12/31/05"), (String)"isValid(A) default");
        Assertions.assertTrue((boolean)CalendarValidator.getInstance().isValid("31.12.2005", locale), (String)"isValid(A) locale ");
        Assertions.assertTrue((boolean)CalendarValidator.getInstance().isValid("2005-12-31", "yyyy-MM-dd"), (String)"isValid(A) pattern");
        Assertions.assertTrue((boolean)CalendarValidator.getInstance().isValid("31 Dez 2005", "dd MMM yyyy", Locale.GERMAN), (String)"isValid(A) both");
        Assertions.assertNull((Object)CalendarValidator.getInstance().validate("XXXX"), (String)"validate(B) default");
        Assertions.assertNull((Object)CalendarValidator.getInstance().validate("XXXX", locale), (String)"validate(B) locale ");
        Assertions.assertNull((Object)CalendarValidator.getInstance().validate("XXXX", "yyyy-MM-dd"), (String)"validate(B) pattern");
        Assertions.assertNull((Object)CalendarValidator.getInstance().validate("31 Dec 2005", "dd MMM yyyy", Locale.GERMAN), (String)"validate(B) both");
        Assertions.assertFalse((boolean)CalendarValidator.getInstance().isValid("XXXX"), (String)"isValid(B) default");
        Assertions.assertFalse((boolean)CalendarValidator.getInstance().isValid("XXXX", locale), (String)"isValid(B) locale ");
        Assertions.assertFalse((boolean)CalendarValidator.getInstance().isValid("XXXX", "yyyy-MM-dd"), (String)"isValid(B) pattern");
        Assertions.assertFalse((boolean)CalendarValidator.getInstance().isValid("31 Dec 2005", "dd MMM yyyy", Locale.GERMAN), (String)"isValid(B) both");
        TimeZone zone = TimeZone.getDefault().getRawOffset() == EET.getRawOffset() ? EST : EET;
        Date expectedZone = CalendarValidatorTest.createCalendar(zone, 20051231, 0).getTime();
        Assertions.assertFalse((expected.getTime() == expectedZone.getTime() ? 1 : 0) != 0, (String)"default/EET same ");
        Assertions.assertEquals((Object)expectedZone, (Object)CalendarValidator.getInstance().validate("12/31/05", zone).getTime(), (String)"validate(C) default");
        Assertions.assertEquals((Object)expectedZone, (Object)CalendarValidator.getInstance().validate("31.12.2005", locale, zone).getTime(), (String)"validate(C) locale ");
        Assertions.assertEquals((Object)expectedZone, (Object)CalendarValidator.getInstance().validate("2005-12-31", "yyyy-MM-dd", zone).getTime(), (String)"validate(C) pattern");
        Assertions.assertEquals((Object)expectedZone, (Object)CalendarValidator.getInstance().validate("31 Dez 2005", "dd MMM yyyy", Locale.GERMAN, zone).getTime(), (String)"validate(C) both");
    }

    @Test
    public void testCompare() {
        int sameTime = 124522;
        int testDate = 20050823;
        Calendar diffHour = CalendarValidatorTest.createCalendar(GMT, 20050823, 115922);
        Calendar diffMin = CalendarValidatorTest.createCalendar(GMT, 20050823, 124422);
        Calendar diffSec = CalendarValidatorTest.createCalendar(GMT, 20050823, 124521);
        Calendar value = CalendarValidatorTest.createCalendar(GMT, 20050823, 124522);
        Calendar cal20050824 = CalendarValidatorTest.createCalendar(GMT, 20050824, 124522);
        Calendar cal20050822 = CalendarValidatorTest.createCalendar(GMT, 20050822, 124522);
        Calendar cal20050830 = CalendarValidatorTest.createCalendar(GMT, 20050830, 124522);
        Calendar cal20050816 = CalendarValidatorTest.createCalendar(GMT, 20050816, 124522);
        Calendar cal20050901 = CalendarValidatorTest.createCalendar(GMT, 20050901, 124522);
        Calendar cal20050801 = CalendarValidatorTest.createCalendar(GMT, 20050801, 124522);
        Calendar cal20050731 = CalendarValidatorTest.createCalendar(GMT, 20050731, 124522);
        Calendar cal20051101 = CalendarValidatorTest.createCalendar(GMT, 20051101, 124522);
        Calendar cal20051001 = CalendarValidatorTest.createCalendar(GMT, 20051001, 124522);
        Calendar cal20050701 = CalendarValidatorTest.createCalendar(GMT, 20050701, 124522);
        Calendar cal20050630 = CalendarValidatorTest.createCalendar(GMT, 20050630, 124522);
        Calendar cal20060101 = CalendarValidatorTest.createCalendar(GMT, 20060101, 124522);
        Calendar cal20050101 = CalendarValidatorTest.createCalendar(GMT, 20050101, 124522);
        Calendar cal20041231 = CalendarValidatorTest.createCalendar(GMT, 20041231, 124522);
        Assertions.assertEquals((int)1, (int)this.calValidator.compare(value, diffHour, 11), (String)"hour GT");
        Assertions.assertEquals((int)0, (int)this.calValidator.compare(value, diffMin, 11), (String)"hour EQ");
        Assertions.assertEquals((int)1, (int)this.calValidator.compare(value, diffMin, 12), (String)"mins GT");
        Assertions.assertEquals((int)0, (int)this.calValidator.compare(value, diffSec, 12), (String)"mins EQ");
        Assertions.assertEquals((int)1, (int)this.calValidator.compare(value, diffSec, 13), (String)"secs GT");
        Assertions.assertEquals((int)-1, (int)this.calValidator.compareDates(value, cal20050824), (String)"date LT");
        Assertions.assertEquals((int)0, (int)this.calValidator.compareDates(value, diffHour), (String)"date EQ");
        Assertions.assertEquals((int)0, (int)this.calValidator.compare(value, diffHour, 6), (String)"date(B)");
        Assertions.assertEquals((int)1, (int)this.calValidator.compareDates(value, cal20050822), (String)"date GT");
        Assertions.assertEquals((int)-1, (int)this.calValidator.compareWeeks(value, cal20050830), (String)"week LT");
        Assertions.assertEquals((int)0, (int)this.calValidator.compareWeeks(value, cal20050824), (String)"week =1");
        Assertions.assertEquals((int)0, (int)this.calValidator.compareWeeks(value, cal20050822), (String)"week =2");
        Assertions.assertEquals((int)0, (int)this.calValidator.compare(value, cal20050822, 4), (String)"week =3");
        Assertions.assertEquals((int)0, (int)this.calValidator.compareWeeks(value, cal20050822), (String)"week =4");
        Assertions.assertEquals((int)1, (int)this.calValidator.compareWeeks(value, cal20050816), (String)"week GT");
        Assertions.assertEquals((int)-1, (int)this.calValidator.compareMonths(value, cal20050901), (String)"mnth LT");
        Assertions.assertEquals((int)0, (int)this.calValidator.compareMonths(value, cal20050830), (String)"mnth =1");
        Assertions.assertEquals((int)0, (int)this.calValidator.compareMonths(value, cal20050801), (String)"mnth =2");
        Assertions.assertEquals((int)0, (int)this.calValidator.compareMonths(value, cal20050816), (String)"mnth =3");
        Assertions.assertEquals((int)1, (int)this.calValidator.compareMonths(value, cal20050731), (String)"mnth GT");
        Assertions.assertEquals((int)-1, (int)this.calValidator.compareQuarters(value, cal20051101), (String)"qtrA <1");
        Assertions.assertEquals((int)-1, (int)this.calValidator.compareQuarters(value, cal20051001), (String)"qtrA <2");
        Assertions.assertEquals((int)0, (int)this.calValidator.compareQuarters(value, cal20050901), (String)"qtrA =1");
        Assertions.assertEquals((int)0, (int)this.calValidator.compareQuarters(value, cal20050701), (String)"qtrA =2");
        Assertions.assertEquals((int)0, (int)this.calValidator.compareQuarters(value, cal20050731), (String)"qtrA =3");
        Assertions.assertEquals((int)1, (int)this.calValidator.compareQuarters(value, cal20050630), (String)"qtrA GT");
        Assertions.assertEquals((int)-1, (int)this.calValidator.compareQuarters(value, cal20051101, 2), (String)"qtrB LT");
        Assertions.assertEquals((int)0, (int)this.calValidator.compareQuarters(value, cal20051001, 2), (String)"qtrB =1");
        Assertions.assertEquals((int)0, (int)this.calValidator.compareQuarters(value, cal20050901, 2), (String)"qtrB =2");
        Assertions.assertEquals((int)1, (int)this.calValidator.compareQuarters(value, cal20050701, 2), (String)"qtrB =3");
        Assertions.assertEquals((int)1, (int)this.calValidator.compareQuarters(value, cal20050731, 2), (String)"qtrB =4");
        Assertions.assertEquals((int)1, (int)this.calValidator.compareQuarters(value, cal20050630, 2), (String)"qtrB GT");
        Assertions.assertEquals((int)-1, (int)this.calValidator.compareYears(value, cal20060101), (String)"year LT");
        Assertions.assertEquals((int)0, (int)this.calValidator.compareYears(value, cal20050101), (String)"year EQ");
        Assertions.assertEquals((int)1, (int)this.calValidator.compareYears(value, cal20041231), (String)"year GT");
        try {
            this.calValidator.compare(value, value, -1);
            Assertions.fail((String)"Invalid Compare field - expected IllegalArgumentException to be thrown");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)e.getMessage(), (Object)"Invalid field: -1", (String)"check message");
        }
    }

    @Test
    public void testDateTimeStyle() {
        Locale origDefault = Locale.getDefault();
        Locale.setDefault(Locale.UK);
        AbstractCalendarValidator dateTimeValidator = new AbstractCalendarValidator(true, 3, 3){
            private static final long serialVersionUID = 1L;

            protected Object processParsedValue(Object value, Format formatter) {
                return value;
            }
        };
        Assertions.assertTrue((boolean)dateTimeValidator.isValid("31/12/05 14:23"), (String)"validate(A) default");
        Assertions.assertTrue((boolean)dateTimeValidator.isValid("12/31/05 2:23 PM", Locale.US), (String)"validate(A) locale ");
        Locale.setDefault(origDefault);
    }

    @Override
    @Test
    public void testFormat() {
        Locale origDefault = Locale.getDefault();
        Locale.setDefault(Locale.UK);
        Calendar cal20050101 = CalendarValidatorTest.createCalendar(GMT, 20051231, 11500);
        Assertions.assertNull((Object)this.calValidator.format(null), (String)"null");
        Assertions.assertEquals((Object)"31/12/05", (Object)this.calValidator.format((Object)cal20050101), (String)"default");
        Assertions.assertEquals((Object)"12/31/05", (Object)this.calValidator.format((Object)cal20050101, Locale.US), (String)"locale");
        Assertions.assertEquals((Object)this.calValidator.format((Object)cal20050101, "yyyy-MM-dd HH:mm"), (Object)"2005-12-31 01:15", (String)"patternA");
        Assertions.assertEquals((Object)this.calValidator.format((Object)cal20050101, "yyyy-MM-dd z"), (Object)"2005-12-31 GMT", (String)"patternB");
        Assertions.assertEquals((Object)"31 Dez 2005", (Object)this.calValidator.format((Object)cal20050101, "dd MMM yyyy", Locale.GERMAN), (String)"both");
        Assertions.assertEquals((Object)"30/12/05", (Object)this.calValidator.format((Object)cal20050101, EST), (String)"EST default");
        Assertions.assertEquals((Object)"12/30/05", (Object)this.calValidator.format((Object)cal20050101, Locale.US, EST), (String)"EST locale");
        Assertions.assertEquals((Object)this.calValidator.format((Object)cal20050101, "yyyy-MM-dd HH:mm", EST), (Object)"2005-12-30 20:15", (String)"EST patternA");
        Assertions.assertEquals((Object)this.calValidator.format((Object)cal20050101, "yyyy-MM-dd z", EST), (Object)"2005-12-30 EST", (String)"EST patternB");
        Assertions.assertEquals((Object)"30 Dez 2005", (Object)this.calValidator.format((Object)cal20050101, "dd MMM yyyy", Locale.GERMAN, EST), (String)"EST both");
        Locale.setDefault(origDefault);
    }
}

