/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import java.util.ArrayList;
import java.util.List;
import org.apache.groovy.ast.tools.ClassNodeUtils;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.EnumConstantClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;

public class EnumVisitor
extends ClassCodeVisitorSupport {
    private final SourceUnit sourceUnit;

    public EnumVisitor(CompilationUnit cu, SourceUnit su) {
        this.sourceUnit = su;
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    @Override
    public void visitClass(ClassNode node) {
        if (node.isEnum()) {
            this.completeEnum(node);
        }
    }

    private void completeEnum(ClassNode enumClass) {
        FieldNode minValue = null;
        FieldNode maxValue = null;
        FieldNode values = null;
        boolean isAIC = EnumVisitor.isAnonymousInnerClass(enumClass);
        if (!isAIC) {
            ClassNode enumPlain = enumClass.getPlainNodeReference();
            minValue = new FieldNode("MIN_VALUE", 25, enumPlain, enumClass, null);
            maxValue = new FieldNode("MAX_VALUE", 25, enumPlain, enumClass, null);
            values = new FieldNode("$VALUES", 4122, enumPlain.makeArray(), enumClass, null);
            values.setSynthetic(true);
            for (ConstructorNode ctor : enumClass.getDeclaredConstructors()) {
                if (ctor.isSyntheticPublic()) {
                    ctor.setSyntheticPublic(false);
                    ctor.setModifiers((ctor.getModifiers() | 2) & 0xFFFFFFFE);
                    continue;
                }
                if (ctor.isPrivate()) continue;
                this.addError(ctor, "Illegal modifier for the enum constructor; only private is permitted.");
            }
            EnumVisitor.addMethods(enumClass, values, minValue, maxValue);
            EnumVisitor.checkForAbstractMethods(enumClass);
        }
        this.addInit(enumClass, minValue, maxValue, values, isAIC);
    }

    private static void checkForAbstractMethods(ClassNode enumClass) {
        for (MethodNode method : enumClass.getMethods()) {
            if (!method.isAbstract()) continue;
            enumClass.setModifiers(enumClass.getModifiers() | 0x400);
            break;
        }
    }

    private static void addMethods(ClassNode enumClass, FieldNode values, FieldNode minValue, FieldNode maxValue) {
        VariableExpression ordinal;
        boolean hasNext = false;
        boolean hasPrevious = false;
        for (MethodNode methodNode : enumClass.getMethods()) {
            if (methodNode.getName().equals("next") && methodNode.getParameters().length == 0) {
                hasNext = true;
            }
            if (methodNode.getName().equals("previous") && methodNode.getParameters().length == 0) {
                hasPrevious = true;
            }
            if (!hasNext || !hasPrevious) continue;
            break;
        }
        boolean empty = true;
        for (FieldNode f : enumClass.getFields()) {
            if (!f.isEnum()) continue;
            empty = false;
            break;
        }
        ClassNode classNode = enumClass.getPlainNodeReference();
        MethodNode valuesMethod = new MethodNode("values", 25, classNode.makeArray(), Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, null);
        valuesMethod.setSynthetic(true);
        MethodCallExpression cloneCall = GeneralUtils.callX(GeneralUtils.fieldX(values), "clone");
        cloneCall.setMethodTarget(values.getType().getMethod("clone", Parameter.EMPTY_ARRAY));
        valuesMethod.setCode(GeneralUtils.block(GeneralUtils.returnS(cloneCall)));
        ClassNodeUtils.addGeneratedMethod(enumClass, valuesMethod);
        if (!hasNext) {
            MethodNode nextMethod = new MethodNode("next", 1, classNode, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, null);
            nextMethod.setSynthetic(true);
            ordinal = GeneralUtils.localVarX("ordinal", ClassHelper.int_TYPE);
            nextMethod.setCode(empty ? GeneralUtils.block(GeneralUtils.returnS(GeneralUtils.nullX())) : GeneralUtils.block(GeneralUtils.declS(ordinal, GeneralUtils.plusX(GeneralUtils.callThisX("ordinal"), GeneralUtils.constX(1, true))), GeneralUtils.ifS((Expression)GeneralUtils.geX(ordinal, GeneralUtils.propX((Expression)GeneralUtils.fieldX(values), "length")), GeneralUtils.returnS(GeneralUtils.varX(minValue))), GeneralUtils.returnS(GeneralUtils.indexX(GeneralUtils.fieldX(values), ordinal))));
            ClassNodeUtils.addGeneratedMethod(enumClass, nextMethod);
        }
        if (!hasPrevious) {
            MethodNode prevMethod = new MethodNode("previous", 1, classNode, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, null);
            prevMethod.setSynthetic(true);
            ordinal = GeneralUtils.localVarX("ordinal", ClassHelper.int_TYPE);
            prevMethod.setCode(empty ? GeneralUtils.block(GeneralUtils.returnS(GeneralUtils.nullX())) : GeneralUtils.block(GeneralUtils.declS(ordinal, GeneralUtils.minusX(GeneralUtils.callThisX("ordinal"), GeneralUtils.constX(1, true))), GeneralUtils.ifS((Expression)GeneralUtils.ltX(ordinal, GeneralUtils.constX(0, true)), GeneralUtils.returnS(GeneralUtils.varX(maxValue))), GeneralUtils.returnS(GeneralUtils.indexX(GeneralUtils.fieldX(values), ordinal))));
            ClassNodeUtils.addGeneratedMethod(enumClass, prevMethod);
        }
        Parameter stringParameter = GeneralUtils.param(ClassHelper.STRING_TYPE, "name");
        MethodNode valueOfMethod = new MethodNode("valueOf", 9, classNode, GeneralUtils.params(stringParameter), ClassNode.EMPTY_ARRAY, null);
        valueOfMethod.setCode(GeneralUtils.block(GeneralUtils.returnS(GeneralUtils.callX(ClassHelper.Enum_Type, "valueOf", (Expression)GeneralUtils.args(GeneralUtils.classX(enumClass), GeneralUtils.varX("name"))))));
        valueOfMethod.setSynthetic(true);
        ClassNodeUtils.addGeneratedMethod(enumClass, valueOfMethod);
    }

    private void addInit(ClassNode enumClass, FieldNode minValue, FieldNode maxValue, FieldNode values, boolean isAIC) {
        ClassNode enumRef = enumClass.getPlainNodeReference();
        Parameter[] parameter = GeneralUtils.params(GeneralUtils.param(ClassHelper.OBJECT_TYPE.makeArray(), "para"));
        MethodNode initMethod = new MethodNode("$INIT", 4121, enumRef, parameter, ClassNode.EMPTY_ARRAY, null);
        initMethod.setSynthetic(true);
        ConstructorCallExpression cce = GeneralUtils.ctorThisX(GeneralUtils.args(GeneralUtils.spreadX(GeneralUtils.varX("para"))));
        initMethod.setCode(GeneralUtils.block(GeneralUtils.returnS(cce)));
        ClassNodeUtils.addGeneratedMethod(enumClass, initMethod);
        List<FieldNode> fields = enumClass.getFields();
        ArrayList<Expression> arrayInit = new ArrayList<Expression>();
        int value = -1;
        ArrayList<Statement> block = new ArrayList<Statement>();
        FieldNode tempMin = null;
        FieldNode tempMax = null;
        for (FieldNode field : fields) {
            if (!field.isEnum()) continue;
            ++value;
            if (tempMin == null) {
                tempMin = field;
            }
            tempMax = field;
            ClassNode enumBase = enumClass;
            ArgumentListExpression args = GeneralUtils.args(GeneralUtils.constX(field.getName()), GeneralUtils.constX(value));
            if (field.getInitialExpression() == null) {
                if (enumClass.isAbstract()) {
                    this.addError(field, "The enum constant " + field.getName() + " must override abstract methods from " + enumBase.getName() + ".");
                    continue;
                }
            } else {
                ListExpression oldArgs = (ListExpression)field.getInitialExpression();
                ArrayList<MapEntryExpression> savedMapEntries = new ArrayList<MapEntryExpression>();
                for (Expression exp : oldArgs.getExpressions()) {
                    ClassExpression clazzExp;
                    ClassNode ref;
                    if (exp instanceof MapEntryExpression) {
                        savedMapEntries.add((MapEntryExpression)exp);
                        continue;
                    }
                    InnerClassNode inner = null;
                    if (exp instanceof ClassExpression && (ref = (clazzExp = (ClassExpression)exp).getType()) instanceof EnumConstantClassNode) {
                        inner = (InnerClassNode)ref;
                    }
                    if (inner != null) {
                        List<MethodNode> baseMethods = enumBase.getMethods();
                        for (MethodNode methodNode : baseMethods) {
                            MethodNode enumConstMethod;
                            if (!methodNode.isAbstract() || (enumConstMethod = inner.getMethod(methodNode.getName(), methodNode.getParameters())) != null && !enumConstMethod.isAbstract()) continue;
                            this.addError(field, "Can't have an abstract method in enum constant " + field.getName() + ". Implement method '" + methodNode.getTypeDescriptor() + "'.");
                        }
                        if (inner.getVariableScope() == null) {
                            enumBase = inner;
                            initMethod.setModifiers(initMethod.getModifiers() & 0xFFFFFFEF);
                            continue;
                        }
                    }
                    args.addExpression(exp);
                }
                if (!savedMapEntries.isEmpty()) {
                    args.getExpressions().add(2, GeneralUtils.mapX(savedMapEntries));
                }
            }
            field.setInitialValueExpression(null);
            block.add(GeneralUtils.assignS(GeneralUtils.fieldX(field), GeneralUtils.callX(enumBase, "$INIT", (Expression)args)));
            arrayInit.add(GeneralUtils.fieldX(field));
        }
        if (!isAIC) {
            if (tempMin != null) {
                block.add(GeneralUtils.assignS(GeneralUtils.fieldX(minValue), GeneralUtils.fieldX(tempMin)));
                block.add(GeneralUtils.assignS(GeneralUtils.fieldX(maxValue), GeneralUtils.fieldX(tempMax)));
                enumClass.addField(minValue);
                enumClass.addField(maxValue);
            }
            block.add(GeneralUtils.assignS(GeneralUtils.fieldX(values), GeneralUtils.arrayX(enumClass, arrayInit)));
            enumClass.addField(values);
        }
        enumClass.addStaticInitializerStatements(block, true);
    }

    private void addError(AnnotatedNode exp, String msg) {
        this.getSourceUnit().getErrorCollector().addErrorAndContinue(new SyntaxErrorMessage(new SyntaxException(msg + "\n", exp), this.getSourceUnit()));
    }

    static boolean isAnonymousInnerClass(ClassNode enumClass) {
        return enumClass instanceof EnumConstantClassNode && ((EnumConstantClassNode)enumClass).getVariableScope() == null;
    }
}

