/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.exception;

import java.io.IOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.exception.ExceptionHandler;
import org.apache.maven.exception.ExceptionSummary;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemUtils;
import org.apache.maven.plugin.AbstractMojoExecutionException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginContainerException;
import org.apache.maven.plugin.PluginExecutionException;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingResult;

@Named
@Singleton
public class DefaultExceptionHandler
implements ExceptionHandler {
    @Override
    public ExceptionSummary handleException(Throwable exception) {
        return this.handle("", exception);
    }

    private ExceptionSummary handle(String message, Throwable exception) {
        String reference = this.getReference(exception);
        ArrayList<ExceptionSummary> children = null;
        if (exception instanceof ProjectBuildingException) {
            List<ProjectBuildingResult> results = ((ProjectBuildingException)exception).getResults();
            children = new ArrayList<ExceptionSummary>();
            for (ProjectBuildingResult result : results) {
                ExceptionSummary child = this.handle(result);
                if (child == null) continue;
                children.add(child);
            }
            message = "The build could not read " + children.size() + " project" + (children.size() == 1 ? "" : "s");
        } else {
            message = this.getMessage(message, exception);
        }
        return new ExceptionSummary(exception, message, reference, children);
    }

    private ExceptionSummary handle(ProjectBuildingResult result) {
        ArrayList<ExceptionSummary> children = new ArrayList<ExceptionSummary>();
        for (ModelProblem problem : result.getProblems()) {
            ExceptionSummary child = this.handle(problem, result.getProjectId());
            if (child == null) continue;
            children.add(child);
        }
        if (children.isEmpty()) {
            return null;
        }
        String message = System.lineSeparator() + "The project " + (result.getProjectId().isEmpty() ? "" : result.getProjectId() + " ") + "(" + result.getPomFile() + ") has " + children.size() + " error" + (children.size() == 1 ? "" : "s");
        return new ExceptionSummary(null, message, null, children);
    }

    private ExceptionSummary handle(ModelProblem problem, String projectId) {
        if (ModelProblem.Severity.ERROR.compareTo((Enum)problem.getSeverity()) >= 0) {
            String message = problem.getMessage();
            String location = ModelProblemUtils.formatLocation((ModelProblem)problem, (String)projectId);
            if (!location.isEmpty()) {
                message = message + " @ " + location;
            }
            return this.handle(message, problem.getException());
        }
        return null;
    }

    private String getReference(Throwable exception) {
        String reference = "";
        if (exception != null) {
            if (exception instanceof MojoExecutionException) {
                reference = MojoExecutionException.class.getSimpleName();
                Throwable cause = exception.getCause();
                if (cause instanceof IOException && (cause = cause.getCause()) instanceof ConnectException) {
                    reference = ConnectException.class.getSimpleName();
                }
            } else if (exception instanceof MojoFailureException) {
                reference = MojoFailureException.class.getSimpleName();
            } else if (exception instanceof LinkageError) {
                reference = LinkageError.class.getSimpleName();
            } else if (exception instanceof PluginExecutionException) {
                String message;
                Throwable cause2;
                Throwable cause = exception.getCause();
                if (cause instanceof PluginContainerException && (cause2 = cause.getCause()) instanceof NoClassDefFoundError && (message = cause2.getMessage()) != null && message.contains("org/sonatype/aether/")) {
                    reference = "AetherClassNotFound";
                }
                if (reference == null || reference.isEmpty()) {
                    reference = this.getReference(cause);
                }
                if (reference == null || reference.isEmpty()) {
                    reference = exception.getClass().getSimpleName();
                }
            } else if (exception instanceof LifecycleExecutionException) {
                reference = this.getReference(exception.getCause());
            } else if (this.isNoteworthyException(exception)) {
                reference = exception.getClass().getSimpleName();
            }
        }
        if (reference != null && !reference.isEmpty() && !reference.startsWith("http:")) {
            reference = "http://cwiki.apache.org/confluence/display/MAVEN/" + reference;
        }
        return reference;
    }

    private boolean isNoteworthyException(Throwable exception) {
        if (exception == null) {
            return false;
        }
        if (exception instanceof Error) {
            return true;
        }
        if (exception instanceof RuntimeException) {
            return false;
        }
        return !exception.getClass().getName().startsWith("java");
    }

    private String getMessage(String message, Throwable exception) {
        String fullMessage = message != null ? message : "";
        for (Throwable t = exception; t != null; t = t.getCause()) {
            String longMessage;
            String exceptionMessage = t.getMessage();
            if (t instanceof AbstractMojoExecutionException && (longMessage = ((AbstractMojoExecutionException)t).getLongMessage()) != null && !longMessage.isEmpty()) {
                if (exceptionMessage == null || exceptionMessage.isEmpty() || longMessage.contains(exceptionMessage)) {
                    exceptionMessage = longMessage;
                } else if (!exceptionMessage.contains(longMessage)) {
                    exceptionMessage = this.join(exceptionMessage, System.lineSeparator() + longMessage);
                }
            }
            if (exceptionMessage == null || exceptionMessage.isEmpty()) {
                exceptionMessage = t.getClass().getSimpleName();
            }
            if (t instanceof UnknownHostException && !fullMessage.contains("host")) {
                fullMessage = this.join(fullMessage, "Unknown host " + exceptionMessage);
                continue;
            }
            if (fullMessage.contains(exceptionMessage)) continue;
            fullMessage = this.join(fullMessage, exceptionMessage);
        }
        return fullMessage.trim();
    }

    private String join(String message1, String message2) {
        String message = "";
        if (message1 != null && !message1.isEmpty()) {
            message = message1.trim();
        }
        if (message2 != null && !message2.isEmpty()) {
            if (message != null && !message.isEmpty()) {
                message = message.endsWith(".") || message.endsWith("!") || message.endsWith(":") ? message + " " : message + ": ";
            }
            message = message + message2;
        }
        return message;
    }
}

