/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.services.MessageBuilder;
import org.apache.maven.api.services.MessageBuilderFactory;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.internal.xml.XmlNodeImpl;
import org.apache.maven.lifecycle.MojoExecutionConfigurator;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class DefaultMojoExecutionConfigurator
implements MojoExecutionConfigurator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    MessageBuilderFactory messageBuilderFactory;

    @Override
    public void configure(MavenProject project, MojoExecution mojoExecution, boolean allowPluginLevelConfig) {
        String a;
        String g = mojoExecution.getPlugin().getGroupId();
        Plugin plugin = this.findPlugin(g, a = mojoExecution.getPlugin().getArtifactId(), project.getBuildPlugins());
        if (plugin == null && project.getPluginManagement() != null) {
            plugin = this.findPlugin(g, a, project.getPluginManagement().getPlugins());
        }
        if (plugin != null) {
            PluginExecution pluginExecution = this.findPluginExecution(mojoExecution.getExecutionId(), plugin.getExecutions());
            XmlNode pomConfiguration = null;
            if (pluginExecution != null) {
                pomConfiguration = pluginExecution.getDelegate().getConfiguration();
            } else if (allowPluginLevelConfig) {
                pomConfiguration = plugin.getDelegate().getConfiguration();
            }
            XmlNode mojoConfiguration = mojoExecution.getConfiguration() != null ? mojoExecution.getConfiguration().getDom() : null;
            XmlNode mergedConfiguration = XmlNodeImpl.merge((XmlNode)mojoConfiguration, (XmlNode)pomConfiguration);
            mojoExecution.setConfiguration(mergedConfiguration);
            this.checkUnknownMojoConfigurationParameters(mojoExecution);
        }
    }

    private Plugin findPlugin(String groupId, String artifactId, Collection<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            if (!artifactId.equals(plugin.getArtifactId()) || !groupId.equals(plugin.getGroupId())) continue;
            return plugin;
        }
        return null;
    }

    private PluginExecution findPluginExecution(String executionId, Collection<PluginExecution> executions) {
        if (executionId != null && !executionId.isEmpty()) {
            for (PluginExecution execution : executions) {
                if (!executionId.equals(execution.getId())) continue;
                return execution;
            }
        }
        return null;
    }

    private void checkUnknownMojoConfigurationParameters(MojoExecution mojoExecution) {
        if (mojoExecution.getConfiguration() == null || mojoExecution.getConfiguration().getChildCount() == 0) {
            return;
        }
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        Set<String> parametersNamesGoal = mojoDescriptor.getParameters().stream().flatMap(this::getParameterNames).collect(Collectors.toSet());
        Set<String> unknownParameters = this.getUnknownParameters(mojoExecution, parametersNamesGoal);
        if (unknownParameters.isEmpty()) {
            return;
        }
        Set<String> parametersNamesAll = mojoDescriptor.getPluginDescriptor().getMojos().stream().flatMap(m -> m.getParameters().stream()).flatMap(this::getParameterNames).collect(Collectors.toSet());
        unknownParameters = this.getUnknownParameters(mojoExecution, parametersNamesAll);
        unknownParameters.forEach(name -> {
            MessageBuilder messageBuilder = this.messageBuilderFactory.builder().warning((Object)"Parameter '").warning(name).warning((Object)"' is unknown for plugin '").warning((Object)mojoExecution.getArtifactId()).warning((Object)":").warning((Object)mojoExecution.getVersion()).warning((Object)":").warning((Object)mojoExecution.getGoal());
            if (mojoExecution.getExecutionId() != null) {
                messageBuilder.warning((Object)" (");
                messageBuilder.warning((Object)mojoExecution.getExecutionId());
                messageBuilder.warning((Object)")");
            }
            messageBuilder.warning((Object)"'");
            this.logger.warn(messageBuilder.toString());
        });
    }

    private Stream<String> getParameterNames(Parameter parameter) {
        if (parameter.getAlias() != null) {
            return Stream.of(parameter.getName(), parameter.getAlias());
        }
        return Stream.of(parameter.getName());
    }

    private Set<String> getUnknownParameters(MojoExecution mojoExecution, Set<String> parameters) {
        return Arrays.stream(mojoExecution.getConfiguration().getChildren()).map(Xpp3Dom::getName).filter(name -> !parameters.contains(name)).collect(Collectors.toSet());
    }
}

