/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.CyclicDependencyException;
import org.apache.maven.artifact.resolver.ResolutionNode;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;

public class ArtifactResolutionResult {
    private static final String LS = System.lineSeparator();
    private Artifact originatingArtifact;
    private List<Artifact> missingArtifacts;
    private List<Exception> exceptions;
    private List<Exception> versionRangeViolations;
    private List<ArtifactResolutionException> metadataResolutionExceptions;
    private List<CyclicDependencyException> circularDependencyExceptions;
    private List<ArtifactResolutionException> errorArtifactExceptions;
    private List<ArtifactRepository> repositories;
    private Set<Artifact> artifacts;
    private Set<ResolutionNode> resolutionNodes;

    public Artifact getOriginatingArtifact() {
        return this.originatingArtifact;
    }

    public ArtifactResolutionResult setOriginatingArtifact(Artifact originatingArtifact) {
        this.originatingArtifact = originatingArtifact;
        return this;
    }

    public void addArtifact(Artifact artifact) {
        if (this.artifacts == null) {
            this.artifacts = new LinkedHashSet<Artifact>();
        }
        this.artifacts.add(artifact);
    }

    public Set<Artifact> getArtifacts() {
        if (this.artifacts == null) {
            this.artifacts = new LinkedHashSet<Artifact>();
        }
        return this.artifacts;
    }

    public void setArtifacts(Set<Artifact> artifacts) {
        this.artifacts = artifacts;
    }

    public Set<ResolutionNode> getArtifactResolutionNodes() {
        if (this.resolutionNodes == null) {
            this.resolutionNodes = new LinkedHashSet<ResolutionNode>();
        }
        return this.resolutionNodes;
    }

    public void setArtifactResolutionNodes(Set<ResolutionNode> resolutionNodes) {
        this.resolutionNodes = resolutionNodes;
    }

    public boolean hasMissingArtifacts() {
        return this.missingArtifacts != null && !this.missingArtifacts.isEmpty();
    }

    public List<Artifact> getMissingArtifacts() {
        return this.missingArtifacts == null ? Collections.emptyList() : Collections.unmodifiableList(this.missingArtifacts);
    }

    public ArtifactResolutionResult addMissingArtifact(Artifact artifact) {
        this.missingArtifacts = this.initList(this.missingArtifacts);
        this.missingArtifacts.add(artifact);
        return this;
    }

    public ArtifactResolutionResult setUnresolvedArtifacts(List<Artifact> unresolvedArtifacts) {
        this.missingArtifacts = unresolvedArtifacts;
        return this;
    }

    public boolean isSuccess() {
        return !this.hasMissingArtifacts() && !this.hasExceptions();
    }

    public boolean hasExceptions() {
        return this.exceptions != null && !this.exceptions.isEmpty();
    }

    public List<Exception> getExceptions() {
        return this.exceptions == null ? Collections.emptyList() : Collections.unmodifiableList(this.exceptions);
    }

    public boolean hasVersionRangeViolations() {
        return this.versionRangeViolations != null;
    }

    public ArtifactResolutionResult addVersionRangeViolation(Exception e) {
        this.versionRangeViolations = this.initList(this.versionRangeViolations);
        this.versionRangeViolations.add(e);
        this.exceptions = this.initList(this.exceptions);
        this.exceptions.add(e);
        return this;
    }

    public OverConstrainedVersionException getVersionRangeViolation(int i) {
        return (OverConstrainedVersionException)this.versionRangeViolations.get(i);
    }

    public List<Exception> getVersionRangeViolations() {
        return this.versionRangeViolations == null ? Collections.emptyList() : Collections.unmodifiableList(this.versionRangeViolations);
    }

    public boolean hasMetadataResolutionExceptions() {
        return this.metadataResolutionExceptions != null;
    }

    public ArtifactResolutionResult addMetadataResolutionException(ArtifactResolutionException e) {
        this.metadataResolutionExceptions = this.initList(this.metadataResolutionExceptions);
        this.metadataResolutionExceptions.add(e);
        this.exceptions = this.initList(this.exceptions);
        this.exceptions.add((Exception)e);
        return this;
    }

    public ArtifactResolutionException getMetadataResolutionException(int i) {
        return this.metadataResolutionExceptions.get(i);
    }

    public List<ArtifactResolutionException> getMetadataResolutionExceptions() {
        return this.metadataResolutionExceptions == null ? Collections.emptyList() : Collections.unmodifiableList(this.metadataResolutionExceptions);
    }

    public boolean hasErrorArtifactExceptions() {
        return this.errorArtifactExceptions != null;
    }

    public ArtifactResolutionResult addErrorArtifactException(ArtifactResolutionException e) {
        this.errorArtifactExceptions = this.initList(this.errorArtifactExceptions);
        this.errorArtifactExceptions.add(e);
        this.exceptions = this.initList(this.exceptions);
        this.exceptions.add((Exception)e);
        return this;
    }

    public List<ArtifactResolutionException> getErrorArtifactExceptions() {
        if (this.errorArtifactExceptions == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.errorArtifactExceptions);
    }

    public boolean hasCircularDependencyExceptions() {
        return this.circularDependencyExceptions != null;
    }

    public ArtifactResolutionResult addCircularDependencyException(CyclicDependencyException e) {
        this.circularDependencyExceptions = this.initList(this.circularDependencyExceptions);
        this.circularDependencyExceptions.add(e);
        this.exceptions = this.initList(this.exceptions);
        this.exceptions.add((Exception)e);
        return this;
    }

    public CyclicDependencyException getCircularDependencyException(int i) {
        return this.circularDependencyExceptions.get(i);
    }

    public List<CyclicDependencyException> getCircularDependencyExceptions() {
        if (this.circularDependencyExceptions == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.circularDependencyExceptions);
    }

    public List<ArtifactRepository> getRepositories() {
        if (this.repositories == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.repositories);
    }

    public ArtifactResolutionResult setRepositories(List<ArtifactRepository> repositories) {
        this.repositories = repositories;
        return this;
    }

    private <T> List<T> initList(List<T> l) {
        if (l == null) {
            return new ArrayList();
        }
        return l;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.artifacts != null) {
            int i = 1;
            sb.append("---------").append(LS);
            sb.append(this.artifacts.size()).append(LS);
            for (Artifact a : this.artifacts) {
                sb.append(i).append(' ').append(a).append(LS);
                ++i;
            }
            sb.append("---------");
        }
        return sb.toString();
    }
}

