/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.v4;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.settings.Activation;
import org.apache.maven.api.settings.ActivationFile;
import org.apache.maven.api.settings.ActivationOS;
import org.apache.maven.api.settings.ActivationProperty;
import org.apache.maven.api.settings.IdentifiableBase;
import org.apache.maven.api.settings.InputLocation;
import org.apache.maven.api.settings.InputSource;
import org.apache.maven.api.settings.Mirror;
import org.apache.maven.api.settings.Profile;
import org.apache.maven.api.settings.Proxy;
import org.apache.maven.api.settings.Repository;
import org.apache.maven.api.settings.RepositoryBase;
import org.apache.maven.api.settings.RepositoryPolicy;
import org.apache.maven.api.settings.Server;
import org.apache.maven.api.settings.Settings;
import org.apache.maven.api.settings.TrackableBase;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.internal.xml.XmlNodeBuilder;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Generated
public class SettingsXpp3ReaderEx {
    private boolean addDefaultEntities = true;
    private final ContentTransformer contentTransformer;

    public SettingsXpp3ReaderEx() {
        this((s, f) -> s);
    }

    public SettingsXpp3ReaderEx(ContentTransformer contentTransformer) {
        this.contentTransformer = contentTransformer;
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }

    public Settings read(Reader reader, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        MXParser parser = this.addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser();
        parser.setInput(reader);
        return this.read((XmlPullParser)parser, strict, source);
    }

    public Settings read(InputStream in, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        return this.read((Reader)ReaderFactory.newXmlReader((InputStream)in), strict, source);
    }

    public Settings read(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        Settings settings = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while (eventType != 1) {
            if (eventType == 2) {
                if (strict && !"settings".equals(parser.getName())) {
                    throw new XmlPullParserException("Expected root element 'settings' but found '" + parser.getName() + "'", parser, null);
                }
                if (parsed) {
                    throw new XmlPullParserException("Duplicated tag: 'settings'", parser, null);
                }
                settings = this.parseSettings(parser, strict, source);
                parsed = true;
            }
            eventType = parser.next();
        }
        if (parsed) {
            return settings;
        }
        throw new XmlPullParserException("Expected root element 'settings' but found no element at all: invalid XML document", parser, null);
    }

    private TrackableBase parseTrackableBase(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        TrackableBase.Builder trackableBase = TrackableBase.newBuilder((boolean)true);
        trackableBase.location((Object)"", new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source));
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            String childName = this.unalias(parser.getName());
            if (!parsed.add(childName)) {
                throw new XmlPullParserException("Duplicated tag: '" + childName + "'", parser, null);
            }
            int line = parser.getLineNumber();
            int column = parser.getColumnNumber();
            Map locations = null;
            switch (childName) {
                default: 
            }
            this.checkUnknownElement(parser, strict);
            trackableBase.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return trackableBase.build();
    }

    private IdentifiableBase parseIdentifiableBase(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        IdentifiableBase.Builder identifiableBase = IdentifiableBase.newBuilder((boolean)true);
        identifiableBase.location((Object)"", new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source));
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            String childName = this.unalias(parser.getName());
            if (!parsed.add(childName)) {
                throw new XmlPullParserException("Duplicated tag: '" + childName + "'", parser, null);
            }
            int line = parser.getLineNumber();
            int column = parser.getColumnNumber();
            Map locations = null;
            switch (childName) {
                case "id": {
                    identifiableBase.id(this.interpolatedTrimmed(parser.nextText(), "id"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            identifiableBase.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return identifiableBase.build();
    }

    private Settings parseSettings(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Settings.Builder settings = Settings.newBuilder((boolean)true);
        settings.location((Object)"", new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source));
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0 || "xmlns".equals(name)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            String childName = this.unalias(parser.getName());
            if (!parsed.add(childName)) {
                throw new XmlPullParserException("Duplicated tag: '" + childName + "'", parser, null);
            }
            int line = parser.getLineNumber();
            int column = parser.getColumnNumber();
            HashMap<Integer, InputLocation> locations = null;
            switch (childName) {
                case "localRepository": {
                    settings.localRepository(this.interpolatedTrimmed(parser.nextText(), "localRepository"));
                    break;
                }
                case "interactiveMode": {
                    settings.interactiveMode(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "interactiveMode"), "interactiveMode", parser, true));
                    break;
                }
                case "usePluginRegistry": {
                    settings.usePluginRegistry(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "usePluginRegistry"), "usePluginRegistry", parser, false));
                    break;
                }
                case "offline": {
                    settings.offline(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "offline"), "offline", parser, false));
                    break;
                }
                case "proxies": {
                    ArrayList<Proxy> proxies = new ArrayList<Proxy>();
                    while (parser.nextTag() == 2) {
                        if ("proxy".equals(parser.getName())) {
                            proxies.add(this.parseProxy(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    settings.proxies(proxies);
                    break;
                }
                case "servers": {
                    ArrayList<Server> servers = new ArrayList<Server>();
                    while (parser.nextTag() == 2) {
                        if ("server".equals(parser.getName())) {
                            servers.add(this.parseServer(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    settings.servers(servers);
                    break;
                }
                case "mirrors": {
                    ArrayList<Mirror> mirrors = new ArrayList<Mirror>();
                    while (parser.nextTag() == 2) {
                        if ("mirror".equals(parser.getName())) {
                            mirrors.add(this.parseMirror(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    settings.mirrors(mirrors);
                    break;
                }
                case "repositories": {
                    ArrayList<Repository> repositories = new ArrayList<Repository>();
                    while (parser.nextTag() == 2) {
                        if ("repository".equals(parser.getName())) {
                            repositories.add(this.parseRepository(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    settings.repositories(repositories);
                    break;
                }
                case "pluginRepositories": {
                    ArrayList<Repository> pluginRepositories = new ArrayList<Repository>();
                    while (parser.nextTag() == 2) {
                        if ("pluginRepository".equals(parser.getName())) {
                            pluginRepositories.add(this.parseRepository(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    settings.pluginRepositories(pluginRepositories);
                    break;
                }
                case "profiles": {
                    ArrayList<Profile> profiles = new ArrayList<Profile>();
                    while (parser.nextTag() == 2) {
                        if ("profile".equals(parser.getName())) {
                            profiles.add(this.parseProfile(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    settings.profiles(profiles);
                    break;
                }
                case "activeProfiles": {
                    ArrayList<String> activeProfiles = new ArrayList<String>();
                    locations = new HashMap<Integer, InputLocation>();
                    while (parser.nextTag() == 2) {
                        if ("activeProfile".equals(parser.getName())) {
                            locations.put(locations.size(), new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source));
                            activeProfiles.add(this.interpolatedTrimmed(parser.nextText(), "activeProfiles"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    settings.activeProfiles(activeProfiles);
                    break;
                }
                case "pluginGroups": {
                    ArrayList<String> pluginGroups = new ArrayList<String>();
                    locations = new HashMap();
                    while (parser.nextTag() == 2) {
                        if ("pluginGroup".equals(parser.getName())) {
                            locations.put(locations.size(), new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source));
                            pluginGroups.add(this.interpolatedTrimmed(parser.nextText(), "pluginGroups"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    settings.pluginGroups(pluginGroups);
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            settings.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        settings.modelEncoding(parser.getInputEncoding());
        return settings.build();
    }

    private Proxy parseProxy(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Proxy.Builder proxy = Proxy.newBuilder((boolean)true);
        proxy.location((Object)"", new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source));
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            String childName = this.unalias(parser.getName());
            if (!parsed.add(childName)) {
                throw new XmlPullParserException("Duplicated tag: '" + childName + "'", parser, null);
            }
            int line = parser.getLineNumber();
            int column = parser.getColumnNumber();
            Map locations = null;
            switch (childName) {
                case "active": {
                    proxy.active(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "active"), "active", parser, true));
                    break;
                }
                case "protocol": {
                    proxy.protocol(this.interpolatedTrimmed(parser.nextText(), "protocol"));
                    break;
                }
                case "username": {
                    proxy.username(this.interpolatedTrimmed(parser.nextText(), "username"));
                    break;
                }
                case "password": {
                    proxy.password(this.interpolatedTrimmed(parser.nextText(), "password"));
                    break;
                }
                case "port": {
                    proxy.port(this.getIntegerValue(this.interpolatedTrimmed(parser.nextText(), "port"), "port", parser, strict, 8080));
                    break;
                }
                case "host": {
                    proxy.host(this.interpolatedTrimmed(parser.nextText(), "host"));
                    break;
                }
                case "nonProxyHosts": {
                    proxy.nonProxyHosts(this.interpolatedTrimmed(parser.nextText(), "nonProxyHosts"));
                    break;
                }
                case "id": {
                    proxy.id(this.interpolatedTrimmed(parser.nextText(), "id"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            proxy.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return proxy.build();
    }

    private Server parseServer(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Server.Builder server = Server.newBuilder((boolean)true);
        server.location((Object)"", new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source));
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            String childName = this.unalias(parser.getName());
            if (!parsed.add(childName)) {
                throw new XmlPullParserException("Duplicated tag: '" + childName + "'", parser, null);
            }
            int line = parser.getLineNumber();
            int column = parser.getColumnNumber();
            Map locations = null;
            switch (childName) {
                case "username": {
                    server.username(this.interpolatedTrimmed(parser.nextText(), "username"));
                    break;
                }
                case "password": {
                    server.password(this.interpolatedTrimmed(parser.nextText(), "password"));
                    break;
                }
                case "privateKey": {
                    server.privateKey(this.interpolatedTrimmed(parser.nextText(), "privateKey"));
                    break;
                }
                case "passphrase": {
                    server.passphrase(this.interpolatedTrimmed(parser.nextText(), "passphrase"));
                    break;
                }
                case "filePermissions": {
                    server.filePermissions(this.interpolatedTrimmed(parser.nextText(), "filePermissions"));
                    break;
                }
                case "directoryPermissions": {
                    server.directoryPermissions(this.interpolatedTrimmed(parser.nextText(), "directoryPermissions"));
                    break;
                }
                case "configuration": {
                    server.configuration((XmlNode)XmlNodeBuilder.build((XmlPullParser)parser, (boolean)true));
                    break;
                }
                case "id": {
                    server.id(this.interpolatedTrimmed(parser.nextText(), "id"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            server.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return server.build();
    }

    private Mirror parseMirror(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Mirror.Builder mirror = Mirror.newBuilder((boolean)true);
        mirror.location((Object)"", new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source));
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            String childName = this.unalias(parser.getName());
            if (!parsed.add(childName)) {
                throw new XmlPullParserException("Duplicated tag: '" + childName + "'", parser, null);
            }
            int line = parser.getLineNumber();
            int column = parser.getColumnNumber();
            Map locations = null;
            switch (childName) {
                case "mirrorOf": {
                    mirror.mirrorOf(this.interpolatedTrimmed(parser.nextText(), "mirrorOf"));
                    break;
                }
                case "name": {
                    mirror.name(this.interpolatedTrimmed(parser.nextText(), "name"));
                    break;
                }
                case "url": {
                    mirror.url(this.interpolatedTrimmed(parser.nextText(), "url"));
                    break;
                }
                case "layout": {
                    mirror.layout(this.interpolatedTrimmed(parser.nextText(), "layout"));
                    break;
                }
                case "mirrorOfLayouts": {
                    mirror.mirrorOfLayouts(this.interpolatedTrimmed(parser.nextText(), "mirrorOfLayouts"));
                    break;
                }
                case "blocked": {
                    mirror.blocked(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "blocked"), "blocked", parser, false));
                    break;
                }
                case "id": {
                    mirror.id(this.interpolatedTrimmed(parser.nextText(), "id"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            mirror.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return mirror.build();
    }

    private Profile parseProfile(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Profile.Builder profile = Profile.newBuilder((boolean)true);
        profile.location((Object)"", new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source));
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            String childName = this.unalias(parser.getName());
            if (!parsed.add(childName)) {
                throw new XmlPullParserException("Duplicated tag: '" + childName + "'", parser, null);
            }
            int line = parser.getLineNumber();
            int column = parser.getColumnNumber();
            HashMap<String, InputLocation> locations = null;
            switch (childName) {
                case "activation": {
                    profile.activation(this.parseActivation(parser, strict, source));
                    break;
                }
                case "properties": {
                    LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
                    locations = new HashMap<String, InputLocation>();
                    while (parser.nextTag() == 2) {
                        String key = parser.getName();
                        String value = parser.nextText().trim();
                        locations.put(key, new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source));
                        properties.put(key, value);
                    }
                    profile.properties(properties);
                    break;
                }
                case "repositories": {
                    ArrayList<Repository> repositories = new ArrayList<Repository>();
                    while (parser.nextTag() == 2) {
                        if ("repository".equals(parser.getName())) {
                            repositories.add(this.parseRepository(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    profile.repositories(repositories);
                    break;
                }
                case "pluginRepositories": {
                    ArrayList<Repository> pluginRepositories = new ArrayList<Repository>();
                    while (parser.nextTag() == 2) {
                        if ("pluginRepository".equals(parser.getName())) {
                            pluginRepositories.add(this.parseRepository(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    profile.pluginRepositories(pluginRepositories);
                    break;
                }
                case "id": {
                    profile.id(this.interpolatedTrimmed(parser.nextText(), "id"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            profile.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return profile.build();
    }

    private Activation parseActivation(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Activation.Builder activation = Activation.newBuilder((boolean)true);
        activation.location((Object)"", new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source));
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            String childName = this.unalias(parser.getName());
            if (!parsed.add(childName)) {
                throw new XmlPullParserException("Duplicated tag: '" + childName + "'", parser, null);
            }
            int line = parser.getLineNumber();
            int column = parser.getColumnNumber();
            Map locations = null;
            switch (childName) {
                case "activeByDefault": {
                    activation.activeByDefault(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "activeByDefault"), "activeByDefault", parser, false));
                    break;
                }
                case "jdk": {
                    activation.jdk(this.interpolatedTrimmed(parser.nextText(), "jdk"));
                    break;
                }
                case "os": {
                    activation.os(this.parseActivationOS(parser, strict, source));
                    break;
                }
                case "property": {
                    activation.property(this.parseActivationProperty(parser, strict, source));
                    break;
                }
                case "file": {
                    activation.file(this.parseActivationFile(parser, strict, source));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            activation.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return activation.build();
    }

    private RepositoryBase parseRepositoryBase(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        RepositoryBase.Builder repositoryBase = RepositoryBase.newBuilder((boolean)true);
        repositoryBase.location((Object)"", new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source));
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            String childName = this.unalias(parser.getName());
            if (!parsed.add(childName)) {
                throw new XmlPullParserException("Duplicated tag: '" + childName + "'", parser, null);
            }
            int line = parser.getLineNumber();
            int column = parser.getColumnNumber();
            Map locations = null;
            switch (childName) {
                case "name": {
                    repositoryBase.name(this.interpolatedTrimmed(parser.nextText(), "name"));
                    break;
                }
                case "url": {
                    repositoryBase.url(this.interpolatedTrimmed(parser.nextText(), "url"));
                    break;
                }
                case "layout": {
                    repositoryBase.layout(this.interpolatedTrimmed(parser.nextText(), "layout"));
                    break;
                }
                case "id": {
                    repositoryBase.id(this.interpolatedTrimmed(parser.nextText(), "id"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            repositoryBase.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return repositoryBase.build();
    }

    private Repository parseRepository(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Repository.Builder repository = Repository.newBuilder((boolean)true);
        repository.location((Object)"", new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source));
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            String childName = this.unalias(parser.getName());
            if (!parsed.add(childName)) {
                throw new XmlPullParserException("Duplicated tag: '" + childName + "'", parser, null);
            }
            int line = parser.getLineNumber();
            int column = parser.getColumnNumber();
            Map locations = null;
            switch (childName) {
                case "releases": {
                    repository.releases(this.parseRepositoryPolicy(parser, strict, source));
                    break;
                }
                case "snapshots": {
                    repository.snapshots(this.parseRepositoryPolicy(parser, strict, source));
                    break;
                }
                case "name": {
                    repository.name(this.interpolatedTrimmed(parser.nextText(), "name"));
                    break;
                }
                case "url": {
                    repository.url(this.interpolatedTrimmed(parser.nextText(), "url"));
                    break;
                }
                case "layout": {
                    repository.layout(this.interpolatedTrimmed(parser.nextText(), "layout"));
                    break;
                }
                case "id": {
                    repository.id(this.interpolatedTrimmed(parser.nextText(), "id"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            repository.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return repository.build();
    }

    private RepositoryPolicy parseRepositoryPolicy(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        RepositoryPolicy.Builder repositoryPolicy = RepositoryPolicy.newBuilder((boolean)true);
        repositoryPolicy.location((Object)"", new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source));
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            String childName = this.unalias(parser.getName());
            if (!parsed.add(childName)) {
                throw new XmlPullParserException("Duplicated tag: '" + childName + "'", parser, null);
            }
            int line = parser.getLineNumber();
            int column = parser.getColumnNumber();
            Map locations = null;
            switch (childName) {
                case "enabled": {
                    repositoryPolicy.enabled(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "enabled"), "enabled", parser, true));
                    break;
                }
                case "updatePolicy": {
                    repositoryPolicy.updatePolicy(this.interpolatedTrimmed(parser.nextText(), "updatePolicy"));
                    break;
                }
                case "checksumPolicy": {
                    repositoryPolicy.checksumPolicy(this.interpolatedTrimmed(parser.nextText(), "checksumPolicy"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            repositoryPolicy.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return repositoryPolicy.build();
    }

    private ActivationProperty parseActivationProperty(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        ActivationProperty.Builder activationProperty = ActivationProperty.newBuilder((boolean)true);
        activationProperty.location((Object)"", new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source));
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            String childName = this.unalias(parser.getName());
            if (!parsed.add(childName)) {
                throw new XmlPullParserException("Duplicated tag: '" + childName + "'", parser, null);
            }
            int line = parser.getLineNumber();
            int column = parser.getColumnNumber();
            Map locations = null;
            switch (childName) {
                case "name": {
                    activationProperty.name(this.interpolatedTrimmed(parser.nextText(), "name"));
                    break;
                }
                case "value": {
                    activationProperty.value(this.interpolatedTrimmed(parser.nextText(), "value"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            activationProperty.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return activationProperty.build();
    }

    private ActivationOS parseActivationOS(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        ActivationOS.Builder activationOS = ActivationOS.newBuilder((boolean)true);
        activationOS.location((Object)"", new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source));
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            String childName = this.unalias(parser.getName());
            if (!parsed.add(childName)) {
                throw new XmlPullParserException("Duplicated tag: '" + childName + "'", parser, null);
            }
            int line = parser.getLineNumber();
            int column = parser.getColumnNumber();
            Map locations = null;
            switch (childName) {
                case "name": {
                    activationOS.name(this.interpolatedTrimmed(parser.nextText(), "name"));
                    break;
                }
                case "family": {
                    activationOS.family(this.interpolatedTrimmed(parser.nextText(), "family"));
                    break;
                }
                case "arch": {
                    activationOS.arch(this.interpolatedTrimmed(parser.nextText(), "arch"));
                    break;
                }
                case "version": {
                    activationOS.version(this.interpolatedTrimmed(parser.nextText(), "version"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            activationOS.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return activationOS.build();
    }

    private ActivationFile parseActivationFile(XmlPullParser parser, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        ActivationFile.Builder activationFile = ActivationFile.newBuilder((boolean)true);
        activationFile.location((Object)"", new InputLocation(parser.getLineNumber(), parser.getColumnNumber(), source));
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            String childName = this.unalias(parser.getName());
            if (!parsed.add(childName)) {
                throw new XmlPullParserException("Duplicated tag: '" + childName + "'", parser, null);
            }
            int line = parser.getLineNumber();
            int column = parser.getColumnNumber();
            Map locations = null;
            switch (childName) {
                case "missing": {
                    activationFile.missing(this.interpolatedTrimmed(parser.nextText(), "missing"));
                    break;
                }
                case "exists": {
                    activationFile.exists(this.interpolatedTrimmed(parser.nextText(), "exists"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            activationFile.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return activationFile.build();
    }

    private String unalias(String tagName) {
        switch (tagName) {
            default: 
        }
        return tagName;
    }

    private void checkUnknownAttribute(XmlPullParser parser, String attribute, String tagName, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null);
        }
    }

    private void checkUnknownElement(XmlPullParser parser, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount > 0) {
            int eventType = parser.next();
            if (eventType == 2) {
                ++unrecognizedTagCount;
                continue;
            }
            if (eventType != 3) continue;
            --unrecognizedTagCount;
        }
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private String interpolatedTrimmed(String value, String context) {
        return this.getTrimmedValue(this.contentTransformer.transform(value, context));
    }

    private int nextTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int eventType = parser.next();
        if (eventType == 4) {
            eventType = parser.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null);
        }
        return eventType;
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser, boolean defaultValue) throws XmlPullParserException {
        if (s != null && s.length() != 0) {
            return Boolean.valueOf(s);
        }
        return defaultValue;
    }

    private int getIntegerValue(String s, String attribute, XmlPullParser parser, boolean strict, int defaultValue) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be an integer", parser, (Throwable)nfe);
                }
            }
        }
        return defaultValue;
    }

    public static interface ContentTransformer {
        public String transform(String var1, String var2);
    }
}

