/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.applications.webcontent.proxy.impl;

import org.apache.portals.applications.webcontent.proxy.HttpReverseProxyPathMapper;
import org.apache.portals.applications.webcontent.proxy.HttpReverseProxyPathMapperProvider;
import org.apache.portals.applications.webcontent.proxy.ReverseProxyRewritingContext;
import org.apache.portals.applications.webcontent.proxy.ReverseProxyRewritingContextAware;
import org.apache.portals.applications.webcontent.rewriter.AbstractTextLinesParserAdaptor;


/**
 * AbstractReverseProxyTextLinesParserAdaptor
 * 
 * @version $Id: AbstractReverseProxyTextLinesParserAdaptor.java 821934 2009-10-05 17:50:07Z woonsan $
 */
public abstract class AbstractReverseProxyTextLinesParserAdaptor extends AbstractTextLinesParserAdaptor implements ReverseProxyRewritingContextAware
{
    
    private ReverseProxyRewritingContext reverseProxyRewritingContext;
    private String rewritingContextPath;
    private HttpReverseProxyPathMapperProvider proxyPathMapperProvider;
    private int maxMatchingPathPartCount;
    private HttpReverseProxyPathMapper proxyPathMapper;

    public void setReverseProxyRewritingContext(ReverseProxyRewritingContext reverseProxyRewritingContext)
    {
        this.reverseProxyRewritingContext = reverseProxyRewritingContext;
        
        if (this.reverseProxyRewritingContext != null)
        {
            rewritingContextPath = reverseProxyRewritingContext.getRewritingContextPath();
            proxyPathMapperProvider = this.reverseProxyRewritingContext.getHttpReverseProxyPathMapperProvider();
            maxMatchingPathPartCount = proxyPathMapperProvider.getMaxMatchingPathPartCount();
            proxyPathMapper = this.reverseProxyRewritingContext.getHttpReverseProxyPathMapper();
        }
    }
    
    protected ReverseProxyRewritingContext getReverseProxyRewritingContext()
    {
        return reverseProxyRewritingContext;
    }
    
    protected String getRewritingContextPath()
    {
        return rewritingContextPath;
    }

    protected HttpReverseProxyPathMapperProvider getHttpReverseProxyPathMapperProvider()
    {
        return proxyPathMapperProvider;
    }
    
    protected int getMaxMatchingPathPartCount()
    {
        return maxMatchingPathPartCount;
    }
    
    protected HttpReverseProxyPathMapper getHttpReverseProxyPathMapper()
    {
        return proxyPathMapper;
    }
    
}
