/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.applications.webcontent.proxy;

import java.io.InputStream;

import junit.framework.TestCase;

import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.params.ConnRouteParamBean;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;

/**
 * Example test case to show how to implement http client invocations with proxy configuration
 * 
 * @version $Id: TestHttpClientThroughProxy.java 884123 2009-11-25 14:53:03Z woonsan $
 */
public class TestHttpClientThroughProxy extends TestCase
{
    
    private HttpClient httpClient;
    private HttpParams clientParams;
    private HttpHost defaultProxy = new HttpHost("localhost", 8000);
    
    @Override
    public void setUp()
    {
        clientParams = new BasicHttpParams();
        httpClient = new DefaultHttpClient(clientParams);
    }
    
    public void testClientThroughProxy()
    {
        String targetURL = "http://portals.apache.org/issue-tracking.html";
        
        try
        {
            HttpRequestBase httpRequest = new HttpGet(targetURL);
            
            ConnRouteParamBean connRouteParam = new ConnRouteParamBean(httpRequest.getParams());
            connRouteParam.setDefaultProxy(defaultProxy);
            
            HttpResponse httpResponse = httpClient.execute(httpRequest);
            HttpEntity httpEntity = httpResponse.getEntity();
            
            InputStream input = httpEntity.getContent();
            
            if (input != null)
            {
                IOUtils.copy(input, System.out);
                System.out.flush();
                IOUtils.closeQuietly(input);
            }
        }
        catch (Exception e)
        {
            System.out.println("WARNING: Connection through proxy has failed. " + e);
            System.out.println("WARNING: Proxy: " + defaultProxy + ", target: " + targetURL);
        }
    }
    
}
