package org.apache.portals.applications.webcontent2.proxy.impl;

import java.io.IOException;
import java.util.List;

import org.apache.commons.chain.Command;
import org.apache.portals.applications.webcontent2.proxy.ProxyContext;
import org.apache.portals.applications.webcontent2.proxy.ReverseProxyException;
import org.apache.portals.applications.webcontent2.proxy.ReverseProxyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Default reverse proxy service implementation.
 */
public class DefaultReverseProxyService implements ReverseProxyService
{

    private static Logger log = LoggerFactory.getLogger(DefaultReverseProxyService.class);

    /**
     * The underlying {@link ProxyProcessingChain} containing {@link Command}s.
     */
    private final ProxyProcessingChain proxyProcessingChain;

    /**
     * Constructs a <code>DefaultReverseProxyService</code> with the given <code>proxyProcessingChain</code>.
     * @param proxyProcessingChain
     */
    public DefaultReverseProxyService(final ProxyProcessingChain proxyProcessingChain)
    {
        this.proxyProcessingChain = proxyProcessingChain;
    }

    /**
     * {@inheritDoc}
     */
    public void invoke(ProxyContext proxyContext) throws ReverseProxyException, IOException
    {
        proxyProcessingChain.execute(proxyContext);

        if (proxyContext.hasException())
        {
            logExceptions(proxyContext.getExceptions());

            Exception e = proxyContext.getExceptions().get(0);

            if (e instanceof ReverseProxyException) 
            {
                throw (ReverseProxyException) e;
            }
            else if (e instanceof IOException) 
            {
                throw (IOException) e;
            }
            else
            {
                throw new ReverseProxyException(e);
            }
        }
    }

    /**
     * Logs all the exceptions caught while calling on {@link #invoke(ProxyContext)}.
     * @param exceptions
     */
    protected void logExceptions(List<Exception> exceptions)
    {
        // Note: maybe it can be more useful to use a location-aware logger here.

        if (log.isDebugEnabled())
        {
            for (Exception ex : exceptions)
            {
                log.error("Reverse proxy service error.", ex);
            }
        }
        else
        {
            for (Exception ex : exceptions)
            {
                log.error("Reverse proxy service error. " + ex);
            }
        }
    }
}
