/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.applications.webcontent2.proxy.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

import javax.servlet.http.HttpServletResponse;

import org.apache.portals.applications.webcontent2.rewriter.Sink;

/**
 * Acts as an holder for a content rewriting {@link Sink}
 * in the form of byte or character stream of {@link HttpServletResponse}.
 */
public class HttpServletResponseSink implements Sink
{

    /**
     * Underlying {@link HttpServletResponse} of this sink.
     */
    private final HttpServletResponse response;

    /**
     * Constructs a <code>HttpServletResponseSink</code> for the given
     * <code>response</code>.
     * @param response
     */
    public HttpServletResponseSink(final HttpServletResponse response)
    {
        this.response = response;
    }

    /**
     * Returns the {@link java.io.OutputStream} of the underlying {@link HttpServletResponse}.
     */
    public OutputStream getOutputStream() throws IOException
    {
        return response.getOutputStream();
    }

    /**
     * Returns the {@link java.io.Writer} of the underlying {@link HttpServletResponse}.
     */
    public Writer getWriter() throws IOException
    {
        return response.getWriter();
    }
}
