/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo.plugins;

import com.netflix.fenzo.ConstraintEvaluator;
import com.netflix.fenzo.TaskRequest;
import com.netflix.fenzo.TaskTrackerState;
import com.netflix.fenzo.VirtualMachineCurrentState;
import com.netflix.fenzo.VirtualMachineLease;
import com.netflix.fenzo.functions.Func1;
import java.util.Map;
import org.apache.mesos.Protos;

public class HostAttrValueConstraint
implements ConstraintEvaluator {
    private static final String HOSTNAME = "HOSTNAME";
    private final String hostAttributeName;
    private final Func1<String, String> hostAttributeValueGetter;

    public HostAttrValueConstraint(String hostAttributeName, Func1<String, String> hostAttributeValueGetter) {
        this.hostAttributeName = hostAttributeName == null ? HOSTNAME : hostAttributeName;
        this.hostAttributeValueGetter = hostAttributeValueGetter;
    }

    @Override
    public String getName() {
        return HostAttrValueConstraint.class.getName() + "-" + this.hostAttributeName;
    }

    @Override
    public ConstraintEvaluator.Result evaluate(TaskRequest taskRequest, VirtualMachineCurrentState targetVM, TaskTrackerState taskTrackerState) {
        String targetHostAttrVal = this.getAttrValue(targetVM.getCurrAvailableResources());
        if (targetHostAttrVal == null || targetHostAttrVal.isEmpty()) {
            return new ConstraintEvaluator.Result(false, this.hostAttributeName + " attribute unavailable on host " + targetVM.getCurrAvailableResources().hostname());
        }
        String requiredAttrVal = this.hostAttributeValueGetter.call(taskRequest.getId());
        return targetHostAttrVal.equals(requiredAttrVal) ? new ConstraintEvaluator.Result(true, "") : new ConstraintEvaluator.Result(false, "Host attribute " + this.hostAttributeName + ": required=" + requiredAttrVal + ", got=" + targetHostAttrVal);
    }

    private String getAttrValue(VirtualMachineLease lease) {
        switch (this.hostAttributeName) {
            case "HOSTNAME": {
                return lease.hostname();
            }
        }
        Map<String, Protos.Attribute> attributeMap = lease.getAttributeMap();
        if (attributeMap == null) {
            return null;
        }
        Protos.Attribute attribute = attributeMap.get(this.hostAttributeName);
        if (attribute == null) {
            return null;
        }
        return attribute.getText().getValue();
    }
}

