/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo.samples;

import com.netflix.fenzo.ConstraintEvaluator;
import com.netflix.fenzo.TaskRequest;
import com.netflix.fenzo.VMTaskFitnessCalculator;
import com.netflix.fenzo.functions.Action1;
import com.netflix.fenzo.functions.Func1;
import com.netflix.fenzo.samples.SampleFramework;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class TaskGenerator
implements Runnable {
    private final BlockingQueue<TaskRequest> taskQueue;
    private final int numIters;
    private final int numTasks;
    private final AtomicInteger tasksCompleted = new AtomicInteger();
    private int launchedTasks = 0;

    public TaskGenerator(BlockingQueue<TaskRequest> taskQueue, int numIters, int numTasks) {
        this.taskQueue = taskQueue;
        this.numIters = numIters;
        this.numTasks = numTasks;
    }

    @Override
    public void run() {
        for (int i = 0; i < this.numIters; ++i) {
            for (int j = 0; j < this.numTasks; ++j) {
                this.taskQueue.offer(this.getTaskRequest(this.launchedTasks++));
            }
            System.out.println("        Generated " + this.numTasks + " tasks so far");
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private TaskRequest getTaskRequest(int id) {
        final String taskId = "" + id;
        final AtomicReference assgndResRef = new AtomicReference();
        return new TaskRequest(){

            @Override
            public String getId() {
                return taskId;
            }

            @Override
            public String taskGroupName() {
                return "";
            }

            @Override
            public double getCPUs() {
                return 1.0;
            }

            @Override
            public double getMemory() {
                return 1024.0;
            }

            @Override
            public double getNetworkMbps() {
                return 0.0;
            }

            @Override
            public double getDisk() {
                return 10.0;
            }

            @Override
            public int getPorts() {
                return 1;
            }

            @Override
            public Map<String, Double> getScalarRequests() {
                return null;
            }

            @Override
            public List<? extends ConstraintEvaluator> getHardConstraints() {
                return null;
            }

            @Override
            public List<? extends VMTaskFitnessCalculator> getSoftConstraints() {
                return null;
            }

            @Override
            public void setAssignedResources(TaskRequest.AssignedResources assignedResources) {
                assgndResRef.set(assignedResources);
            }

            @Override
            public TaskRequest.AssignedResources getAssignedResources() {
                return (TaskRequest.AssignedResources)assgndResRef.get();
            }

            @Override
            public Map<String, TaskRequest.NamedResourceSetRequest> getCustomNamedResources() {
                return Collections.emptyMap();
            }
        };
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Must provide one argument - Mesos master location string");
            System.exit(1);
        }
        int numTasks = 10;
        int numIters = 5;
        LinkedBlockingQueue<TaskRequest> taskQueue = new LinkedBlockingQueue<TaskRequest>();
        final TaskGenerator taskGenerator = new TaskGenerator(taskQueue, numIters, numTasks);
        final SampleFramework framework = new SampleFramework(taskQueue, args[0], new Action1<String>(){

            @Override
            public void call(String s) {
                taskGenerator.tasksCompleted.incrementAndGet();
            }
        }, new Func1<String, String>(){

            @Override
            public String call(String s) {
                return "sleep 2";
            }
        });
        long start = System.currentTimeMillis();
        new Thread(taskGenerator).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                framework.runAll();
            }
        }).start();
        while (taskGenerator.tasksCompleted.get() < numIters * numTasks) {
            System.out.println("NUM TASKS COMPLETED: " + taskGenerator.tasksCompleted.get() + " of " + numIters * numTasks);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        System.out.println("Took " + (System.currentTimeMillis() - start) + " mS to complete " + numIters * numTasks + " tasks");
        framework.shutdown();
        System.exit(0);
    }
}

