/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.console.controller;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.gson.JsonParseException;
import java.util.Collection;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.mesos.MesosStateService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.mesos.ReconcileService;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.restful.RestfulController;
import org.apache.shardingsphere.elasticjob.restful.annotation.ContextPath;
import org.apache.shardingsphere.elasticjob.restful.annotation.Mapping;
import org.apache.shardingsphere.elasticjob.restful.annotation.Param;
import org.apache.shardingsphere.elasticjob.restful.annotation.ParamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ContextPath(value="/api/operate")
public final class CloudOperationController
implements RestfulController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CloudOperationController.class);
    private static ReconcileService reconcileService;
    private static final long RECONCILE_MILLIS_INTERVAL = 10000L;
    private static MesosStateService mesosStateService;
    private static long lastReconcileTime;

    public static void init(CoordinatorRegistryCenter regCenter, ReconcileService reconcileService) {
        CloudOperationController.reconcileService = reconcileService;
        mesosStateService = new MesosStateService(regCenter);
    }

    @Mapping(method="POST", path="/reconcile/explicit")
    public boolean explicitReconcile() {
        this.validReconcileInterval();
        reconcileService.explicitReconcile();
        return true;
    }

    @Mapping(method="POST", path="/reconcile/implicit")
    public boolean implicitReconcile() {
        this.validReconcileInterval();
        reconcileService.implicitReconcile();
        return true;
    }

    private void validReconcileInterval() {
        if (System.currentTimeMillis() < lastReconcileTime + 10000L) {
            throw new RuntimeException("Repeat explicitReconcile");
        }
        lastReconcileTime = System.currentTimeMillis();
    }

    @Mapping(method="GET", path="/sandbox")
    public Collection<Map<String, String>> sandbox(@Param(name="appName", source=ParamSource.QUERY) String appName) throws JsonParseException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)appName) ? 1 : 0) != 0, (Object)"Lack param 'appName'");
        return mesosStateService.sandbox(appName);
    }
}

