/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.restful;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.restful.Filter;
import org.apache.shardingsphere.elasticjob.restful.RestfulController;
import org.apache.shardingsphere.elasticjob.restful.handler.ExceptionHandler;

public final class NettyRestfulServiceConfiguration {
    private final int port;
    private String host;
    private boolean trailingSlashSensitive;
    private final List<Filter> filterInstances = new LinkedList<Filter>();
    private final List<RestfulController> controllerInstances = new LinkedList<RestfulController>();
    private final Map<Class<? extends Throwable>, ExceptionHandler<? extends Throwable>> exceptionHandlers = new HashMap<Class<? extends Throwable>, ExceptionHandler<? extends Throwable>>();

    public void addFilterInstances(Filter ... instances) {
        this.filterInstances.addAll(Arrays.asList(instances));
    }

    public void addControllerInstances(RestfulController ... instances) {
        this.controllerInstances.addAll(Arrays.asList(instances));
    }

    public <E extends Throwable> void addExceptionHandler(Class<E> exceptionType, ExceptionHandler<E> exceptionHandler) {
        Preconditions.checkState((!this.exceptionHandlers.containsKey(exceptionType) ? 1 : 0) != 0, (String)"ExceptionHandler for %s has already existed.", (Object)exceptionType.getName());
        this.exceptionHandlers.put(exceptionType, exceptionHandler);
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public boolean isTrailingSlashSensitive() {
        return this.trailingSlashSensitive;
    }

    @Generated
    public List<Filter> getFilterInstances() {
        return this.filterInstances;
    }

    @Generated
    public List<RestfulController> getControllerInstances() {
        return this.controllerInstances;
    }

    @Generated
    public Map<Class<? extends Throwable>, ExceptionHandler<? extends Throwable>> getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    @Generated
    public NettyRestfulServiceConfiguration(int port) {
        this.port = port;
    }

    @Generated
    public void setHost(String host) {
        this.host = host;
    }

    @Generated
    public void setTrailingSlashSensitive(boolean trailingSlashSensitive) {
        this.trailingSlashSensitive = trailingSlashSensitive;
    }
}

