/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.restful.filter;

import com.google.common.base.Preconditions;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.util.ReferenceCountUtil;
import java.util.List;
import org.apache.shardingsphere.elasticjob.restful.Filter;
import org.apache.shardingsphere.elasticjob.restful.filter.FilterChain;
import org.apache.shardingsphere.elasticjob.restful.handler.HandleContext;

public final class DefaultFilterChain
implements FilterChain {
    private final Filter[] filters;
    private final ChannelHandlerContext ctx;
    private final HandleContext<?> handleContext;
    private int current;
    private boolean passedThrough;
    private boolean replied;

    public DefaultFilterChain(List<Filter> filterInstances, ChannelHandlerContext ctx, HandleContext<?> handleContext) {
        this.filters = filterInstances.toArray(new Filter[0]);
        this.ctx = ctx;
        this.handleContext = handleContext;
    }

    @Override
    public void next(FullHttpRequest httpRequest) {
        Preconditions.checkState((!this.passedThrough && !this.replied ? 1 : 0) != 0, (Object)"FilterChain has already finished.");
        if (this.current < this.filters.length) {
            this.filters[this.current++].doFilter(httpRequest, this.handleContext.getHttpResponse(), this);
            if (!this.passedThrough && !this.replied) {
                this.doResponse();
            }
            return;
        }
        this.passedThrough = true;
        this.ctx.fireChannelRead(this.handleContext);
    }

    private void doResponse() {
        try {
            this.ctx.writeAndFlush((Object)this.handleContext.getHttpResponse());
            this.replied = true;
        }
        finally {
            ReferenceCountUtil.release((Object)this.handleContext.getHttpRequest());
        }
    }
}

