/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.restful.serializer;

import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.restful.serializer.ResponseBodySerializer;
import org.apache.shardingsphere.elasticjob.restful.serializer.ResponseBodySerializerNotFoundException;
import org.apache.shardingsphere.elasticjob.restful.serializer.factory.SerializerFactory;

public final class ResponseBodySerializerFactory {
    private static final Map<String, ResponseBodySerializer> RESPONSE_BODY_SERIALIZERS = new ConcurrentHashMap<String, ResponseBodySerializer>();
    private static final Map<String, SerializerFactory> RESPONSE_BODY_SERIALIZER_FACTORIES = new ConcurrentHashMap<String, SerializerFactory>();
    private static final ResponseBodySerializer MISSING_SERIALIZER = new ResponseBodySerializer(){

        @Override
        public String mimeType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] serialize(Object responseBody) {
            throw new UnsupportedOperationException();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static ResponseBodySerializer getResponseBodySerializer(String contentType) {
        ResponseBodySerializer result = RESPONSE_BODY_SERIALIZERS.get(contentType);
        if (null == result) {
            Class<ResponseBodySerializerFactory> clazz = ResponseBodySerializerFactory.class;
            // MONITORENTER : org.apache.shardingsphere.elasticjob.restful.serializer.ResponseBodySerializerFactory.class
            if (null == RESPONSE_BODY_SERIALIZERS.get(contentType)) {
                ResponseBodySerializerFactory.instantiateResponseBodySerializerFromFactories(contentType);
            }
            result = RESPONSE_BODY_SERIALIZERS.get(contentType);
            // MONITOREXIT : clazz
        }
        if (MISSING_SERIALIZER != result) return result;
        throw new ResponseBodySerializerNotFoundException(contentType);
    }

    private static void instantiateResponseBodySerializerFromFactories(String contentType) {
        SerializerFactory factory = RESPONSE_BODY_SERIALIZER_FACTORIES.get(contentType);
        ResponseBodySerializer serializer = Optional.ofNullable(factory).map(SerializerFactory::createSerializer).orElse(MISSING_SERIALIZER);
        RESPONSE_BODY_SERIALIZERS.put(contentType, serializer);
    }

    @Generated
    private ResponseBodySerializerFactory() {
    }

    static {
        for (ResponseBodySerializer serializer : ServiceLoader.load(ResponseBodySerializer.class)) {
            RESPONSE_BODY_SERIALIZERS.put(serializer.mimeType(), serializer);
        }
        for (SerializerFactory factory : ServiceLoader.load(SerializerFactory.class)) {
            RESPONSE_BODY_SERIALIZER_FACTORIES.put(factory.mimeType(), factory);
        }
    }
}

