/********************************************************************************************/
/*  Hello_World.c   -  Copyright Wavecom S.A. (c) 2002										*/
/*																							*/
/*																							*/
/* DISCLAIMER OF WARRANTY																    */
/* ======================																    */
/* This Software is provided free of charge on an 'as is' basis. No warranty is given       */
/* by Wavecom S.A. in relation to the Software of the uses to which it may be put by you,   */
/* the user, or its merchantability, fitness or suitability for any particular purpose      */
/* or conditions; and/or that the use of the Software and all documentation relating        */
/* thereto by the Licensee will not infringe any third party copyright or other             */
/* intellectual property rights. Wavecom S.A. shall furthermore be under no obligation      */
/* to provide support of any nature for the Software and the Documentation.				    */
/*																						    */
/* LIMIT OF LIABILITY																	    */
/* ==================																		*/
/* In no event shall Wavecom S.A. be liable for any loss or damages whatsoever or howsoever	*/
/* caused arising directly or indirectly in connection with this licence, the Software,		*/
/* its use or otherwise except to the extent that such liability may not be lawfully		*/
/* excluded. Notwithstanding the generality of the foregoing, Wavecom S.A. expressly		*/
/* excludes liability for indirect, special, incidental or consequential loss or damage		*/
/* which may arise in respect of the Software or its use, or in respect of other equipment	*/
/* or property, or for loss of profit, business, revenue, goodwill or anticipated savings.	*/
/*																						    */
/********************************************************************************************/

/***************************************************************************/
/*  File       : Hello_World.c                                             */
/*-------------------------------------------------------------------------*/
/*  Object     : Customer application                                      */
/*                                                                         */
/*  contents   : Customer main procedures                                  */
/*                                                                         */
/*  Change     :                                                           */
/***************************************************************************/
/*
    $LogWavecom: G:\projet\mmi\pvcsarch\archives\open-mmi\SAMPLES\adl\Hello_World\src\hello_world.c-arc $
 * --------------------------------------------------------------------------
 *  Date     | Author | Revision       | Description
 * ----------+--------+----------------+-------------------------------------
 *  25.10.05 | DPO    | 1.2            | * New V4 interface
 * ----------+--------+----------------+-------------------------------------
 *  11.12.02 | dpo    | 1.1            | * Timer subscription update
 * ----------+--------+----------------+-------------------------------------
 *  06.11.02 | dpo    | 1.0            | Initial revision.
 * ----------+--------+----------------+-------------------------------------
*/

#include "adl_global.h"


/***************************************************************************/
/*  Mandatory variables                                                    */
/*-------------------------------------------------------------------------*/
/*  wm_apmCustomStackSize                                                  */
/*-------------------------------------------------------------------------*/
/***************************************************************************/
const u16 wm_apmCustomStackSize = 1024*3*3;

#define NUM_GPIO 1		// number of GPIOs sets

static adl_ioDefs_t Gpio_Config[NUM_GPIO] = {

	{ADL_IO_GPIO | 0 | ADL_IO_DIR_OUT | ADL_IO_LEV_LOW}		// set GPIO0 as output low
};

static s32 myGpioOut_Handle;		// handle to GPIO0 out

static s8 sms_handle;				// handle for sms event

static adl_tmr_t* tim_handle;		// timer handle for led

static u8 tim_count;				// timer tim_counter

static ascii phone_number[] = "+393289531658";	// phone number to send sms
static ascii sms_text[] = "Allarme";			// text of sms





/***************************************************************************/
/*  Function   : Led_TimerHandler                                          */
/*-------------------------------------------------------------------------*/
/*  Object     : Timer handler                                             */
/*                                                                         */
/*-------------------------------------------------------------------------*/
/*  Variable Name     |IN |OUT|GLB|  Utilisation                           */
/*--------------------+---+---+---+----------------------------------------*/
/*  ID                |   |   |   | Timer ID                               */
/*--------------------+---+---+---+----------------------------------------*/
/*  Context           |   |   |   | Context                                */
/*--------------------+---+---+---+----------------------------------------*/
/***************************************************************************/
void Led_TimerHandler ( u8 ID, void * Context )
{
   adl_ioDefs_t Gpio_to_write = ADL_IO_GPIO | 0 ;

   tim_count++;

	// Read output and toggle led
	if(adl_ioReadSingle( myGpioOut_Handle,&Gpio_to_write))
		// Reset output
		adl_ioWriteSingle ( myGpioOut_Handle, &Gpio_to_write, FALSE );
	else
		// Set output
		adl_ioWriteSingle ( myGpioOut_Handle, &Gpio_to_write , TRUE );

	if(tim_count > 20)	// Stop timer after 10s
	   {
		   // Reset output
		   adl_ioWriteSingle ( myGpioOut_Handle, &Gpio_to_write , FALSE );
		   // init timer counter
		   tim_count = 0;
		   // Stop timer led
		   adl_tmrUnSubscribe ( tim_handle, Led_TimerHandler, ADL_TMR_TYPE_100MS);
	   }

}


/***************************************************************************/
/*  Function   : CKEV_Handler											   */
/*-------------------------------------------------------------------------*/
/*  Object     : CKEV_Handler					                          */
/*                                                                         */
/*-------------------------------------------------------------------------*/
/*  Variable Name     |IN |OUT|GLB|  Utilisation                           */
/*--------------------+---+---+---+----------------------------------------*/
/*  gpio_handle       |   |   |   |			                               */
/*--------------------+---+---+---+----------------------------------------*/
/*  gpio_result       |   |   |   |				                           */
/*--------------------+---+---+---+----------------------------------------*/
/***************************************************************************/
bool CKEV_Handler(adl_atUnsolicited_t *paras)
{
	ascii key_nb[3];	// key number
	ascii key_st[3];	// key status (ON=1 OFF=0)

	u8 kn,ks;

	TRACE (( 1, "CKEV" ));


	wm_memset(&key_nb,0x00,sizeof(key_nb));
	wm_memset(&key_st,0x00,sizeof(key_st));


	wm_strGetParameterString ( key_nb, paras->StrData, 1 );
	kn = wm_atoi(key_nb); // key number
	TRACE (( 1, "KEY_NB=%d",kn));

	wm_strGetParameterString ( key_st, paras->StrData, 2 );
	ks = wm_atoi(key_st); // key status
	TRACE (( 1, "KEY_ST=%d",ks));

	if(!tim_count)	// active alarm only if previus alarm is terminated
	{
		//if(!wm_strcmp(res,"0"))
		if(kn==0 && ks==0) // key number 0 release
		{

			// Send sms
			TRACE (( 1, "Alarm activated...send sms" ));
			adl_smsSend (sms_handle, phone_number, sms_text, ADL_SMS_MODE_TEXT);


			// Set 500ms cyclic  led timer
			TRACE (( 1, "Start led timer" ));
			tim_handle = adl_tmrSubscribe ( TRUE, 5, ADL_TMR_TYPE_100MS, Led_TimerHandler );

		}
	}

	return TRUE;

}

/***************************************************************************/
/*  Function   : SMS_Control_f											   */
/*-------------------------------------------------------------------------*/
/*  Object     : SMS_Control_f											   */
/*                                                                         */
/*-------------------------------------------------------------------------*/
/*  Variable Name     |IN |OUT|GLB|  Utilisation                           */
/*--------------------+---+---+---+----------------------------------------*/
/*  Event			  |   |   |   |			                               */
/*--------------------+---+---+---+----------------------------------------*/
/*  Nb			      |   |   |   |				                           */
/*--------------------+---+---+---+----------------------------------------*/
/***************************************************************************/
void SMS_Control_f(u8 Event,u16 Nb)
{
	if(Event == ADL_SMS_EVENT_SENDING_OK)
	{

		TRACE((1,"SMS SEND OK"));
		adl_atSendResponse (ADL_AT_RSP, "\r\nSMS SEND OK\r\n");
	}
	if(Event == ADL_SMS_EVENT_SENDING_ERROR)		// can be here if no credit
	{

		TRACE((1,"SMS SENDING ERROR"));
		adl_atSendResponse (ADL_AT_RSP, "\r\nSMS SENDING ERROR\r\n");
	}
}

/***************************************************************************/
/*  Function   : SMS_Handler_f											   */
/*-------------------------------------------------------------------------*/
/*  Object     : SMS_Handler_f											   */
/*                                                                         */
/*-------------------------------------------------------------------------*/
/*  Variable Name     |IN |OUT|GLB|  Utilisation                           */
/*--------------------+---+---+---+----------------------------------------*/
/*  SmsTel			  |   | X |   |			                               */
/*--------------------+---+---+---+----------------------------------------*/
/*  SmsTimeOrLength   |   | X |   |				                           */
/*--------------------+---+---+---+----------------------------------------*/
/*	SmsText			  |	  | X |   |										   */
/*--------------------+---+---+---+----------------------------------------*/
/***************************************************************************/
bool SMS_Handler_f(ascii *SmsTel, ascii *SmsTimeOrLength, ascii *SmsText)
{
	TRACE((1,"SMS ricevuto:"));
	TRACE((1,SmsText));
	TRACE((1,SmsTel));
	return TRUE;
}

/***************************************************************************/
/*  Function   : appSimHandler                                             */
/*-------------------------------------------------------------------------*/
/*  Object     : Handler to receive SIM related events                     */
/*                                                                         */
/*  Return     :                                                           */
/*                                                                         */
/*                                                                         */
/*-------------------------------------------------------------------------*/
/*  Variale Name     |IN |OUT|GLB|  Utilisation                           */
/*--------------------+---+---+---+----------------------------------------*/
/*                    |   |   |   |                                        */
/*--------------------+---+---+---+----------------------------------------*/
/***************************************************************************/
void appSimHandler (u8 Event)
{

  TRACE((1,"APP SIM EVENT HANDLER"));
  switch (Event)
  {
    case ADL_SIM_STATE_FULL_INIT:

	  TRACE (( 1, "ADL_SIM_STATE_FULL_INIT"));

	  // SMS subscribe
	  sms_handle = adl_smsSubscribe(SMS_Handler_f,SMS_Control_f,ADL_SMS_MODE_TEXT);
	  TRACE((1,"sms_handle= %d",sms_handle));
      break;

    case ADL_SIM_STATE_PIN_WAIT:
	  TRACE((1,"\r\nADL_SIM_STATE_PIN_WAIT\r\n"));
      adl_atSendResponse (ADL_AT_RSP, "\r\nADL_SIM_STATE_PIN_WAIT\r\n");
      break;

    case ADL_SIM_STATE_PIN_ERROR:
	  TRACE((1, "\r\nADL_SIM_STATE_PIN_ERROR\r\n"));
      adl_atSendResponse (ADL_AT_RSP, "\r\nADL_SIM_STATE_PIN_ERROR\r\n");
      break;

    default:
      TRACE (( 1, "SIM Event = %d", Event ));
      break;
  }

  return;
}

/***************************************************************************/
/*  Function   : adl_at_CMER_response_handler							   */
/*-------------------------------------------------------------------------*/
/*  Object     : adl_at_CMER_response_handler                               */
/*                                                                         */
/*-------------------------------------------------------------------------*/
/*  Variable Name     |IN |OUT|GLB|  Utilisation                           */
/*--------------------+---+---+---+----------------------------------------*/
/*  gpio_handle       |   |   |   |			                               */
/*--------------------+---+---+---+----------------------------------------*/
/*  gpio_result       |   |   |   |				                           */
/*--------------------+---+---+---+----------------------------------------*/
/***************************************************************************/
void adl_at_CMER_response_handler(adl_atResponse_t *at_str_pars)
{
	// nothing to do
	 TRACE (( 1, "CMER" ));

}

/***************************************************************************/
/*  Function   : adl_main                                                  */
/*-------------------------------------------------------------------------*/
/*  Object     : Customer application initialisation                       */
/*                                                                         */
/*-------------------------------------------------------------------------*/
/*  Variable Name     |IN |OUT|GLB|  Utilisation                           */
/*--------------------+---+---+---+----------------------------------------*/
/*  InitType          |   |   |   |  Application start mode reason         */
/*--------------------+---+---+---+----------------------------------------*/
/***************************************************************************/
void adl_main ( adl_InitType_e  InitType )
{
	s8 res;

	//adl_ioDefs_t Gpio_to_write1 = ADL_IO_GPIO | 0 ;

	TRACE (( 1, "Embedded : Appli Init" ));

	tim_count = 0;	// init timer counter

    // Subscribe GPIO0 output
   	myGpioOut_Handle = adl_ioSubscribe(NUM_GPIO,Gpio_Config,0,0,0);
   	TRACE (( 1, "handler returns %d", myGpioOut_Handle ));

    // Subscribe keypad
    adl_atCmdCreate("AT+CMER=,1",FALSE,(adl_atRspHandler_t)adl_at_CMER_response_handler,"*",NULL);

    // Subscribe the '+CKEV: unsolicited response
    adl_atUnSoSubscribe("+CKEV: ",(adl_atUnSoHandler_t)CKEV_Handler);

    // Subscribe to SIM service to send and receive sms
    res = adl_simSubscribe ( (adl_simHdlr_f) appSimHandler, NULL);
}
