

/***************************************************************************/
/*  Include files                                                          */
/***************************************************************************/

#include "adl_global.h"
#include "test_memoria.h"

/***************************************************************************/
/*  Mandatory variables                                                    */
/*-------------------------------------------------------------------------*/
/*  wm_apmCustomStack                                                      */
/*  wm_apmCustomStackSize                                                  */
/*-------------------------------------------------------------------------*/
/***************************************************************************/
u32 wm_apmCustomStack [ 256 ];
const u16 wm_apmCustomStackSize = sizeof ( wm_apmCustomStack );


/***************************************************************************/
/*  Local variables                                                        */
/***************************************************************************/

ascii *data_handle = "datahandle";			// handle for data
t_data_name DataName[MAX_DATA_NAME];
t_data_work DataWork[MAX_DATA_WORK];




/***************************************************************************/
/*  Function   : SetDataName	  									       */
/***************************************************************************/
void SetDataName(u8 indice,ascii *id,ascii *nome,ascii *cognome)
{
	wm_strcpy(DataName[indice].id,id);
	wm_strcpy(DataName[indice].nome,nome);
	wm_strcpy(DataName[indice].cognome,cognome);
}

/***************************************************************************/
/*  Function   : SetDataWork											   */
/***************************************************************************/
void SetDataWork (u8 indice, ascii *id,ascii *impiego, ascii *hh_start, ascii *hh_stop)
{
	wm_strcpy(DataWork[indice].id,id);
	wm_strcpy(DataWork[indice].impiego, impiego);
	wm_strcpy(DataWork[indice].hh_start, hh_start);
	wm_strcpy(DataWork[indice].hh_stop, hh_stop);
}

/***************************************************************************/
/*  Function   :adl_main												   */
/***************************************************************************/
void adl_main( adl_InitType_e InitType )
{	
	s8 res;
	u8 i;
	ascii buffer[255];
	
	// Inizializza le strutture dati
	wm_memset(&DataName,0x00,sizeof(DataName));
	wm_memset(&DataWork,0x00,sizeof(DataWork));

	// Subscribe object in flash memory
	res = adl_flhSubscribe(data_handle,2);	// sottoscrive la object data flash con 2 ID.
	TRACE((1,"Creazione handle object data=%d",res)); 
	
	if(res == ADL_RET_ERR_ALREADY_SUBSCRIBED)
	{
		TRACE((1,"Oggetto in flash gi presente\n"));
		
		res = adl_flhRead(data_handle,0,sizeof(DataName),&DataName);	// Legge obj ID 0
		TRACE((1,"Lettura memoria adl_flhRead =%d",res)); 
		
		// Stampa sulla seriale il contenuto dellobject flash DataName
		adl_atSendResponse (ADL_AT_RSP,"DataName:\n\r");
		
		for(i=0;i< MAX_DATA_NAME;i++)
		{
			wm_memset(buffer,0x00,sizeof(buffer));
			wm_sprintf (buffer,"%s %s %s\n\r",&DataName[i].id,&DataName[i].nome,&DataName[i].cognome);
			adl_atSendResponse (ADL_AT_RSP,buffer);
		}
		
		res = adl_flhRead(data_handle,1,sizeof(DataWork),&DataWork);	// Legge obj ID 1
		TRACE((1,"Lettura memoria adl_flhRead =%d",res)); 
		
		// Stampa sulla seriale il contenuto dellobject flash DataWork
		adl_atSendResponse (ADL_AT_RSP,"DataWork:\n\r");
		
		for(i=0;i< MAX_DATA_WORK;i++)
		{
			wm_memset(buffer,0x00,sizeof(buffer));
			wm_sprintf (buffer,"%s %s %s %s\n\r",DataWork[i].id, DataWork [i].impiego, DataWork[i].hh_start, DataWork [i].hh_stop);
			adl_atSendResponse (ADL_AT_RSP,buffer);
		}
		
		
	}
	
	else if(res == ADL_RET_ERR_PARAM || res == ADL_FLH_RET_ERR_NO_ENOUGH_IDS)
	{
		TRACE((1,"Errore sottoscrizione ID memoria"));
	}
	
	else if (res == OK)  // Nuova sottoscrizione riuscita
	{
		// Popola il database DataName
		SetDataName(0,"2454","Nicola","Friso");
		SetDataName (1,"2223","Mario","Rossi");
		SetDataName (2,"3454","Federico","Tosato");
		SetDataName (3,"2234","Marco","Bianchi");
		SetDataName (4,"0102","Francesco","Trota");
		
		// Popola il database DataWork
		SetDataWork(0,"2454","Progettista","9.00","17.30");
		SetDataWork (1,"2223","Impiegato amministrativo","9.00","17.30");
		SetDataWork (2,"0102","Impiegato amministrativo","9.00","17.30");
		SetDataWork (3,"2234","Tecnico specializzato","8.00","17.00");
		SetDataWork (4,"3454","Progettista","9.00","18.00");
		
		// Scrive un nuovo oggetto in object flash
		TRACE((1,"Creo nuovo oggetto in flash: DataName\n"));
		res = adl_flhWrite(data_handle,0,sizeof(DataName),&DataName);

		TRACE((1,"Creo nuovo oggetto in flash: DataWork\n"));
		res = adl_flhWrite(data_handle,1,sizeof(DataWork),&DataWork);

		
	}
}




