/*
 * Chapter 11
 *
 * The microcontroller blinks two LEDs connected to PA0 and PA2 pin.
 *
 */

#include "../Headers/main.h"

void _own_delay_ms(unsigned int delay)
{
	//inner variables
	static unsigned int counter;
	static unsigned int time;
	//reset the elapsed time counter
	time = 0;
	//run the loop, while elapsed time is smaller than requested delay
	while(delay > time)
	{
		//reset the counter at each cycle
		counter = 0;
		//increment the counter until 1195
		//this means about 1ms delay
		while(counter <= 1195)
		{
			counter++;
		}
		//increment the elapsed time counter
		time++;
	}
}


int main(void)
{
    //Initializing ports
    IOInit();

    //Infinite loop - blinking the LED
    while (1)
    {
        //Turn ON LED1 and turn OFF LED2
        sbi(PORTA,0);
		cbi(PORTA,2);		
		//Waiting
		_own_delay_ms(500);		// You can use the _own_delay_ms() or the _delay_ms() function as well
        //Turn OFF LED1 and turn ON LED2
        cbi(PORTA,0);
        sbi(PORTA,2);		
		//Waiting
		_own_delay_ms(500);		// You can use the _own_delay_ms() or the _delay_ms() function as well
    }

    //Due to the Infinite loop, the software will never enter this region. However, this line is required by the compiler
    return 0;
}