#!/bin/sh
###################################################

BINUTILS_REV=${BINUTILS_REV:-binutils-2.9.1}
EGCS_REV=${EGCS_REV:-egcs-1.1.2}
NEWLIB_REV=${NEWLIB_REV:-newlib-1.8.1}

# 1. merge the include dirs for binutils and egcs
#    with egcs taking precedence.
(cd $EGCS_REV/include && tar cf - .) | (cd $BINUTILS_REV/include && tar xf -)
(cd $BINUTILS_REV/include && tar cf - .) | (cd $EGCS_REV/include && tar xf -)

# 2. move the binutils directories into the egcs-onetree
for dir in bfd binutils gas gprof ld opcodes ; do
	mv $BINUTILS_REV/$dir $EGCS_REV
done

# 3. move the newlib directories into the egcs-onetree
for dir in libgloss newlib ; do
	mv $NEWLIB_REV/$dir $EGCS_REV
done

# 4. get rid of raided distdirs and rename egcs-1.1.2 to src
rm -fr binutils-2.9.1
rm -fr newlib-1.8.1
mv $EGCS_REV src

