#!/bin/sh

# This variable is the program used to install files and directories.
# Normally it is "cp -pr", but it could also be "mv".
install="cp -rp"

# This variable is the program used to create symbolic links.  If your
# operating system doesn't support symbolic links, you might want to
# change this to "ln" or "cp -p".
link="ln -s"

# This variable specifies the directory that will contain the Scheme
# executable programs.
bindir=$1/bin

# This variable specifies the directory that will contain the
# auxiliary files required by Scheme:
libdir="$1/lib/mit-scheme"

# This variable says whether or not to delete the files "compdel.com"
# and "eddel.com" after they have been used to create the
# "compiler.com" and "edwin.com" files.  If you want to keep these
# files, comment out this definition.
deletedeltas="yes"

# This variable specifies the directory where GNU Emacs "Info" files
# are stored.  If you don't have such a directory, comment out this
# line.
#infodir=$1/info

# This variable specifies where the GNU Emacs "xscheme.el" program
# should be installed.  This program is used to run Scheme as a
# subprocess under GNU Emacs.  An older version of this program is
# distributed with GNU Emacs, but you should always use the version
# distributed with Scheme.  If you don't need this program, comment
# out this line.
#emacslisp="/usr/local/lib/emacs/lisp"

# This variable specifies where the GNU Emacs "movemail" program can
# be found.  This program is used by Edwin for the same purpose,
# namely to fetch mail from the user's mailbox when running RMAIL.  If
# you don't have this program, comment out this line.
#movemail="/usr/local/lib/emacs/etc/movemail"

mkdir -p ${libdir}

if [ -f "${libdir}/edwin.com" ]
then
  rm -f ${libdir}/edwin.com
fi
if [ -f "${libdir}/compiler.com" ]
then
  rm -f ${libdir}/compiler.com
fi

${install} lib/* ${libdir}

if [ "${libdir}" = "/usr/local/lib/mit-scheme" ]
then
  ${install} bin/* ${bindir}
else
  (cd bin
   for i in *
   do
     if [ "${i}" = "scheme" -o "${i}" = "bchscheme" ]
     then
       ${install} ${i} ${libdir}
       file="${bindir}/${i}"
       rm -f ${file}
       echo "#!/bin/sh" > ${file}
       echo "MITSCHEME_LIBRARY_PATH=${libdir}" >> ${file}
       echo "export MITSCHEME_LIBRARY_PATH" >> ${file}
       echo "exec ${libdir}/$i \$@" >> ${file}
       chmod 755 ${file}
     else
       ${install} ${i} ${bindir}
     fi
   done)
fi

if [ "${emacslisp}" != "" ]
then
  ${install} etc/xscheme.el etc/xscheme.elc ${emacslisp}
fi

if [ "${infodir}" != "" ]
then
  ${link} ${infodir} ${libdir}/edwin/info
fi

if [ "${movemail}" != "" ]
then
  ${link} ${movemail} ${libdir}/edwin/etc/movemail
fi

if [ ! -f "${libdir}/compiler.com" ]
then
  ${bindir}/scheme -large -no-init-file -load etc/make-compiler-band.scm
  if [ "${deletedeltas}" = "yes" ]
  then
    rm -f ${libdir}/compdel.com
  fi
fi

if [ ! -f "${libdir}/edwin.com" ]
then
  ${bindir}/scheme -large -no-init-file -load etc/make-edwin-band.scm
  if [ "${deletedeltas}" = "yes" ]
  then
    rm -f ${libdir}/eddel.com
  fi
fi

