
$FreeBSD: ports/lang/erlang/files/patch-lib_gs_src_tool__utils.erl,v 1.1 2003/09/06 13:12:46 olgeni Exp $

--- lib/gs/src/tool_utils.erl.orig	Thu Sep  4 23:01:37 2003
+++ lib/gs/src/tool_utils.erl	Fri Sep  5 00:16:20 2003
@@ -27,6 +27,9 @@
 -export([file_dialog/1]).
 -export([notify/2, confirm/2, confirm_yesno/2, request/2]).
 
+%% Browser executable list (openURL command line protocol required)
+-define(BROWSERS, ["netscape", "mozilla", "MozillaFirebird", "opera"]).
+
 %%----------------------------------------------------------------------
 %% open_help(GS, File)
 %%   GS = gsobj()  (GS root object returned by gs:start/0,1)
@@ -51,7 +54,7 @@
 	local ->
 	    Cmd = case os:type() of
 		      {unix,_AnyType} ->
-			  "netscape -remote \"openURL(file:" ++ File ++ ")\"";
+			  unix_url_command("file:" ++ File);
 
 		      {win32,_AnyType} ->
 			  "start " ++ filename:nativename(File)
@@ -62,7 +65,7 @@
 	remote ->
 	    Cmd = case os:type() of
 		      {unix,_AnyType} ->
-			  "netscape -remote \"openURL(" ++ File ++ ")\"";
+			  unix_url_command(File);
 
 		      {win32,_AnyType} ->
 			  "netscape.exe -h " ++ regexp:gsub(File,"\\\\","/")
@@ -307,3 +310,54 @@
     [Last];
 insert_newlines(Other) ->
     Other.
+
+%% find_browser(BrowserList) => string() | false
+%%   BrowserList - [string()]
+%% Given a list of basenames, find the first available executable.
+
+find_browser([]) ->
+    false;
+
+find_browser([H | T]) ->
+    case os:find_executable(H) of
+        false ->
+          find_browser(T);
+        Browser ->
+          Browser
+    end.
+
+%% unix_url_command(URL) => string()
+%%   URL - string()
+%% Open an URL, using a browser which supports the openURL command
+%% line protocol. If no browser is found, the empty string will be
+%% returned.
+
+unix_url_command(URL) ->
+    Template = "BROWSER -remote \"openURL(" ++ URL ++ ")\" || BROWSER " ++ URL ++ "&",
+
+    case os:getenv("BROWSER") of
+        false ->
+            %% look for a compatible browser
+            case find_browser(?BROWSERS) of
+                false ->
+                    "";
+                Browser ->
+                    case regexp:gsub(Template, "BROWSER", Browser) of
+                        {ok, Command, 0} ->
+                            %% Template does not contain "BROWSER" placeholder
+                            "";
+                        {ok, Command, _} ->
+                            Command
+                    end
+            end;
+
+        Value ->
+            case regexp:gsub(Template, "BROWSER", Value) of
+                {ok, Command2, 0} ->
+                    %% no placeholder
+                    "";
+                {ok, Command2, _} ->
+                    Command2
+            end
+    end.
+
