# New ports collection makefile for:	Mono and it's consumers
# Date created:				15 October 2005
# Whom:					Tom McLaughlin <tmclaugh@FreeBSD.org>
#
# bsd.mono.mk: accomodate the peculiarities of building C# ports within
# the FreeBSD ports system.
#
# $FreeBSD: ports/lang/mono/bsd.mono.mk,v 1.5 2006/10/07 17:39:36 tmclaugh Exp $
#   $Id: bsd.mono.mk,v 1.15 2006/07/05 04:22:22 tmclau02 Exp $
#

# USE_NANT		- If set, the port uses nant.
# USE_NANT		- If set "contrib", the port uses nantcontrib.
# NANT			- Set to path of Nant.

# Set the location of the .wapi directory so we write to a location we
# can always assume to be writable.
MONO_SHARED_DIR=${WRKDIR}
CONFIGURE_ENV+=MONO_SHARED_DIR="${MONO_SHARED_DIR}"
MAKE_ENV+=MONO_SHARED_DIR="${MONO_SHARED_DIR}"

# Set the location that webaps served by XSP should use.
XSP_DOCROOT=${PREFIX}/www/xsp

# Clean up the semaphore produced by the .wapi
post-install: mono-semdel
pre-clean: mono-semdel

mono-semdel:
	@${SETENV} G_DEBUG="" MONO_SHARED_DIR="${MONO_SHARED_DIR}" ${LOCALBASE}/bin/mono-semdel 2> /dev/null || true


# Dependencies 

.if defined(USE_NANT)
BUILD_DEPENDS+=	nant:${PORTSDIR}/devel/nant
.if ${USE_NANT}=="contrib"
BUILD_DEPENDS+=	${LOCALBASE}/share/NAnt/bin/NAnt.Contrib.Tests.dll:${PORTSDIR}/devel/nantcontrib
.endif
.endif

# Miscellaneous overridable commands:

NANT?=	nant
NANT_INSTALL_TARGET?=	install

# Build
.if defined(USE_NANT)
.if !target(do-build)
do-build:
	@(cd ${BUILD_WRKSRC}; ${SETENV} MONO_SHARED_DIR="${MONO_SHARED_DIR}" ${NANT} ${NANT_FLAGS})
.endif
.endif


# Install
.if defined(USE_NANT)
.if !target(do-install)
do-install:
	@(cd ${INSTALL_WRKSRC}; ${SETENV} MONO_SHARED_DIR="${MONO_SHARED_DIR}" ${NANT} ${NANT_FLAGS} -D:prefix="${PREFIX}" ${NANT_INSTALL_TARGET})
.endif
.endif
