--- audio.h	Thu Aug 21 10:00:18 1997
+++ audio.h	Wed Apr 13 00:21:47 2005
@@ -9,6 +9,7 @@
 #include <stdio.h>
 
 struct AUDIO_HEADER {
+	int IDex;
 	int ID;
 	int layer;
 	int protection_bit;
@@ -55,8 +56,8 @@
 
 extern int scalefac_l[2][2][22];
 extern int scalefac_s[2][2][13][3];
-extern int t_b8_l[2][3][22];
-extern int t_b8_s[2][3][13];
+extern int t_b8_l[2][2][3][22];
+extern int t_b8_s[2][2][3][13];
 extern short t_bitrate[2][3][15];
 
 extern int is[2][578];
@@ -64,7 +65,7 @@
 
 extern int *t_l,*t_s;
 extern int nch;
-extern int t_sampling_frequency[2][3];
+extern int t_sampling_frequency[2][2][3];
 
 extern int A_QUIET,A_SHOW_CNT,A_FORMAT_WAVE,A_DUMP_BINARY;
 extern int A_WRITE_TO_AUDIO,A_WRITE_TO_FILE;
@@ -106,9 +107,14 @@
 
 int *t_l,*t_s;
 int nch;
-int t_sampling_frequency[2][3] = {
-{ 22050 , 24000 , 16000},
-{ 44100 , 48000 , 32000}
+int t_sampling_frequency[2][2][3] = {
+	{ /* MPEG 2.5 samplerates */ 
+  		{ 11025, 12000, 8000},
+		{ 0, }
+	},{ /* MPEG 2.0/1.0 samplerates */
+		{ 22050 , 24000 , 16000},
+		{ 44100 , 48000 , 32000}
+	}
 };
 
 /* GUI control stuff */
@@ -143,28 +149,47 @@
 /* the last sfb is given implicitly on pg.28. of the standard. scalefactors 
  * for that one are 0, pretab also 
  */
+/* The new leftmost index is for IDex, so the first six (only three used)
+   are for MPEG 2.5, and the next six are for MPEG 1.0, 2.0 
+*/
 /* leftmost index denotes ID, so first three tables are for MPEG2 (header->ID==0)
  * and the other three are for MPEG1 (header->ID==1)
  */
 /* 22.05, 24, 16 */
-int t_b8_l[2][3][22]={{ /* table B.8b ISO/IEC 11172-3 */
-{5,11,17,23,29,35,43,53,65,79,95,115,139,167,199,237,283,335,395,463,521,575},
-{5,11,17,23,29,35,43,53,65,79,95,113,135,161,193,231,277,331,393,463,539,575},
-{5,11,17,23,29,35,43,53,65,79,95,115,139,167,199,237,283,335,395,463,521,575}
-},{
-{3,7,11,15,19,23,29,35,43,51,61,73,89,109,133,161,195,237,287,341,417,575},
-{3,7,11,15,19,23,29,35,41,49,59,71,87,105,127,155,189,229,275,329,383,575},
-{3,7,11,15,19,23,29,35,43,53,65,81,101,125,155,193,239,295,363,447,549,575}
-}};   
-int t_b8_s[2][3][13]={{ /* table B.8b ISO/IEC 11172-3 */
-{3,7,11,17,23,31,41,55,73,99,131,173,191},
-{3,7,11,17,25,35,47,61,79,103,135,179,191},
-{3,7,11,17,25,35,47,61,79,103,133,173,191}
-},{
-{3,7,11,15,21,29,39,51,65,83,105,135,191},
-{3,7,11,15,21,27,37,49,63,79,99,125,191},
-{3,7,11,15,21,29,41,57,77,103,137,179,191}
-}};
+int t_b8_l[2][2][3][22]={
+	{{   /* MPEG 2.5; This table probably isn't correct. */
+		{5,11,17,23,29,35,43,53,65,79,95,115,139,167,199,237,283,335,395,463,521,575},
+		{5,11,17,23,29,35,43,53,65,79,95,115,139,167,199,237,283,335,395,463,521,575},
+		{11,23,35,47,59,71,87,107,131,159,191,231,279,335,399,475,565,567,569,571,573,575}
+	},{
+		{0,},
+	}},{{ /* table B.8b ISO/IEC 11172-3 (MPEG 1.0/2.0) */
+		{5,11,17,23,29,35,43,53,65,79,95,115,139,167,199,237,283,335,395,463,521,575},
+		{5,11,17,23,29,35,43,53,65,79,95,113,135,161,193,231,277,331,393,463,539,575},
+		{5,11,17,23,29,35,43,53,65,79,95,115,139,167,199,237,283,335,395,463,521,575}
+	},{
+		{3,7,11,15,19,23,29,35,43,51,61,73,89,109,133,161,195,237,287,341,417,575},
+		{3,7,11,15,19,23,29,35,41,49,59,71,87,105,127,155,189,229,275,329,383,575},
+		{3,7,11,15,19,23,29,35,43,53,65,81,101,125,155,193,239,295,363,447,549,575}
+	}}
+};   
+int t_b8_s[2][2][3][13]={
+	{{ /* MPEG 2.5; This table probably isn't correct. */
+		{3,7,11,17,25,35,47,61,79,103,133,173,191},
+		{3,7,11,17,25,35,47,61,79,103,133,173,191},
+		{7,15,23,35,51,71,95,123,159,161,163,165,167}
+	},{
+		{0,},
+	}},{{ /* table B.8b ISO/IEC 11172-3 */
+		{3,7,11,17,23,31,41,55,73,99,131,173,191},
+		{3,7,11,17,25,35,47,61,79,103,135,179,191},
+		{3,7,11,17,25,35,47,61,79,103,133,173,191}
+	},{
+		{3,7,11,15,21,29,39,51,65,83,105,135,191},
+		{3,7,11,15,21,27,37,49,63,79,99,125,191},
+		{3,7,11,15,21,29,41,57,77,103,137,179,191}
+	}}
+};
 
 int  args(int argc,char **argv);
 void initialise_decoder(void);
