--- regex.c.orig	Mon Feb 24 14:52:12 2003
+++ regex.c	Thu Nov  2 13:35:27 2006
@@ -554,12 +554,12 @@
  * the bitset form, since we may wish to extend it
  * in the future for other character classifications. 
  *
- *	TRUE for 0-9 A-Z a-z _
+ *	TRUE for 0-9 A-Z a-z _ - -
  */
 static char chrtyp[MAXCHR] = {
-	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
-	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
-	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
+	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
+	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
+	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
 	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
 	0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 
 	1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 
@@ -569,10 +569,23 @@
 	1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 
 	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
 	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
-	1, 1, 1, 0, 0, 0, 0, 0
+	1, 1, 1, 0, 0, 0, 0, 0, 0, 0,	// 120-129
+	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // 130-139
+	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // 140-149
+	0, 0, 0, 1, 0, 0, 0, 0, 0, 0,   // 160-169     163=
+	0, 0, 0, 0, 0, 0, 0, 0, 0, 1,   // 170-179     179=
+	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // 180-189
+	0, 0, 1, 1, 1, 1, 1, 1, 1, 1,   // 190-199
+	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,   // 200-209
+	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,   // 210-219
+	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,   // 220-229
+	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,   // 230-239
+	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,   // 240-249
+	1, 1, 1, 1, 1, 1                // 250-255
 	};
 
-#define inascii(x)	(0177&(x))
+//#define inascii(x)	(0177&(x))
+#define inascii(x)	(0255&(x))
 #define iswordc(x) 	chrtyp[inascii(x)]
 #define isinset(x, y) 	((x)[((y)&BLKIND)>>3] & (1<<((y)&BITIND)))
 
@@ -583,7 +596,7 @@
 
 #define ANYSKIP	2 	/* CLO ANY END ...	   */
 #define CHRSKIP	3	/* CLO CHR chr END ...	   */
-#define CCLSKIP 18	/* CLO CCL 16bytes END ... */
+#define CCLSKIP BITBLK+2       /* CLO CCL 32bytes END ... */
 
 static char *
 pmatch(prog, lp, ap)
