#!/bin/sh
#
# Under a BSDL license. Copyright by Mario S F Ferreira <lioux@FreeBSD.org>
# $FreeBSD: ports/portuguese/irpf-pt_BR/files/wrapper.sh,v 1.2 2007/03/06 03:39:52 lioux Exp $

export JAVA_VERSION

PREFIX="%%PREFIX%%"
# java
JAVA_VERSION="%%JAVA_VERSION%%"
JAVAVM="%%JAVAVM%%"
JAR_DIR="%%JAR_DIR%%"
JAR_FILES="%%JAR_FILES%%"
JAR_FILE="%%JAR_FILE%%"
# home
HOME_DIR=${HOME}/.irpf

configure_java_classpath () {
  if [ -z "${CLASSPATH}" ]
  then
        CLASSPATH=./irpf.jar:./jhall.jar
  else
        CLASSPATH=./irpf.jar:./jhall.jar:${CLASSPATH}
  fi
}

prepare_home_dir () {
  # create home dir staging area
  if [ ! -d ${HOME_DIR}/aplicacao/dados ]
  then
	mkdir -p ${HOME_DIR}/aplicacao/dados
  fi
  # link the jar files
  for jar in ${JAR_FILES}
  do
	rm -f ${HOME_DIR}/${jar} 2>/dev/null
	cp -f ${PREFIX}/${JAR_DIR}/${jar} ${HOME_DIR}/${jar} 2>/dev/null
  done
}

start_irpf () {
  cd ${HOME_DIR} &&
	${JAVAVM} -jar ./${JAR_FILE} "${@}"
}

clean_home_dir () {
  # remove the jar files
  for jar in ${JAR_FILES}
  do
	if [ -f ${HOME_DIR}/${jar} ]
	then
		rm -f ${HOME_DIR}/${jar} 2>/dev/null
	fi
  done
}

# always verify that home dir staging area is pristine
prepare_home_dir

# prepare java CLASSPATH
configure_java_classpath

start_irpf

# remove jars
clean_home_dir
