--- src/Resources.hh
+++ src/Resources.hh
@@ -8,8 +8,10 @@
 #include <cstdio>
 #include <cstring>
 
+namespace FbTk {
+
 template<>
-void FbTk::Resource<bool>::
+void Resource<bool>::
 setFromString(char const *strval) {
     if (strcasecmp(strval, "true") == 0 ||
         strcasecmp(strval, "yes") == 0)
@@ -19,38 +21,37 @@
 }
 
 template<>
-std::string FbTk::Resource<bool>::
+std::string Resource<bool>::
 getString() {				
     return std::string(**this == true ? "true" : "false");
 }
 
 template <>
-void FbTk::Resource<std::string>::setFromString(const char *str) {
+void Resource<std::string>::setFromString(const char *str) {
     *(*this) = (str ?  str : "");
 }
 
 template <>
-std::string FbTk::Resource<std::string>::getString() {
+std::string Resource<std::string>::getString() {
     return *(*this);
 }
 
 template <>
-void FbTk::Resource<int>::setFromString(const char *str) {
+void Resource<int>::setFromString(const char *str) {
     if (str == 0)
         return;
     sscanf(str, "%d", &(*(*this)));
 }
 
 template <>
-std::string FbTk::Resource<int>::getString() {
+std::string Resource<int>::getString() {
     char buff[16];
     sprintf(buff, "%d", (*(*this)));
     return std::string(buff);
 }
 
-namespace FbPager {
 template <>
-void FbTk::Resource<FbPager::Alignment>::setFromString(const char *str) {
+void Resource<FbPager::FbPager::Alignment>::setFromString(const char *str) {
     if (strcmp("TopToBottom", str) == 0)
         *(*this) = FbPager::FbPager::TOP_TO_BOTTOM;
     else
@@ -58,7 +59,7 @@
 }
 
 template <>
-std::string FbTk::Resource<FbPager::Alignment>::getString() {
+std::string Resource<FbPager::FbPager::Alignment>::getString() {
     switch (*(*this)) {
     case FbPager::FbPager::LEFT_TO_RIGHT:
         return "LeftToRight";
@@ -67,6 +68,6 @@
     }
 }
 
-} // end namespace FbPager
+} // end namespace FbTk
 
 #endif // RESOURCES
