#!/bin/sh
#
# $FreeBSD: ports/net-p2p/mldonkey-devel/files/mlnet.sh,v 1.3 2006/02/20 20:47:35 dougb Exp $
#
# Under a BSDL license. Copyright 2005. Mario S F Ferreira <lioux@FreeBSD.org>

# PROVIDE: mlnet
# REQUIRE: LOGIN
# KEYWORD: shutdown

#
# Add the following lines to /etc/rc.conf to enable mlnet:
#
#mlnet_enable="YES"
#mlnet_user=""
#mlnet_flags=""
#mlnet_logfile=""
#

. /etc/rc.subr

name="mlnet"
rcvar=`set_rcvar`
command="%%PREFIX%%/bin/${name}"
procname="%%PREFIX%%/bin/${name}-real"

load_rc_config "${name}"
: ${mlnet_enable="NO"}
: ${mlnet_user="$(whoami)"}
: ${mlnet_flags=""}
: ${mlnet_logfile=""}

pidfile="$(eval echo ~${mlnet_user}/.mldonkey/$(basename ${procname}).pid)"
required_dirs="$(eval echo ~${mlnet_user})"

mlnet_check_vars()
{
  if [ "x${mlnet_user}" = "xroot" ]; then
    warn "You have to set mlnet_user to a non-root user for security reasons"
    return 1
  fi

  return 0
}

start_precmd="mlnet_check_vars"
start_cmd="start_cmd"
start_cmd()
{
  if [ -n "${mlnet_logfile}" ]; then
    mlnet_logcommand="-log_file ${mlnet_logfile}"
  fi

  if [ "x${mlnet_user}" = "x$(whoami)" ]; then
    eval "${command} \
	${mlnet_logcommand} \
	${mlnet_flags} \
	>/dev/null &"
  else
    su -l ${mlnet_user} -c "${command} \
	${mlnet_logcommand} \
	${mlnet_flags} \
	>/dev/null &"
  fi
}

stop_precmd="mlnet_check_vars"

run_rc_command "$1"
