#!/bin/sh
#
# $FreeBSD: ports/net/openldap23-server/files/slapd.sh,v 1.17 2006/02/20 20:47:27 dougb Exp $
#

# PROVIDE: slapd
# REQUIRE: NETWORKING SERVERS
# BEFORE: securelevel
# KEYWORD: shutdown

#
# Add the following lines to /etc/rc.conf to enable slapd:
#
#slapd_enable="YES"
#slapd_flags='-h "ldapi://%2fvar%2frun%2fopenldap%2fldapi/ ldap://0.0.0.0/"'
#slapd_sockets="/var/run/openldap/ldapi"
#
# See slapd(8) for more flags
#
# The `-u' and `-g' flags are automatically extracted from slapd_owner,
# by default slapd runs under the non-privileged user id `ldap'. If you
# want to run slapd as root, override this in /etc/rc.conf with
#
#slapd_owner="DEFAULT"
#

. "%%RC_SUBR%%"

name="slapd"
rcvar=`set_rcvar`

command="%%PREFIX%%/libexec/slapd"
pidfile="%%LDAP_RUN_DIR%%/slapd.pid"
required_dirs="%%LDAP_RUN_DIR%%"
required_files="%%PREFIX%%/etc/openldap/slapd.conf"

start_precmd=start_precmd
start_postcmd=start_postcmd

# extract user and group, adjust ownership of directories and database

start_precmd()
{
  local slapd_ownername slapd_groupname

  case x"$slapd_owner" in
  ""|[Nn][Oo][Nn][Ee]|[Dd][Ee][Ff][Aa][Uu][Ll][Tt])
    ;;
  *)
    chown "$slapd_owner" "%%LDAP_RUN_DIR%%"
    chown -RL "$slapd_owner" "%%DATABASEDIR%%"
    chown "$slapd_owner" "%%PREFIX%%/etc/openldap/slapd.conf"

    slapd_ownername=`expr //"$slapd_owner" : //'\([^:]*\)'`
    slapd_groupname=`expr //"$slapd_owner" : //'.*:\([^:]*\)'`

    if [ -n "$slapd_ownername" ]; then
      rc_flags="$rc_flags -u $slapd_ownername"
    fi
    if [ -n "$slapd_groupname" ]; then
      rc_flags="$rc_flags -g $slapd_groupname"
    fi
    ;;
  esac
}

# adjust ownership of created unix sockets

start_postcmd()
{
  local socket seconds

  for socket in $slapd_sockets; do
    for seconds in 1 2 3 4 5; do
      [ -e "$socket" ] && break
      sleep 1
    done
    if [ -S "$socket" ]; then
      case "$slapd_owner" in
      ""|[Nn][Oo][Nn][Ee]|[Dd][Ee][Ff][Aa][Uu][Ll][Tt])
        ;;
      *)
        chown "$slapd_owner" "$socket"
        ;;
      esac
      chmod "$slapd_sockets_mode" "$socket"
    else
      warn "slapd: Can't find socket $socket"
    fi
  done
}

# read settings, set defaults
load_rc_config $name
: ${slapd_enable="NO"}
if [ -n "${slapd_args+set}" ]; then
  warn "slapd_args is deprecated, use slapd_flags"
  : ${slapd_flags="$slapd_args"}
else
  : ${slapd_flags=""}
fi
: ${slapd_owner="ldap:ldap"}
: ${slapd_sockets=""}
: ${slapd_sockets_mode="666"}

run_rc_command "$1"
