#!/bin/sh

PATH=/bin:/usr/bin:${LOCALBASE}/bin; export PATH

generate()
{
ENCODING="$1"
FONTTEXNAME="$2"
FONTNAME="$3"

if [ "$ENCODING" = "UTF8" ]; then
	NFSSENC=70
elif [ "$ENCODING" = "GB" ]; then
	NFSSENC=10
elif [ "$ENCODING" = "Bg5" ]; then
	NFSSENC=00
else
	echo "Unknown encoding !"
	exit 1
fi

FDDIR=texinput/${ENCODING}

FDNAME=c${NFSSENC}${FONTTEXNAME}.fd

mkdir -p ${FDDIR}

cat > ${FDDIR}/${FDNAME} << EOF
% This file is automatically generated by `basename $0`
\\def\\fileversion{0.0.1}
\\def\\filedate{`date +%Y/%m/%d`}
\\ProvidesFile{${FDNAME}}[\\filedate\\space\\fileversion]

\\DeclareFontFamily{C${NFSSENC}}{${FONTTEXNAME}}{\\hyphenchar \\font\\m@ne}

\\DeclareFontShape{C${NFSSENC}}{${FONTTEXNAME}}{m}{n}{<-> CJK * ${FONTNAME}}{}
\\DeclareFontShape{C${NFSSENC}}{${FONTTEXNAME}}{bx}{n}{<-> CJKb * ${FONTNAME}}{\\CJKbold}
\\DeclareFontShape{C${NFSSENC}}{${FONTTEXNAME}}{m}{sl}{<-> CJK * ${FONTNAME}sl}{}
\\DeclareFontShape{C${NFSSENC}}{${FONTTEXNAME}}{bx}{sl}{<-> CJKb * ${FONTNAME}sl}{\\CJKbold}
\\DeclareFontShape{C${NFSSENC}}{${FONTTEXNAME}}{m}{it}{<-> CJK * ${FONTNAME}sl}{}
\\DeclareFontShape{C${NFSSENC}}{${FONTTEXNAME}}{bx}{it}{<-> CJKb * ${FONTNAME}sl}{\\CJKbold}

\\endinput
EOF

echo -n "" > ${FDDIR}/${FDNAME}.orig

diff -u ${FDDIR}/${FDNAME}.orig ${FDDIR}/${FDNAME}

}

(
	generate UTF8 b5song arb5sungu
	generate UTF8 b5kai  arb5kaiu
	generate UTF8 gbsong argbsungu
	generate UTF8 gbkai  argbkaiu
) > patch-texinput-UTF8-arphicfdfiles

(
	generate Bg5  t1song t1arb5sung
	generate Bg5  t1kai  t1arb5kai
	generate GB   t1song t1argbsung
	generate GB   t1kai  t1argbkai
) > patch-texinput-GBBg5-type1fdfiles
