--- dix/devices.c.orig  2007-10-19 17:04:51.000000000 -0200
+++ dix/devices.c       2007-10-23 17:50:38.000000000 -0200
@@ -294,7 +294,17 @@ CoreKeyboardBell(int volume, DeviceIntPt
 static void
 CoreKeyboardCtl(DeviceIntPtr pDev, KeybdCtrl *ctrl)
 {
+#ifdef XKB
+    if (!noXkbExtension) {
+       DeviceIntPtr dev = (DeviceIntPtr)
+           pDev->devPrivates[CoreDevicePrivatesIndex].ptr;
+
+       if (dev && dev->key && dev->key->xkbInfo && dev->key->xkbInfo->kbdProc)
+           (*dev->key->xkbInfo->kbdProc)(dev, ctrl);
+    }
+#else
     return;
+#endif
 }

 /**
