--- ./cmake/modules/FindAqBanking.cmake.orig	2010-08-16 06:52:14.000000000 -0400
+++ ./cmake/modules/FindAqBanking.cmake	2010-08-23 03:52:29.000000000 -0400
@@ -23,11 +23,32 @@
   set(AQBANKING_FIND_QUIETLY TRUE)
 endif(AQBANKING_INCLUDE_DIRS AND AQBANKING_LIBRARIES)
 
-PKG_CHECK_MODULES(AQBANKING aqbanking>=${AQBANKING_MIN_VERSION} aqbanking<=${AQBANKING_MAX_VERSION})
+PKG_CHECK_MODULES(PC_AQBANKING aqbanking>=${AQBANKING_MIN_VERSION} aqbanking<=${AQBANKING_MAX_VERSION})
 
-if(${AQBANKING_FOUND})
+find_path(AQBANKING_INCLUDE_DIRS NAMES aqbanking/version.h
+    HINTS
+    ${PC_AQBANKING_INCLUDEDIR}
+    ${PC_AQBANKING_INCLUDE_DIRS}
+    )
+
+find_library(AQBANKING_LIBRARY NAMES aqbanking
+    HINTS
+    ${PC_AQBANKING_LIBDIR}
+    ${PC_AQBANKING_LIBRARY_DIRS}
+    )
+
+find_library(Q4BANKING_LIBRARY NAMES q4banking
+    HINTS
+    ${PC_AQBANKING_LIBDIR}
+    ${PC_AQBANKING_LIBRARY_DIRS}
+    )
+
+include(FindPackageHandleStandardArgs)
+find_package_handle_standard_args(aqbanking DEFAULT_MSG AQBANKING_LIBRARY AQBANKING_INCLUDE_DIRS)
+
+if(AQBANKING_FOUND)
   # if AqBanking has been found make sure to add the q4banking lib
-  set(AQBANKING_LIBRARIES ${AQBANKING_LIBRARIES} q4banking)
-endif(${AQBANKING_FOUND})
+  set(AQBANKING_LIBRARIES ${AQBANKING_LIBRARY} ${Q4BANKING_LIBRARY})
+endif(AQBANKING_FOUND)
 
 mark_as_advanced(AQBANKING_INCLUDE_DIRS AQBANKING_LIBRARIES)
