--- ./cmake/modules/FindGwenhywfar.cmake.orig	2010-08-16 06:52:14.000000000 -0400
+++ ./cmake/modules/FindGwenhywfar.cmake	2010-08-23 03:51:38.000000000 -0400
@@ -16,15 +16,30 @@
   set(GWENHYWFAR_FIND_QUIETLY TRUE)
 endif(GWENHYWFAR_INCLUDE_DIRS AND GWENHYWFAR_LIBRARIES)
 
-PKG_CHECK_MODULES(GWENHYWFAR gwenhywfar>=${GWENHYWFAR_MIN_VERSION})
+PKG_CHECK_MODULES(PC_GWENHYWFAR gwenhywfar>=${GWENHYWFAR_MIN_VERSION})
 
-if(${GWENHYWFAR_FOUND})
+find_path(GWENHYWFAR_INCLUDE_DIRS NAMES gwenhywfar/version.h
+    HINTS
+    ${PC_GWENHYWFAR_INCLUDEDIR}
+    ${PC_GWENHYWFAR_INCLUDE_DIRS}
+    )
+
+find_library(GWENHYWFAR_LIBRARY NAMES gwenhywfar
+    HINTS
+    ${PC_GWENHYWFAR_LIBDIR}
+    ${PC_GWENHYWFAR_LIBRARY_DIRS}
+    )
+
+include(FindPackageHandleStandardArgs)
+find_package_handle_standard_args(gwenhywfar DEFAULT_MSG GWENHYWFAR_LIBRARY GWENHYWFAR_INCLUDE_DIRS)
+
+if(GWENHYWFAR_FOUND)
   find_library(GWENHYWFAR_GUI_LIBRARY NAMES gwengui-qt4 libgwengui-qt4
-    HINTS ${GWENHYWFAR_LIBRARY_DIRS})
+    HINTS ${PC_GWENHYWFAR_LIBRARY_DIRS})
   if(GWENHYWFAR_GUI_LIBRARY STREQUAL "GWENHYWFAR_GUI_LIBRARY-NOTFOUND")
     set(GWENHYWFAR_GUI_LIBRARY "")
   endif(GWENHYWFAR_GUI_LIBRARY STREQUAL "GWENHYWFAR_GUI_LIBRARY-NOTFOUND")
-  set(GWENHYWFAR_LIBRARIES ${GWENHYWFAR_LIBRARIES} ${GWENHYWFAR_GUI_LIBRARY})
-endif(${GWENHYWFAR_FOUND})
+  set(GWENHYWFAR_LIBRARIES ${GWENHYWFAR_LIBRARY} ${GWENHYWFAR_GUI_LIBRARY})
+endif(GWENHYWFAR_FOUND)
 
 mark_as_advanced(GWENHYWFAR_INCLUDE_DIRS GWENHYWFAR_LIBRARIES)
