--- opcodes/mips-opc.c.orig	2005-09-06 19:46:57.000000000 +0100
+++ opcodes/mips-opc.c	2007-02-08 20:06:04.000000000 +0000
@@ -109,6 +109,7 @@
 #define N5	(INSN_5400 | INSN_5500)
 #define N54	INSN_5400
 #define N55	INSN_5500
+#define AL	INSN_ALLEGREX
 
 #define G1      (T3             \
                  )
@@ -298,6 +299,7 @@
 {"bnel",    "s,t,p",	0x54000000, 0xfc000000,	CBL|RD_s|RD_t, 		0,		I2|T3	},
 {"bnel",    "s,I,p",	0,    (int) M_BNEL_I,	INSN_MACRO,		0,		I2|T3	},
 {"break",   "",		0x0000000d, 0xffffffff,	TRAP,			0,		I1	},
+{"break",   "B",	0x0000000d, 0xfc00003f,	TRAP,			0,		I32|AL	},
 {"break",   "c",	0x0000000d, 0xfc00ffff,	TRAP,			0,		I1	},
 {"break",   "c,q",	0x0000000d, 0xfc00003f,	TRAP,			0,		I1	},
 {"c.f.d",   "S,T",	0x46200030, 0xffe007ff,	RD_S|RD_T|WR_CC|FP_D,	0,		I1	},
@@ -459,7 +461,7 @@
 {"cabs.un.d",  "M,S,T",	0x46200071, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		M3D	},
 {"cabs.un.ps", "M,S,T",	0x46c00071, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_D,	0,		M3D	},
 {"cabs.un.s",  "M,S,T",	0x46000071, 0xffe000ff,	RD_S|RD_T|WR_CC|FP_S,	0,		M3D	},
-{"cache",   "k,o(b)",   0xbc000000, 0xfc000000, RD_b,           	0,		I3|I32|T3},
+{"cache",   "k,o(b)",   0xbc000000, 0xfc000000, RD_b,           	0,		I3|I32|T3|AL},
 {"ceil.l.d", "D,S",	0x4620000a, 0xffff003f, WR_D|RD_S|FP_D,		0,		I3	},
 {"ceil.l.s", "D,S",	0x4600000a, 0xffff003f, WR_D|RD_S|FP_S,		0,		I3	},
 {"ceil.w.d", "D,S",	0x4620000e, 0xffff003f, WR_D|RD_S|FP_D,		0,		I2	},
@@ -473,7 +475,9 @@
 {"cftc1",   "d,T",	0x41000023, 0xffe007ff, TRAP|LCD|WR_d|RD_C1|FP_S, 0,		MT32	},
 {"cftc2",   "d,E",	0x41000025, 0xffe007ff, TRAP|LCD|WR_d|RD_C2,	0,		MT32	},
 {"clo",     "U,s",      0x70000021, 0xfc0007ff, WR_d|WR_t|RD_s, 	0,		I32|N55 },
+{"clo",     "d,s",      0x00000017, 0xfc1f07ff, WR_d|RD_s,      	0,		AL	},
 {"clz",     "U,s",      0x70000020, 0xfc0007ff, WR_d|WR_t|RD_s, 	0,		I32|N55 },
+{"clz",     "d,s",      0x00000016, 0xfc1f07ff, WR_d|RD_s,              0,              AL      },
 {"ctc0",    "t,G",	0x40c00000, 0xffe007ff,	COD|RD_t|WR_CC,		0,		I1	},
 {"ctc1",    "t,G",	0x44c00000, 0xffe007ff,	COD|RD_t|WR_CC|FP_S,	0,		I1	},
 {"ctc1",    "t,S",	0x44c00000, 0xffe007ff,	COD|RD_t|WR_CC|FP_S,	0,		I1	},
@@ -498,13 +502,15 @@
 {"cvt.ps.s","D,V,T",	0x46000026, 0xffe0003f,	WR_D|RD_S|RD_T|FP_D,	0,		I5	},
 {"cvt.pw.ps", "D,S",	0x46c00024, 0xffff003f,	WR_D|RD_S|FP_S|FP_D,	0,		M3D	},
 {"dabs",    "d,v",	0,    (int) M_DABS,	INSN_MACRO,		0,		I3	},
+{"max",     "d,v,t",    0x0000002c, 0xfc0007ff, WR_d|RD_s|RD_t,         0,              AL	},
 {"dadd",    "d,v,t",	0x0000002c, 0xfc0007ff, WR_d|RD_s|RD_t,		0,		I3	},
 {"dadd",    "t,r,I",	0,    (int) M_DADD_I,	INSN_MACRO,		0,		I3	},
 {"daddi",   "t,r,j",	0x60000000, 0xfc000000, WR_t|RD_s,		0,		I3	},
 {"daddiu",  "t,r,j",	0x64000000, 0xfc000000, WR_t|RD_s,		0,		I3	},
+{"min",     "d,v,t",    0x0000002d, 0xfc0007ff, WR_d|RD_s|RD_t,         0,              AL	},
 {"daddu",   "d,v,t",	0x0000002d, 0xfc0007ff, WR_d|RD_s|RD_t,		0,		I3	},
 {"daddu",   "t,r,I",	0,    (int) M_DADDU_I,	INSN_MACRO,		0,		I3	},
-{"dbreak",  "",		0x7000003f, 0xffffffff,	0,			0,		N5	},
+{"dbreak",  "",		0x7000003f, 0xffffffff,	0,			0,		N5|AL	},
 {"dclo",    "U,s",      0x70000025, 0xfc0007ff, RD_s|WR_d|WR_t, 	0,		I64|N55 },
 {"dclz",    "U,s",      0x70000024, 0xfc0007ff, RD_s|WR_d|WR_t, 	0,		I64|N55 },
 /* dctr and dctw are used on the r5000.  */
@@ -593,7 +599,7 @@
 {"dremu",   "z,s,t",    0x0000001f, 0xfc00ffff, RD_s|RD_t|WR_HILO,      0,		I3      },
 {"dremu",   "d,v,t",	3,    (int) M_DREMU_3,	INSN_MACRO,		0,		I3	},
 {"dremu",   "d,v,I",	3,    (int) M_DREMU_3I,	INSN_MACRO,		0,		I3	},
-{"dret",    "",		0x7000003e, 0xffffffff,	0,			0,		N5	},
+{"dret",    "",		0x7000003e, 0xffffffff,	0,			0,		N5|AL	},
 {"drol",    "d,v,t",	0,    (int) M_DROL,	INSN_MACRO,		0,		I3	},
 {"drol",    "d,v,I",	0,    (int) M_DROL_I,	INSN_MACRO,		0,		I3	},
 {"dror",    "d,v,t",	0,    (int) M_DROR,	INSN_MACRO,		0,		I3	},
@@ -634,10 +640,10 @@
 {"ei",      "t",	0x41606020, 0xffe0ffff,	WR_t|WR_C0,		0,		I33	},
 {"emt",     "",		0x41600be1, 0xffffffff, TRAP,			0,		MT32	},
 {"emt",     "t",	0x41600be1, 0xffe0ffff, TRAP|WR_t,		0,		MT32	},
-{"eret",    "",         0x42000018, 0xffffffff, 0,      		0,		I3|I32	},
+{"eret",    "",         0x42000018, 0xffffffff, 0,      		0,		I3|I32|AL	},
 {"evpe",    "",		0x41600021, 0xffffffff, TRAP,			0,		MT32	},
 {"evpe",    "t",	0x41600021, 0xffe0ffff, TRAP|WR_t,		0,		MT32	},
-{"ext",     "t,r,+A,+C", 0x7c000000, 0xfc00003f, WR_t|RD_s,    		0,		I33	},
+{"ext",     "t,r,+A,+C", 0x7c000000, 0xfc00003f, WR_t|RD_s,    		0,		I33|AL	},
 {"floor.l.d", "D,S",	0x4620000b, 0xffff003f, WR_D|RD_S|FP_D,		0,		I3	},
 {"floor.l.s", "D,S",	0x4600000b, 0xffff003f, WR_D|RD_S|FP_S,		0,		I3	},
 {"floor.w.d", "D,S",	0x4620000f, 0xffff003f, WR_D|RD_S|FP_D,		0,		I2	},
@@ -646,7 +652,7 @@
 {"flushd",  "",		0xbc020000, 0xffffffff, 0, 			0,		L1	},
 {"flushid", "",		0xbc030000, 0xffffffff, 0, 			0,		L1	},
 {"hibernate","",        0x42000023, 0xffffffff,	0, 			0,		V1	},
-{"ins",     "t,r,+A,+B", 0x7c000004, 0xfc00003f, WR_t|RD_s,    		0,		I33	},
+{"ins",     "t,r,+A,+B", 0x7c000004, 0xfc00003f, WR_t|RD_s,    		0,		I33|AL	},
 {"jr",      "s",	0x00000008, 0xfc1fffff,	UBD|RD_s,		0,		I1	},
 {"jr.hb",   "s",	0x00000408, 0xfc1fffff,	UBD|RD_s,		0,		I33	},
 {"j",       "s",	0x00000008, 0xfc1fffff,	UBD|RD_s,		0,		I1	}, /* jr */
@@ -680,18 +686,10 @@
 {"ld",	    "t,o(b)",   0xdc000000, 0xfc000000, WR_t|RD_b,		0,		I3	},
 {"ld",      "t,o(b)",	0,    (int) M_LD_OB,	INSN_MACRO,		0,		I1	},
 {"ld",      "t,A(b)",	0,    (int) M_LD_AB,	INSN_MACRO,		0,		I1	},
-{"ldc1",    "T,o(b)",	0xd4000000, 0xfc000000, CLD|RD_b|WR_T|FP_D,	0,		I2	},
-{"ldc1",    "E,o(b)",	0xd4000000, 0xfc000000, CLD|RD_b|WR_T|FP_D,	0,		I2	},
-{"ldc1",    "T,A(b)",	0,    (int) M_LDC1_AB,	INSN_MACRO,		0,		I2	},
-{"ldc1",    "E,A(b)",	0,    (int) M_LDC1_AB,	INSN_MACRO,		0,		I2	},
-{"l.d",     "T,o(b)",	0xd4000000, 0xfc000000, CLD|RD_b|WR_T|FP_D,	0,		I2	}, /* ldc1 */
-{"l.d",     "T,o(b)",	0,    (int) M_L_DOB,	INSN_MACRO,		0,		I1	},
-{"l.d",     "T,A(b)",	0,    (int) M_L_DAB,	INSN_MACRO,		0,		I1	},
-{"ldc2",    "E,o(b)",	0xd8000000, 0xfc000000, CLD|RD_b|WR_CC,		0,		I2	},
-{"ldc2",    "E,A(b)",	0,    (int) M_LDC2_AB,	INSN_MACRO,		0,		I2	},
-{"ldc3",    "E,o(b)",	0xdc000000, 0xfc000000, CLD|RD_b|WR_CC,		0,		I2	},
-{"ldc3",    "E,A(b)",	0,    (int) M_LDC3_AB,	INSN_MACRO,		0,		I2	},
-{"ldl",	    "t,o(b)",	0x68000000, 0xfc000000, LDD|WR_t|RD_b,		0,		I3	},
+/* ldc1 is at the bottom of the table.  */
+/* ldc2 is at the bottom of the table.  */
+/* ldc3 is at the bottom of the table.  */
+{"ldl",	    "t,o(b)",	0x68000000, 0xfc000000, LDD|WR_t|RD_b,		0,		I3|AL	},
 {"ldl",	    "t,A(b)",	0,    (int) M_LDL_AB,	INSN_MACRO,		0,		I3	},
 {"ldr",	    "t,o(b)",	0x6c000000, 0xfc000000, LDD|WR_t|RD_b,		0,		I3	},
 {"ldr",     "t,A(b)",	0,    (int) M_LDR_AB,	INSN_MACRO,		0,		I3	},
@@ -721,8 +719,7 @@
 {"lwc1",    "E,A(b)",	0,    (int) M_LWC1_AB,	INSN_MACRO,		0,		I1	},
 {"l.s",     "T,o(b)",	0xc4000000, 0xfc000000,	CLD|RD_b|WR_T|FP_S,	0,		I1	}, /* lwc1 */
 {"l.s",     "T,A(b)",	0,    (int) M_LWC1_AB,	INSN_MACRO,		0,		I1	},
-{"lwc2",    "E,o(b)",	0xc8000000, 0xfc000000,	CLD|RD_b|WR_CC,		0,		I1	},
-{"lwc2",    "E,A(b)",	0,    (int) M_LWC2_AB,	INSN_MACRO,		0,		I1	},
+/* lwc2 is at the bottom of the table.  */
 {"lwc3",    "E,o(b)",	0xcc000000, 0xfc000000,	CLD|RD_b|WR_CC,		0,		I1	},
 {"lwc3",    "E,A(b)",	0,    (int) M_LWC3_AB,	INSN_MACRO,		0,		I1	},
 {"lwl",     "t,o(b)",	0x88000000, 0xfc000000,	LDD|RD_b|WR_t,		0,		I1	},
@@ -755,10 +752,12 @@
 {"madd.s",  "D,R,S,T",	0x4c000020, 0xfc00003f, RD_R|RD_S|RD_T|WR_D|FP_S,    0,		I4	},
 {"madd.ps", "D,R,S,T",	0x4c000026, 0xfc00003f, RD_R|RD_S|RD_T|WR_D|FP_D,    0,		I5	},
 {"madd",    "s,t",      0x0000001c, 0xfc00ffff, RD_s|RD_t|WR_HILO,           0,		L1 },
+{"madd",    "s,t",      0x0000001c, 0xfc00ffff, RD_s|RD_t|WR_HILO|IS_M,      0,         AL	},
 {"madd",    "s,t",      0x70000000, 0xfc00ffff, RD_s|RD_t|MOD_HILO,          0,		I32|N55},
 {"madd",    "s,t",      0x70000000, 0xfc00ffff, RD_s|RD_t|WR_HILO|IS_M,      0,		G1 },
 {"madd",    "d,s,t",    0x70000000, 0xfc0007ff, RD_s|RD_t|WR_HILO|WR_d|IS_M, 0,		G1 },
 {"maddu",   "s,t",      0x0000001d, 0xfc00ffff, RD_s|RD_t|WR_HILO,           0,		L1 },
+{"maddu",   "s,t",      0x0000001d, 0xfc00ffff, RD_s|RD_t|WR_HILO|IS_M,      0,         AL	},
 {"maddu",   "s,t",      0x70000001, 0xfc00ffff, RD_s|RD_t|MOD_HILO,          0,		I32|N55},
 {"maddu",   "s,t",      0x70000001, 0xfc00ffff, RD_s|RD_t|WR_HILO|IS_M,      0,		G1	},
 {"maddu",   "d,s,t",    0x70000001, 0xfc0007ff, RD_s|RD_t|WR_HILO|WR_d|IS_M, 0,		G1	},
@@ -799,7 +798,7 @@
 /* mfhc2 is at the bottom of the table.  */
 {"mfc3",    "t,G",	0x4c000000, 0xffe007ff,	LCD|WR_t|RD_C3,		0,		I1	},
 {"mfc3",    "t,G,H",    0x4c000000, 0xffe007f8, LCD|WR_t|RD_C3, 	0,		I32     },
-{"mfdr",    "t,G",	0x7000003d, 0xffe007ff,	LCD|WR_t|RD_C0,		0,		N5      },
+{"mfdr",    "t,G",	0x7000003d, 0xffe007ff,	LCD|WR_t|RD_C0,		0,		N5|AL      },
 {"mfhi",    "d",	0x00000010, 0xffff07ff,	WR_d|RD_HI,		0,		I1	},
 {"mfhi",    "d,9",	0x00000010, 0xff9f07ff, WR_d|RD_HI,		0,		D32	},
 {"mflo",    "d",	0x00000012, 0xffff07ff,	WR_d|RD_LO,		0,		I1	},
@@ -818,7 +817,7 @@
 {"movf.l",  "X,Y,N",	0x46a00011, 0xffe3003f, WR_D|RD_S|RD_CC|FP_D,	0,		MX|SB1	},
 {"movf.s",  "D,S,N",    0x46000011, 0xffe3003f, WR_D|RD_S|RD_CC|FP_S,   0,		I4|I32	},
 {"movf.ps", "D,S,N",	0x46c00011, 0xffe3003f, WR_D|RD_S|RD_CC|FP_D,	0,		I5	},
-{"movn",    "d,v,t",    0x0000000b, 0xfc0007ff, WR_d|RD_s|RD_t, 	0,		I4|I32	},
+{"movn",    "d,v,t",    0x0000000b, 0xfc0007ff, WR_d|RD_s|RD_t, 	0,		I4|I32|AL	},
 {"ffc",     "d,v",	0x0000000b, 0xfc1f07ff,	WR_d|RD_s,		0,		L1	},
 {"movn.d",  "D,S,t",    0x46200013, 0xffe0003f, WR_D|RD_S|RD_t|FP_D,    0,		I4|I32	},
 {"movn.l",  "D,S,t",    0x46a00013, 0xffe0003f, WR_D|RD_S|RD_t|FP_D,    0,		MX|SB1	},
@@ -831,7 +830,7 @@
 {"movt.l",  "X,Y,N",    0x46a10011, 0xffe3003f, WR_D|RD_S|RD_CC|FP_D,   0,		MX|SB1	},
 {"movt.s",  "D,S,N",    0x46010011, 0xffe3003f, WR_D|RD_S|RD_CC|FP_S,   0,		I4|I32	},
 {"movt.ps", "D,S,N",	0x46c10011, 0xffe3003f, WR_D|RD_S|RD_CC|FP_D,	0,		I5	},
-{"movz",    "d,v,t",    0x0000000a, 0xfc0007ff, WR_d|RD_s|RD_t, 	0,		I4|I32	},
+{"movz",    "d,v,t",    0x0000000a, 0xfc0007ff, WR_d|RD_s|RD_t, 	0,		I4|I32|AL	},
 {"ffs",     "d,v",	0x0000000a, 0xfc1f07ff,	WR_d|RD_s,		0,		L1	},
 {"movz.d",  "D,S,t",    0x46200012, 0xffe0003f, WR_D|RD_S|RD_t|FP_D,    0,		I4|I32	},
 {"movz.l",  "D,S,t",    0x46a00012, 0xffe0003f, WR_D|RD_S|RD_t|FP_D,    0,		MX|SB1	},
@@ -848,8 +847,10 @@
 {"msub.s",  "D,R,S,T",	0x4c000028, 0xfc00003f, RD_R|RD_S|RD_T|WR_D|FP_S, 0,		I4	},
 {"msub.ps", "D,R,S,T",	0x4c00002e, 0xfc00003f, RD_R|RD_S|RD_T|WR_D|FP_D, 0,		I5	},
 {"msub",    "s,t",      0x0000001e, 0xfc00ffff, RD_s|RD_t|WR_HILO,	0,		L1    	},
+{"msub",    "s,t",      0x0000002e, 0xfc00ffff, RD_s|RD_t|WR_HILO|IS_M, 0,              AL	},
 {"msub",    "s,t",      0x70000004, 0xfc00ffff, RD_s|RD_t|MOD_HILO,     0,		I32|N55 },
 {"msubu",   "s,t",      0x0000001f, 0xfc00ffff, RD_s|RD_t|WR_HILO,	0,		L1	},
+{"msubu",   "s,t",      0x0000002f, 0xfc00ffff, RD_s|RD_t|WR_HILO|IS_M, 0,              AL	},
 {"msubu",   "s,t",      0x70000005, 0xfc00ffff, RD_s|RD_t|MOD_HILO,     0,		I32|N55	},
 {"mtpc",    "t,P",	0x4080c801, 0xffe0ffc1,	COD|RD_t|WR_C0,		0,		M1|N5	},
 {"mtps",    "t,P",	0x4080c800, 0xffe0ffc1,	COD|RD_t|WR_C0,		0,		M1|N5	},
@@ -864,7 +865,7 @@
 /* mthc2 is at the bottom of the table.  */
 {"mtc3",    "t,G",	0x4c800000, 0xffe007ff,	COD|RD_t|WR_C3|WR_CC,	0,		I1	},
 {"mtc3",    "t,G,H",    0x4c800000, 0xffe007f8, COD|RD_t|WR_C3|WR_CC,   0,		I32     },
-{"mtdr",    "t,G",	0x7080003d, 0xffe007ff,	COD|RD_t|WR_C0,		0,		N5	},
+{"mtdr",    "t,G",	0x7080003d, 0xffe007ff,	COD|RD_t|WR_C0,		0,		N5|AL	},
 {"mthi",    "s",	0x00000011, 0xfc1fffff,	RD_s|WR_HI,		0,		I1	},
 {"mthi",    "s,7",	0x00000011, 0xfc1fe7ff, RD_s|WR_HI,		0,		D32	},
 {"mtlo",    "s",	0x00000013, 0xfc1fffff,	RD_s|WR_LO,		0,		I1	},
@@ -1018,13 +1019,13 @@
 {"rol",     "d,v,I",	0,    (int) M_ROL_I,	INSN_MACRO,		0,		I1	},
 {"ror",     "d,v,t",	0,    (int) M_ROR,	INSN_MACRO,		0,		I1	},
 {"ror",     "d,v,I",	0,    (int) M_ROR_I,	INSN_MACRO,		0,		I1	},
-{"ror",	    "d,w,<",	0x00200002, 0xffe0003f,	WR_d|RD_t,		0,		N5|I33	},
-{"rorv",    "d,t,s",	0x00000046, 0xfc0007ff,	RD_t|RD_s|WR_d,		0,		N5|I33	},
-{"rotl",    "d,v,t",	0,    (int) M_ROL,	INSN_MACRO,		0,		I33	},
-{"rotl",    "d,v,I",	0,    (int) M_ROL_I,	INSN_MACRO,		0,		I33	},
-{"rotr",    "d,v,t",	0,    (int) M_ROR,	INSN_MACRO,		0,		I33	},
-{"rotr",    "d,v,I",	0,    (int) M_ROR_I,	INSN_MACRO,		0,		I33	},
-{"rotrv",   "d,t,s",	0x00000046, 0xfc0007ff,	RD_t|RD_s|WR_d,		0,		I33	},
+{"ror",	    "d,w,<",	0x00200002, 0xffe0003f,	WR_d|RD_t,		0,		N5|I33|AL	},
+{"rorv",    "d,t,s",	0x00000046, 0xfc0007ff,	RD_t|RD_s|WR_d,		0,		N5|I33|AL	},
+{"rotl",    "d,v,t",	0,    (int) M_ROL,	INSN_MACRO,		0,		I33|AL	},
+{"rotl",    "d,v,I",	0,    (int) M_ROL_I,	INSN_MACRO,		0,		I33|AL	},
+{"rotr",    "d,v,t",	0,    (int) M_ROR,	INSN_MACRO,		0,		I33|AL	},
+{"rotr",    "d,v,I",	0,    (int) M_ROR_I,	INSN_MACRO,		0,		I33|AL	},
+{"rotrv",   "d,t,s",	0x00000046, 0xfc0007ff,	RD_t|RD_s|WR_d,		0,		I33|AL	},
 {"round.l.d", "D,S",	0x46200008, 0xffff003f, WR_D|RD_S|FP_D,		0,		I3	},
 {"round.l.s", "D,S",	0x46000008, 0xffff003f, WR_D|RD_S|FP_S,		0,		I3	},
 {"round.w.d", "D,S",	0x4620000c, 0xffff003f, WR_D|RD_S|FP_D,		0,		I2	},
@@ -1056,24 +1057,17 @@
 {"sdbbp",   "c,q",	0x0000000e, 0xfc00003f,	TRAP,			0,		G2	},
 {"sdbbp",   "",         0x7000003f, 0xffffffff, TRAP,           	0,		I32     },
 {"sdbbp",   "B",        0x7000003f, 0xfc00003f, TRAP,           	0,		I32     },
-{"sdc1",    "T,o(b)",	0xf4000000, 0xfc000000, SM|RD_T|RD_b|FP_D,	0,		I2	},
-{"sdc1",    "E,o(b)",	0xf4000000, 0xfc000000, SM|RD_T|RD_b|FP_D,	0,		I2	},
-{"sdc1",    "T,A(b)",	0,    (int) M_SDC1_AB,	INSN_MACRO,		0,		I2	},
-{"sdc1",    "E,A(b)",	0,    (int) M_SDC1_AB,	INSN_MACRO,		0,		I2	},
-{"sdc2",    "E,o(b)",	0xf8000000, 0xfc000000, SM|RD_C2|RD_b,		0,		I2	},
-{"sdc2",    "E,A(b)",	0,    (int) M_SDC2_AB,	INSN_MACRO,		0,		I2	},
-{"sdc3",    "E,o(b)",	0xfc000000, 0xfc000000, SM|RD_C3|RD_b,		0,		I2	},
-{"sdc3",    "E,A(b)",	0,    (int) M_SDC3_AB,	INSN_MACRO,		0,		I2	},
-{"s.d",     "T,o(b)",	0xf4000000, 0xfc000000, SM|RD_T|RD_b|FP_D,	0,		I2	},
-{"s.d",     "T,o(b)",	0,    (int) M_S_DOB,	INSN_MACRO,		0,		I1	},
-{"s.d",     "T,A(b)",	0,    (int) M_S_DAB,	INSN_MACRO,		0,		I1	},
-{"sdl",     "t,o(b)",	0xb0000000, 0xfc000000,	SM|RD_t|RD_b,		0,		I3	},
+/* sdc1 is at the bottom of the table.  */
+/* sdc2 is at the bottom of the table.  */
+/* sdc3 is at the bottom of the table.  */
+/* s.d (sdc1 is at the bottom of the table.  */
+{"sdl",     "t,o(b)",	0xb0000000, 0xfc000000,	SM|RD_t|RD_b,		0,		I3|AL	},
 {"sdl",     "t,A(b)",	0,    (int) M_SDL_AB,	INSN_MACRO,		0,		I3	},
 {"sdr",     "t,o(b)",	0xb4000000, 0xfc000000,	SM|RD_t|RD_b,		0,		I3	},
 {"sdr",     "t,A(b)",	0,    (int) M_SDR_AB,	INSN_MACRO,		0,		I3	},
 {"sdxc1",   "S,t(b)",   0x4c000009, 0xfc0007ff, SM|RD_S|RD_t|RD_b,	0,		I4	},
-{"seb",     "d,w",	0x7c000420, 0xffe007ff,	WR_d|RD_t,		0,		I33	},
-{"seh",     "d,w",	0x7c000620, 0xffe007ff,	WR_d|RD_t,		0,		I33	},
+{"seb",     "d,w",	0x7c000420, 0xffe007ff,	WR_d|RD_t,		0,		I33|AL	},
+{"seh",     "d,w",	0x7c000620, 0xffe007ff,	WR_d|RD_t,		0,		I33|AL	},
 {"selsl",   "d,v,t",	0x00000005, 0xfc0007ff,	WR_d|RD_s|RD_t,		0,		L1	},
 {"selsr",   "d,v,t",	0x00000001, 0xfc0007ff,	WR_d|RD_s|RD_t,		0,		L1	},
 {"seq",     "d,v,t",	0,    (int) M_SEQ,	INSN_MACRO,		0,		I1	},
@@ -1165,8 +1159,7 @@
 {"swc1",    "E,A(b)",	0,    (int) M_SWC1_AB,	INSN_MACRO,		0,		I1	},
 {"s.s",     "T,o(b)",	0xe4000000, 0xfc000000,	SM|RD_T|RD_b|FP_S,	0,		I1	}, /* swc1 */
 {"s.s",     "T,A(b)",	0,    (int) M_SWC1_AB,	INSN_MACRO,		0,		I1	},
-{"swc2",    "E,o(b)",	0xe8000000, 0xfc000000,	SM|RD_C2|RD_b,		0,		I1	},
-{"swc2",    "E,A(b)",	0,    (int) M_SWC2_AB,	INSN_MACRO,		0,		I1	},
+/* swc2 is at the bottom of the table.  */
 {"swc3",    "E,o(b)",	0xec000000, 0xfc000000,	SM|RD_C3|RD_b,		0,		I1	},
 {"swc3",    "E,A(b)",	0,    (int) M_SWC3_AB,	INSN_MACRO,		0,		I1	},
 {"swl",     "t,o(b)",	0xa8000000, 0xfc000000,	SM|RD_t|RD_b,		0,		I1	},
@@ -1251,7 +1244,8 @@
 {"waiti",   "",		0x42000020, 0xffffffff,	TRAP,			0,		L1	},
 {"wb", 	    "o(b)",	0xbc040000, 0xfc1f0000, SM|RD_b,		0,		L1	},
 {"wrpgpr",  "d,w",	0x41c00000, 0xffe007ff, RD_t,			0,		I33	},
-{"wsbh",    "d,w",	0x7c0000a0, 0xffe007ff,	WR_d|RD_t,		0,		I33	},
+{"wsbh",    "d,w",	0x7c0000a0, 0xffe007ff,	WR_d|RD_t,		0,		I33|AL	},
+{"wsbw",    "d,t",	0x7c0000e0, 0xffe007ff, WR_d|RD_t,		0,		AL	},
 {"xor",     "d,v,t",	0x00000026, 0xfc0007ff,	WR_d|RD_s|RD_t,		0,		I1	},
 {"xor",     "t,r,I",	0,    (int) M_XOR_I,	INSN_MACRO,		0,		I1	},
 {"xor.ob",  "X,Y,Q",	0x7800000d, 0xfc20003f,	WR_D|RD_S|RD_T|FP_D,	0,		MX|SB1	},
@@ -1263,6 +1257,319 @@
 {"yield",   "s",	0x7c000009, 0xfc1fffff, TRAP|RD_s,		0,		MT32	},
 {"yield",   "d,s",	0x7c000009, 0xfc1f07ff, TRAP|WR_d|RD_s,		0,		MT32	},
 
+/* Sony Allegrex CPU core.  */
+{"bitrev",  "d,t",      0x7c000520, 0xffe007ff, WR_d|RD_t,              0,              AL	},
+{"mfic",    "t,G",	0x70000024, 0xffe007ff, LCD|WR_t|RD_C0,		0,		AL	},
+{"mtic",    "t,G",	0x70000026, 0xffe007ff, COD|RD_t|WR_C0,		0,		AL	},
+
+/* Sony Allegrex VFPU instructions.  */
+{"bvf",     "?c,p",		0x49000000, 0xffe30000, CBD|RD_CC,	0,		AL	},
+{"bvfl",    "?c,p",		0x49020000, 0xffe30000, CBL|RD_CC,	0,		AL	},
+{"bvt",     "?c,p",		0x49010000, 0xffe30000, CBD|RD_CC,	0,		AL	},
+{"bvtl",    "?c,p",		0x49030000, 0xffe30000, CBL|RD_CC,	0,		AL	},
+{"lv.s",    "?m0x,?o(b)",	0xc8000000, 0xfc000000, CLD|RD_s|WR_CC,	0,		AL	},
+{"lv.s",    "?m0x,A(b)",	0,    (int) M_LVQ_AB,	INSN_MACRO,	0,		AL	},
+{"ulv.s",   "?m0x,o(b)",	0,    (int) M_ULVS,	INSN_MACRO,	0,		AL	},
+{"lv.q",    "?n3x,?o(b)",	0xd8000000, 0xfc000002, CLD|RD_s|WR_CC,	0,		AL	},
+{"lv.q",    "?n3x,A(b)",	0,    (int) M_LVQ_AB_2,	INSN_MACRO,	0,		AL	},
+{"ulv.q",   "?n3x,?o(b)",	0,    (int) M_ULVQ,	INSN_MACRO,	0,		AL	},
+{"ulv.q",   "?n3x,A(b)",	0,    (int) M_ULVQ_AB,	INSN_MACRO,	0,		AL	},
+{"lvi.s",   "?t0x,l?y0",	0,    (int) M_LVIS,	INSN_MACRO,	0,		AL	},
+{"lvi.p",   "?t1x,?[l?y0,l?y1?]", 0,  (int) M_LVIP,	INSN_MACRO,	0,		AL	},
+{"lvi.t",   "?t2x,?[l?y0,l?y1,l?y2?]", 0, (int) M_LVIT,	INSN_MACRO,	0,		AL	},
+{"lvi.q",   "?t3x,?[l?y0,l?y1,l?y2,l?y3?]", 0, (int) M_LVIQ,	INSN_MACRO,	0,	AL	},
+{"lvhi.s",  "?t0x,?[?u?y0,?u?y1?]", 0, (int) M_LVHIS,	INSN_MACRO,	0,		AL	},
+{"lvhi.p",  "?t1x,?[?u?y0,?u?y1,?u?y2,?u?y3?]", 0, (int) M_LVHIP,	INSN_MACRO, 0,	AL	},
+{"sv.s",    "?m0x,?o(b)",	0xe8000000, 0xfc000000, SM|RD_s|RD_C2,	0,		AL	},
+{"sv.s",    "?m0x,A(b)",	0,    (int) M_SVS_AB,	INSN_MACRO,	0,		AL	},
+{"usv.s",   "?m0x,o(b)",	0,    (int) M_USVS,	INSN_MACRO,	0,		AL	},
+{"sv.q",    "?n3x,?o(b)",	0xf8000000, 0xfc000002, SM|RD_s|RD_C2,	0,		AL	},
+{"sv.q",    "?n3x,?o(b),?z",	0xf8000000, 0xfc000000, SM|RD_s|RD_C2,	0,		AL	},
+{"sv.q",    "?n3x,A(b)",	0,    (int) M_SVQ_AB,	INSN_MACRO,	0,		AL	},
+{"sv.q",    "?n3x,A(b),?z",	0,    (int) M_SVQ_AB,	INSN_MACRO,	0,		AL	},
+{"sv.q",    "?n3x,A,?z",	0,    (int) M_SVQ_AB,	INSN_MACRO,	0,		AL	},
+{"usv.q",   "?n3x,?o(b)",	0,    (int) M_USVQ,	INSN_MACRO,	0,		AL	},
+{"usv.q",   "?n3x,A(b)",	0,    (int) M_USVQ_AB,	INSN_MACRO,	0,		AL	},
+{"vwb.q",   "?n3x,?o(b)",	0xf8000002, 0xfc000002, SM|RD_s|RD_C2,	0,		AL	},
+{"lvl.q",   "?n3x,?o(b)",	0xd4000000, 0xfc000002, CLD|RD_s|WR_CC,	0,		AL	},
+{"lvl.q",   "?n3x,A(b)",	0,    (int) M_LVLQ_AB,	INSN_MACRO,	0,		AL	},
+{"lvr.q",   "?n3x,?o(b)",	0xd4000002, 0xfc000002, CLD|RD_s|WR_CC,	0,		AL	},
+{"lvr.q",   "?n3x,A(b)",	0,    (int) M_LVRQ_AB,	INSN_MACRO,	0,		AL	},
+{"svl.q",   "?n3x,?o(b)",	0xf4000000, 0xfc000002, SM|RD_s|RD_C2,	0,		AL	},
+{"svl.q",   "?n3x,A(b)",	0,    (int) M_SVLQ_AB,	INSN_MACRO,	0,		AL	},
+{"svr.q",   "?n3x,?o(b)",	0xf4000002, 0xfc000002, SM|RD_s|RD_C2,	0,		AL	},
+{"svr.q",   "?n3x,A(b)",	0,    (int) M_SVRQ_AB,	INSN_MACRO,	0,		AL	},
+{"mtv",     "t,?d0z",		0x48e00000, 0xffe0ff80, LCD|WR_t|WR_C2,	0,		AL	},
+{"mfv",     "t,?d0z",		0x48600000, 0xffe0ff80, COD|RD_t|WR_CC|RD_C2, 0,	AL	},
+{"mtvc",    "t,?q",		0x48e00000, 0xffe0ff00, LCD|WR_t|WR_C2,	0,		AL	},
+{"mfvc",    "t,?q",		0x48600000, 0xffe0ff00, COD|RD_t|WR_CC|RD_C2, 0,	AL	},
+{"vmtvc",   "?q,?s0y",		0xd0510000, 0xffff8000, WR_C2,		0,		AL	},
+{"vmfvc",   "?d0z,?r",		0xd0500000, 0xffff0080, RD_C2,		0,		AL	},
+{"vadd.q",  "?d3d,?s3s,?t3t",	0x60008080, 0xff808080, RD_C2,		0,		AL	},
+{"vsub.q",  "?d3d,?s3s,?t3t",	0x60808080, 0xff808080, RD_C2,		0,		AL	},
+{"vdiv.q",  "?x3z,?s3y,?t3x",	0x63808080, 0xff808080, RD_C2,		0,		AL	},
+{"vmul.q",  "?d3d,?s3s,?t3t",	0x64008080, 0xff808080, RD_C2,		0,		AL	},
+{"vdot.q",  "?d0d,?s3s,?t3t",	0x64808080, 0xff808080, RD_C2,		0,		AL	},
+{"vscl.q",  "?d3d,?s3s,?t0x",	0x65008080, 0xff808080, RD_C2,		0,		AL	},
+{"vhdp.q",  "?d0d,?s3y,?t3t",	0x66008080, 0xff808080, RD_C2,		0,		AL	},
+{"vcmp.q",  "?f2,?s3s,?t3t",	0x6c008080, 0xff8080f0, RD_C2,		0,		AL	},
+{"vcmp.q",  "?f1,?s3s",		0x6c008080, 0xffff80f0, RD_C2,		0,		AL	},
+{"vcmp.q",  "?f0",		0x6c008080, 0xfffffff0, RD_C2,		0,		AL	},
+{"vmin.q",  "?d3d,?s3s,?t3t",	0x6d008080, 0xff808080, RD_C2,		0,		AL	},
+{"vmax.q",  "?d3d,?s3s,?t3t",	0x6d808080, 0xff808080, RD_C2,		0,		AL	},
+{"vsgn.q",  "?d3d,?s3s",	0xd04a8080, 0xffff8080, RD_C2,		0,		AL	},
+{"vcst.q",  "?d3d,?a",		0xd0608080, 0xffe0ff80, RD_C2,		0,		AL	},
+{"vscmp.q", "?d3d,?s3s,?t3t",	0x6e808080, 0xff808080, RD_C2,		0,		AL	},
+{"vsge.q",  "?d3d,?s3s,?t3t",	0x6f008080, 0xff808080, RD_C2,		0,		AL	},
+{"vslt.q",  "?d3d,?s3s,?t3t",	0x6f808080, 0xff808080, RD_C2,		0,		AL	},
+{"vi2uc.q", "?d0m,?s3w",	0xd03c8080, 0xffff8080, RD_C2,		0,		AL	},
+{"vi2c.q",  "?d0m,?s3w",	0xd03d8080, 0xffff8080, RD_C2,		0,		AL	},
+{"vi2us.q", "?d1m,?s3w",	0xd03e8080, 0xffff8080, RD_C2,		0,		AL	},
+{"vi2s.q",  "?d1m,?s3w",	0xd03f8080, 0xffff8080, RD_C2,		0,		AL	},
+{"vmov.q",  "?d3d,?s3s",	0xd0008080, 0xffff8080, RD_C2,		0,		AL	},
+{"vabs.q",  "?d3d,?s3w",	0xd0018080, 0xffff8080, RD_C2,		0,		AL	},
+{"vneg.q",  "?d3d,?s3w",	0xd0028080, 0xffff8080, RD_C2,		0,		AL	},
+{"vidt.q",  "?d3d",		0xd0038080, 0xffffff80, RD_C2,		0,		AL	},
+{"vsat0.q", "?d3z,?s3s",	0xd0048080, 0xffff8080, RD_C2,		0,		AL	},
+{"vsat1.q", "?d3z,?s3s",	0xd0058080, 0xffff8080, RD_C2,		0,		AL	},
+{"vzero.q", "?d3d",		0xd0068080, 0xffffff80, RD_C2,		0,		AL	},
+{"vone.q",  "?d3d",		0xd0078080, 0xffffff80, RD_C2,		0,		AL	},
+{"vrcp.q",  "?x3z,?s3y",	0xd0108080, 0xffff8080, RD_C2,		0,		AL	},
+{"vrsq.q",  "?x3z,?s3y",	0xd0118080, 0xffff8080, RD_C2,		0,		AL	},
+{"vsin.q",  "?x3z,?s3y",	0xd0128080, 0xffff8080, RD_C2,		0,		AL	},
+{"vcos.q",  "?x3z,?s3y",	0xd0138080, 0xffff8080, RD_C2,		0,		AL	},
+{"vexp2.q", "?x3z,?s3y",	0xd0148080, 0xffff8080, RD_C2,		0,		AL	},
+{"vlog2.q", "?x3z,?s3y",	0xd0158080, 0xffff8080, RD_C2,		0,		AL	},
+{"vsqrt.q", "?x3z,?s3y",	0xd0168080, 0xffff8080, RD_C2,		0,		AL	},
+{"vasin.q", "?x3z,?s3y",	0xd0178080, 0xffff8080, RD_C2,		0,		AL	},
+{"vnrcp.q", "?x3z,?s3y",	0xd0188080, 0xffff8080, RD_C2,		0,		AL	},
+{"vnsin.q", "?x3z,?s3y",	0xd01a8080, 0xffff8080, RD_C2,		0,		AL	},
+{"vrexp2.q", "?x3z,?s3y",	0xd01c8080, 0xffff8080, RD_C2,		0,		AL	},
+{"vrndi.q", "?d3z",		0xd0218080, 0xffffff80, RD_C2,		0,		AL	},
+{"vrndf1.q", "?d3z",		0xd0228080, 0xffffff80, RD_C2,		0,		AL	},
+{"vrndf2.q", "?d3z",		0xd0238080, 0xffffff80, RD_C2,		0,		AL	},
+{"vf2h.q",  "?d1m,?s3s",	0xd0328080, 0xffff8080, RD_C2,		0,		AL	},
+{"vsrt1.q", "?d3d,?s3s",	0xd0408080, 0xffff8080, RD_C2,		0,		AL	},
+{"vsrt2.q", "?d3d,?s3s",	0xd0418080, 0xffff8080, RD_C2,		0,		AL	},
+{"vsrt3.q", "?d3d,?s3s",	0xd0488080, 0xffff8080, RD_C2,		0,		AL	},
+{"vsrt4.q", "?d3d,?s3s",	0xd0498080, 0xffff8080, RD_C2,		0,		AL	},
+{"vbfy1.q", "?d3d,?s3s",	0xd0428080, 0xffff8080, RD_C2,		0,		AL	},
+{"vbfy2.q", "?d3d,?s3s",	0xd0438080, 0xffff8080, RD_C2,		0,		AL	},
+{"vocp.q",  "?d3d,?s3y",	0xd0448080, 0xffff8080, RD_C2,		0,		AL	},
+{"vfad.q",  "?d0d,?s3s",	0xd0468080, 0xffff8080, RD_C2,		0,		AL	},
+{"vavg.q",  "?d0d,?s3s",	0xd0478080, 0xffff8080, RD_C2,		0,		AL	},
+{"vf2in.q", "?d3m,?s3s,?b",	0xd2008080, 0xffe08080, RD_C2,		0,		AL	},
+{"vf2iz.q", "?d3m,?s3s,?b",	0xd2208080, 0xffe08080, RD_C2,		0,		AL	},
+{"vf2iu.q", "?d3m,?s3s,?b",	0xd2408080, 0xffe08080, RD_C2,		0,		AL	},
+{"vf2id.q", "?d3m,?s3s,?b",	0xd2608080, 0xffe08080, RD_C2,		0,		AL	},
+{"vi2f.q",  "?d3d,?s3w,?b",	0xd2808080, 0xffe08080, RD_C2,		0,		AL	},
+{"vcmov.q", "?d3d,?s3s,?e",	0,    (int) M_VCMOVQ,	INSN_MACRO,	0,		AL	},
+{"vcmovt.q", "?d3d,?s3s,?e",	0xd2a08080, 0xfff88080, RD_C2,		0,		AL	},
+{"vcmovf.q", "?d3d,?s3s,?e",	0xd2a88080, 0xfff88080, RD_C2,		0,		AL	},
+{"vmmul.q", "?v7z,?s7y,?t7x",	0xf0008080, 0xff808080, RD_C2,		0,		AL	},
+{"vtfm4.q", "?v3z,?s7y,?t3x",	0xf1808080, 0xff808080, RD_C2,		0,		AL	},
+{"vhtfm4.q", "?v3z,?s7y,?t3x",	0xf1808000, 0xff808080, RD_C2,		0,		AL	},
+{"vmscl.q", "?x7z,?s7y,?t0x",	0xf2008080, 0xff808080, RD_C2,		0,		AL	},
+{"vqmul.q", "?v3z,?s3y,?t3x",	0xf2808080, 0xff808080, RD_C2,		0,		AL	},
+{"vmmov.q", "?x7z,?s7y",	0xf3808080, 0xffff8080, RD_C2,		0,		AL	},
+{"vmidt.q", "?d7z",		0xf3838080, 0xffffff80, RD_C2,		0,		AL	},
+{"vmzero.q", "?d7z",		0xf3868080, 0xffffff80, RD_C2,		0,		AL	},
+{"vmone.q", "?d7z",		0xf3878080, 0xffffff80, RD_C2,		0,		AL	},
+{"vrot.q",  "?x3z,?s0y,?w",	0xf3a08080, 0xffe08080, RD_C2,		0,		AL	},
+{"vt4444.q", "?d1z,?s3w",	0xd0598080, 0xffff8080, RD_C2,		0,		AL	},
+{"vt5551.q", "?d1z,?s3w",	0xd05a8080, 0xffff8080, RD_C2,		0,		AL	},
+{"vt5650.q", "?d1z,?s3w",	0xd05b8080, 0xffff8080, RD_C2,		0,		AL	},
+{"vadd.t",  "?d2d,?s2s,?t2t",	0x60008000, 0xff808080, RD_C2,		0,		AL	},
+{"vsub.t",  "?d2d,?s2s,?t2t",	0x60808000, 0xff808080, RD_C2,		0,		AL	},
+{"vdiv.t",  "?x2z,?s2y,?t2x",	0x63808000, 0xff808080, RD_C2,		0,		AL	},
+{"vmul.t",  "?d2d,?s2s,?t2t",	0x64008000, 0xff808080, RD_C2,		0,		AL	},
+{"vdot.t",  "?d0d,?s2s,?t2t",	0x64808000, 0xff808080, RD_C2,		0,		AL	},
+{"vscl.t",  "?d2d,?s2s,?t0x",	0x65008000, 0xff808080, RD_C2,		0,		AL	},
+{"vhdp.t",  "?d0d,?s2y,?t2t",	0x66008000, 0xff808080, RD_C2,		0,		AL	},
+{"vcrs.t",  "?d2d,?s2y,?t2x",	0x66808000, 0xff808080, RD_C2,		0,		AL	},
+{"vcmp.t",  "?f2,?s2s,?t2t",	0x6c008000, 0xff8080f0, RD_C2,		0,		AL	},
+{"vcmp.t",  "?f1,?s2s",		0x6c008000, 0xffff80f0, RD_C2,		0,		AL	},
+{"vcmp.t",  "?f0",		0x6c008000, 0xfffffff0, RD_C2,		0,		AL	},
+{"vmin.t",  "?d2d,?s2s,?t2t",	0x6d008000, 0xff808080, RD_C2,		0,		AL	},
+{"vmax.t",  "?d2d,?s2s,?t2t",	0x6d808000, 0xff808080, RD_C2,		0,		AL	},
+{"vsgn.t",  "?d2d,?s2s",	0xd04a8000, 0xffff8080, RD_C2,		0,		AL	},
+{"vcst.t",  "?d2d,?a",		0xd0608000, 0xffe0ff80, RD_C2,		0,		AL	},
+{"vscmp.t", "?d2d,?s2s,?t2t",	0x6e808000, 0xff808080, RD_C2,		0,		AL	},
+{"vsge.t",  "?d2d,?s2s,?t2t",	0x6f008000, 0xff808080, RD_C2,		0,		AL	},
+{"vslt.t",  "?d2d,?s2s,?t2t",	0x6f808000, 0xff808080, RD_C2,		0,		AL	},
+{"vmov.t",  "?d2d,?s2s",	0xd0008000, 0xffff8080, RD_C2,		0,		AL	},
+{"vabs.t",  "?d2d,?s2w",	0xd0018000, 0xffff8080, RD_C2,		0,		AL	},
+{"vneg.t",  "?d2d,?s2w",	0xd0028000, 0xffff8080, RD_C2,		0,		AL	},
+{"vsat0.t", "?d2z,?s2s",	0xd0048000, 0xffff8080, RD_C2,		0,		AL	},
+{"vsat1.t", "?d2z,?s2s",	0xd0058000, 0xffff8080, RD_C2,		0,		AL	},
+{"vzero.t", "?d2d",		0xd0068000, 0xffffff80, RD_C2,		0,		AL	},
+{"vone.t",  "?d2d",		0xd0078000, 0xffffff80, RD_C2,		0,		AL	},
+{"vrcp.t",  "?x2z,?s2y",	0xd0108000, 0xffff8080, RD_C2,		0,		AL	},
+{"vrsq.t",  "?x2z,?s2y",	0xd0118000, 0xffff8080, RD_C2,		0,		AL	},
+{"vsin.t",  "?x2z,?s2y",	0xd0128000, 0xffff8080, RD_C2,		0,		AL	},
+{"vcos.t",  "?x2z,?s2y",	0xd0138000, 0xffff8080, RD_C2,		0,		AL	},
+{"vexp2.t", "?x2z,?s2y",	0xd0148000, 0xffff8080, RD_C2,		0,		AL	},
+{"vlog2.t", "?x2z,?s2y",	0xd0158000, 0xffff8080, RD_C2,		0,		AL	},
+{"vsqrt.t", "?x2z,?s2y",	0xd0168000, 0xffff8080, RD_C2,		0,		AL	},
+{"vasin.t", "?x2z,?s2y",	0xd0178000, 0xffff8080, RD_C2,		0,		AL	},
+{"vnrcp.t", "?x2z,?s2y",	0xd0188000, 0xffff8080, RD_C2,		0,		AL	},
+{"vnsin.t", "?x2z,?s2y",	0xd01a8000, 0xffff8080, RD_C2,		0,		AL	},
+{"vrexp2.t", "?x2z,?s2y",	0xd01c8000, 0xffff8080, RD_C2,		0,		AL	},
+{"vrndi.t", "?d2z",		0xd0218000, 0xffffff80, RD_C2,		0,		AL	},
+{"vrndf1.t", "?d2z",		0xd0228000, 0xffffff80, RD_C2,		0,		AL	},
+{"vrndf2.t", "?d2z",		0xd0238000, 0xffffff80, RD_C2,		0,		AL	},
+{"vocp.t",  "?d2d,?s2y",	0xd0448000, 0xffff8080, RD_C2,		0,		AL	},
+{"vfad.t",  "?d0d,?s2s",	0xd0468000, 0xffff8080, RD_C2,		0,		AL	},
+{"vavg.t",  "?d0d,?s2s",	0xd0478000, 0xffff8080, RD_C2,		0,		AL	},
+{"vf2in.t", "?d2m,?s2s,?b",	0xd2008000, 0xffe08080, RD_C2,		0,		AL	},
+{"vf2iz.t", "?d2m,?s2s,?b",	0xd2208000, 0xffe08080, RD_C2,		0,		AL	},
+{"vf2iu.t", "?d2m,?s2s,?b",	0xd2408000, 0xffe08080, RD_C2,		0,		AL	},
+{"vf2id.t", "?d2m,?s2s,?b",	0xd2608000, 0xffe08080, RD_C2,		0,		AL	},
+{"vi2f.t",  "?d2d,?s2w,?b",	0xd2808000, 0xffe08080, RD_C2,		0,		AL	},
+{"vcmov.t", "?d2d,?s2s,?e",	0,    (int) M_VCMOVT,	INSN_MACRO,	0,		AL	},
+{"vcmovt.t", "?d2d,?s2s,?e",	0xd2a08000, 0xfff88080, RD_C2,		0,		AL	},
+{"vcmovf.t", "?d2d,?s2s,?e",	0xd2a88000, 0xfff88080, RD_C2,		0,		AL	},
+{"vmmul.t", "?v6z,?s6y,?t6x",	0xf0008000, 0xff808080, RD_C2,		0,		AL	},
+{"vtfm3.t", "?v2z,?s6y,?t2x",	0xf1008000, 0xff808080, RD_C2,		0,		AL	},
+{"vhtfm3.t", "?v2z,?s6y,?t2x",	0xf1000080, 0xff808080, RD_C2,		0,		AL	},
+{"vmscl.t", "?x6z,?s6y,?t0x",	0xf2008000, 0xff808080, RD_C2,		0,		AL	},
+{"vmmov.t", "?x6z,?s6y",	0xf3808000, 0xffff8080, RD_C2,		0,		AL	},
+{"vmidt.t", "?d6z",		0xf3838000, 0xffffff80, RD_C2,		0,		AL	},
+{"vmzero.t", "?d6z",		0xf3868000, 0xffffff80, RD_C2,		0,		AL	},
+{"vmone.t", "?d6z",		0xf3878000, 0xffffff80, RD_C2,		0,		AL	},
+{"vrot.t",  "?x2z,?s0y,?w",	0xf3a08000, 0xffe08080, RD_C2,		0,		AL	},
+{"vcrsp.t", "?d2z,?s2y,?t2x",	0xf2808000, 0xff808080, RD_C2,		0,		AL	},
+{"vadd.p",  "?d1d,?s1s,?t1t",	0x60000080, 0xff808080, RD_C2,		0,		AL	},
+{"vsub.p",  "?d1d,?s1s,?t1t",	0x60800080, 0xff808080, RD_C2,		0,		AL	},
+{"vdiv.p",  "?x1z,?s1y,?t1x",	0x63800080, 0xff808080, RD_C2,		0,		AL	},
+{"vmul.p",  "?d1d,?s1s,?t1t",	0x64000080, 0xff808080, RD_C2,		0,		AL	},
+{"vdot.p",  "?d0d,?s1s,?t1t",	0x64800080, 0xff808080, RD_C2,		0,		AL	},
+{"vscl.p",  "?d1d,?s1s,?t0x",	0x65000080, 0xff808080, RD_C2,		0,		AL	},
+{"vhdp.p",  "?d0d,?s1y,?t1t",	0x66000080, 0xff808080, RD_C2,		0,		AL	},
+{"vdet.p",  "?d0d,?s1s,?t1x",	0x67000080, 0xff808080, RD_C2,		0,		AL	},
+{"vcmp.p",  "?f2,?s1s,?t1t",	0x6c000080, 0xff8080f0, RD_C2,		0,		AL	},
+{"vcmp.p",  "?f1,?s1s",		0x6c000080, 0xffff80f0, RD_C2,		0,		AL	},
+{"vcmp.p",  "?f0",		0x6c000080, 0xfffffff0, RD_C2,		0,		AL	},
+{"vmin.p",  "?d1d,?s1s,?t1t",	0x6d000080, 0xff808080, RD_C2,		0,		AL	},
+{"vmax.p",  "?d1d,?s1s,?t1t",	0x6d800080, 0xff808080, RD_C2,		0,		AL	},
+{"vsgn.p",  "?d1d,?s1s",	0xd04a0080, 0xffff8080, RD_C2,		0,		AL	},
+{"vcst.p",  "?d1d,?a",		0xd0600080, 0xffe0ff80, RD_C2,		0,		AL	},
+{"vscmp.p", "?d1d,?s1s,?t1t",	0x6e800080, 0xff808080, RD_C2,		0,		AL	},
+{"vsge.p",  "?d1d,?s1s,?t1t",	0x6f000080, 0xff808080, RD_C2,		0,		AL	},
+{"vslt.p",  "?d1d,?s1s,?t1t",	0x6f800080, 0xff808080, RD_C2,		0,		AL	},
+{"vus2i.p", "?d3m,?s1y",	0xd03a0080, 0xffff8080, RD_C2,		0,		AL	},
+{"vs2i.p",  "?d3m,?s1y",	0xd03b0080, 0xffff8080, RD_C2,		0,		AL	},
+{"vi2us.p", "?d0m,?s1w",	0xd03e0080, 0xffff8080, RD_C2,		0,		AL	},
+{"vi2s.p",  "?d0m,?s1w",	0xd03f0080, 0xffff8080, RD_C2,		0,		AL	},
+{"vmov.p",  "?d1d,?s1s",	0xd0000080, 0xffff8080, RD_C2,		0,		AL	},
+{"vabs.p",  "?d1d,?s1w",	0xd0010080, 0xffff8080, RD_C2,		0,		AL	},
+{"vneg.p",  "?d1d,?s1w",	0xd0020080, 0xffff8080, RD_C2,		0,		AL	},
+{"vidt.p",  "?d1d",		0xd0030080, 0xffffff80, RD_C2,		0,		AL	},
+{"vsat0.p", "?d1z,?s1s",	0xd0040080, 0xffff8080, RD_C2,		0,		AL	},
+{"vsat1.p", "?d1z,?s1s",	0xd0050080, 0xffff8080, RD_C2,		0,		AL	},
+{"vzero.p", "?d1d",		0xd0060080, 0xffffff80, RD_C2,		0,		AL	},
+{"vone.p",  "?d1d",		0xd0070080, 0xffffff80, RD_C2,		0,		AL	},
+{"vrcp.p",  "?x1z,?s1y",	0xd0100080, 0xffff8080, RD_C2,		0,		AL	},
+{"vrsq.p",  "?x1z,?s1y",	0xd0110080, 0xffff8080, RD_C2,		0,		AL	},
+{"vsin.p",  "?x1z,?s1y",	0xd0120080, 0xffff8080, RD_C2,		0,		AL	},
+{"vcos.p",  "?x1z,?s1y",	0xd0130080, 0xffff8080, RD_C2,		0,		AL	},
+{"vexp2.p", "?x1z,?s1y",	0xd0140080, 0xffff8080, RD_C2,		0,		AL	},
+{"vlog2.p", "?x1z,?s1y",	0xd0150080, 0xffff8080, RD_C2,		0,		AL	},
+{"vsqrt.p", "?x1z,?s1y",	0xd0160080, 0xffff8080, RD_C2,		0,		AL	},
+{"vasin.p", "?x1z,?s1y",	0xd0170080, 0xffff8080, RD_C2,		0,		AL	},
+{"vnrcp.p", "?x1z,?s1y",	0xd0180080, 0xffff8080, RD_C2,		0,		AL	},
+{"vnsin.p", "?x1z,?s1y",	0xd01a0080, 0xffff8080, RD_C2,		0,		AL	},
+{"vrexp2.p", "?x1z,?s1y",	0xd01c0080, 0xffff8080, RD_C2,		0,		AL	},
+{"vrndi.p", "?d1z",		0xd0210080, 0xffffff80, RD_C2,		0,		AL	},
+{"vrndf1.p", "?d1z",		0xd0220080, 0xffffff80, RD_C2,		0,		AL	},
+{"vrndf2.p", "?d1z",		0xd0230080, 0xffffff80, RD_C2,		0,		AL	},
+{"vf2h.p",  "?d0m,?s1s",	0xd0320080, 0xffff8080, RD_C2,		0,		AL	},
+{"vh2f.p",  "?d3d,?s1y",	0xd0330080, 0xffff8080, RD_C2,		0,		AL	},
+{"vbfy1.p", "?d1d,?s1s",	0xd0420080, 0xffff8080, RD_C2,		0,		AL	},
+{"vocp.p",  "?d1d,?s1y",	0xd0440080, 0xffff8080, RD_C2,		0,		AL	},
+{"vsocp.p", "?d3z,?s1y",	0xd0450080, 0xffff8080, RD_C2,		0,		AL	},
+{"vfad.p",  "?d0d,?s1s",	0xd0460080, 0xffff8080, RD_C2,		0,		AL	},
+{"vavg.p",  "?d0d,?s1s",	0xd0470080, 0xffff8080, RD_C2,		0,		AL	},
+{"vf2in.p", "?d1m,?s1s,?b",	0xd2000080, 0xffe08080, RD_C2,		0,		AL	},
+{"vf2iz.p", "?d1m,?s1s,?b",	0xd2200080, 0xffe08080, RD_C2,		0,		AL	},
+{"vf2iu.p", "?d1m,?s1s,?b",	0xd2400080, 0xffe08080, RD_C2,		0,		AL	},
+{"vf2id.p", "?d1m,?s1s,?b",	0xd2600080, 0xffe08080, RD_C2,		0,		AL	},
+{"vi2f.p",  "?d1d,?s1w,?b",	0xd2800080, 0xffe08080, RD_C2,		0,		AL	},
+{"vcmov.p", "?d1d,?s1s,?e",	0,    (int) M_VCMOVP,	INSN_MACRO,	0,		AL	},
+{"vcmovt.p", "?d1d,?s1s,?e",	0xd2a00080, 0xfff88080, RD_C2,		0,		AL	},
+{"vcmovf.p", "?d1d,?s1s,?e",	0xd2a80080, 0xfff88080, RD_C2,		0,		AL	},
+{"vmmul.p", "?v5z,?s5y,?t5x",	0xf0000080, 0xff808080, RD_C2,		0,		AL	},
+{"vtfm2.p", "?v1z,?s5y,?t1x",	0xf0800080, 0xff808080, RD_C2,		0,		AL	},
+{"vhtfm2.p", "?v1z,?s5y,?t1x",	0xf0800000, 0xff808080, RD_C2,		0,		AL	},
+{"vmscl.p", "?x5z,?s5y,?t0x",	0xf2000080, 0xff808080, RD_C2,		0,		AL	},
+{"vmmov.p", "?x5z,?s5y",	0xf3800080, 0xffff8080, RD_C2,		0,		AL	},
+{"vmidt.p", "?d5z",		0xf3830080, 0xffffff80, RD_C2,		0,		AL	},
+{"vmzero.p", "?d5z",		0xf3860080, 0xffffff80, RD_C2,		0,		AL	},
+{"vmone.p", "?d5z",		0xf3870080, 0xffffff80, RD_C2,		0,		AL	},
+{"vrot.p",  "?x1z,?s0y,?w",	0xf3a00080, 0xffe08080, RD_C2,		0,		AL	},
+{"vadd.s",  "?d0d,?s0s,?t0t",	0x60000000, 0xff808080, RD_C2,		0,		AL	},
+{"vsub.s",  "?d0d,?s0s,?t0t",	0x60800000, 0xff808080, RD_C2,		0,		AL	},
+{"vdiv.s",  "?x0d,?s0s,?t0t",	0x63800000, 0xff808080, RD_C2,		0,		AL	},
+{"vmul.s",  "?d0d,?s0s,?t0t",	0x64000000, 0xff808080, RD_C2,		0,		AL	},
+{"vcmp.s",  "?f2,?s0s,?t0t",	0x6c000000, 0xff8080f0, RD_C2,		0,		AL	},
+{"vcmp.s",  "?f1,?s0s",		0x6c000000, 0xffff80f0, RD_C2,		0,		AL	},
+{"vcmp.s",  "?f0",		0x6c000000, 0xfffffff0, RD_C2,		0,		AL	},
+{"vmin.s",  "?d0d,?s0s,?t0t",	0x6d000000, 0xff808080, RD_C2,		0,		AL	},
+{"vmax.s",  "?d0d,?s0s,?t0t",	0x6d800000, 0xff808080, RD_C2,		0,		AL	},
+{"vsgn.s",  "?d0d,?s0s",	0xd04a0000, 0xffff8080, RD_C2,		0,		AL	},
+{"vcst.s",  "?d0d,?a",		0xd0600000, 0xffe0ff80, RD_C2,		0,		AL	},
+{"vscmp.s", "?d0d,?s0s,?t0t",	0x6e800000, 0xff808080, RD_C2,		0,		AL	},
+{"vsge.s",  "?d0d,?s0s,?t0t",	0x6f000000, 0xff808080, RD_C2,		0,		AL	},
+{"vslt.s",  "?d0d,?s0s,?t0t",	0x6f800000, 0xff808080, RD_C2,		0,		AL	},
+{"vus2i.s", "?d1m,?s0y",	0xd03a0000, 0xffff8080, RD_C2,		0,		AL	},
+{"vs2i.s",  "?d1m,?s0y",	0xd03b0000, 0xffff8080, RD_C2,		0,		AL	},
+{"vmov.s",  "?d0d,?s0s",	0xd0000000, 0xffff8080, RD_C2,		0,		AL	},
+{"vabs.s",  "?d0d,?s0w",	0xd0010000, 0xffff8080, RD_C2,		0,		AL	},
+{"vneg.s",  "?d0d,?s0w",	0xd0020000, 0xffff8080, RD_C2,		0,		AL	},
+{"vsat0.s", "?d0z,?s0s",	0xd0040000, 0xffff8080, RD_C2,		0,		AL	},
+{"vsat1.s", "?d0z,?s0s",	0xd0050000, 0xffff8080, RD_C2,		0,		AL	},
+{"vzero.s", "?d0d",		0xd0060000, 0xffffff80, RD_C2,		0,		AL	},
+{"vone.s",  "?d0d",		0xd0070000, 0xffffff80, RD_C2,		0,		AL	},
+{"vrcp.s",  "?x0d,?s0s",	0xd0100000, 0xffff8080, RD_C2,		0,		AL	},
+{"vrsq.s",  "?x0d,?s0s",	0xd0110000, 0xffff8080, RD_C2,		0,		AL	},
+{"vsin.s",  "?x0d,?s0s",	0xd0120000, 0xffff8080, RD_C2,		0,		AL	},
+{"vcos.s",  "?x0d,?s0s",	0xd0130000, 0xffff8080, RD_C2,		0,		AL	},
+{"vexp2.s", "?x0d,?s0s",	0xd0140000, 0xffff8080, RD_C2,		0,		AL	},
+{"vlog2.s", "?x0d,?s0s",	0xd0150000, 0xffff8080, RD_C2,		0,		AL	},
+{"vsqrt.s", "?x0d,?s0s",	0xd0160000, 0xffff8080, RD_C2,		0,		AL	},
+{"vasin.s", "?x0d,?s0s",	0xd0170000, 0xffff8080, RD_C2,		0,		AL	},
+{"vnrcp.s", "?x0d,?s0y",	0xd0180000, 0xffff8080, RD_C2,		0,		AL	},
+{"vnsin.s", "?x0d,?s0y",	0xd01a0000, 0xffff8080, RD_C2,		0,		AL	},
+{"vrexp2.s", "?x0d,?s0y",	0xd01c0000, 0xffff8080, RD_C2,		0,		AL	},
+{"vrnds.s", "?s0y",		0xd0200000, 0xffff80ff, RD_C2,		0,		AL	},
+{"vrndi.s", "?d0d",		0xd0210000, 0xffffff80, RD_C2,		0,		AL	},
+{"vrndf1.s", "?d0d",		0xd0220000, 0xffffff80, RD_C2,		0,		AL	},
+{"vrndf2.s", "?d0d",		0xd0230000, 0xffffff80, RD_C2,		0,		AL	},
+{"vh2f.s",  "?d1d,?s0y",	0xd0330000, 0xffff8080, RD_C2,		0,		AL	},
+{"vsbz.s",  "?d0d,?s0s",	0xd0360000, 0xffff8080, RD_C2,		0,		AL	},
+{"vsbn.s",  "?d0d,?s0s,?t0t",	0x61000000, 0xff808080, RD_C2,		0,		AL	},
+{"vlgb.s",  "?d0d,?s0s",	0xd0370000, 0xffff8080, RD_C2,		0,		AL	},
+{"vocp.s",  "?d0d,?s0y",	0xd0440000, 0xffff8080, RD_C2,		0,		AL	},
+{"vsocp.s", "?d1z,?s0y",	0xd0450000, 0xffff8080, RD_C2,		0,		AL	},
+{"vf2in.s", "?d0m,?s0s,?b",	0xd2000000, 0xffe08080, RD_C2,		0,		AL	},
+{"vf2iz.s", "?d0m,?s0s,?b",	0xd2200000, 0xffe08080, RD_C2,		0,		AL	},
+{"vf2iu.s", "?d0m,?s0s,?b",	0xd2400000, 0xffe08080, RD_C2,		0,		AL	},
+{"vf2id.s", "?d0m,?s0s,?b",	0xd2600000, 0xffe08080, RD_C2,		0,		AL	},
+{"vi2f.s",  "?d0d,?s0w,?b",	0xd2800000, 0xffe08080, RD_C2,		0,		AL	},
+{"vcmov.s", "?d0d,?s0s,?e",	0,    (int) M_VCMOVS,	INSN_MACRO,	0,		AL	},
+{"vcmovt.s", "?d0d,?s0s,?e",	0xd2a00000, 0xfff88080, RD_C2,		0,		AL	},
+{"vcmovf.s", "?d0d,?s0s,?e",	0xd2a80000, 0xfff88080, RD_C2,		0,		AL	},
+{"vwbn.s",  "?d0d,?s0s,?i",	0xd3000000, 0xff008080, RD_C2,		0,		AL	},
+{"vpfxs",   "?0,?1,?2,?3",	0xdc000000, 0xff000000, RD_C2,		0,		AL	},
+{"vpfxt",   "?0,?1,?2,?3",	0xdd000000, 0xff000000, RD_C2,		0,		AL	},
+{"vpfxd",   "?4,?5,?6,?7",	0xde000000, 0xff000000, RD_C2,		0,		AL	},
+{"viim.s",  "?t0d,j",		0xdf000000, 0xff800000, RD_C2,		0,		AL	},
+{"vfim.s",  "?t0d,?u",		0xdf800000, 0xff800000, RD_C2,		0,		AL	},
+{"vnop",    "",			0xffff0000, 0xffffffff, RD_C2,		0,		AL	},
+{"vflush",  "",			0xffff040d, 0xffffffff, RD_C2,		0,		AL	},
+{"vsync",   "",			0xffff0320, 0xffffffff, RD_C2,		0,		AL	},
+{"vsync",   "i",		0xffff0000, 0xffff0000, RD_C2,		0,		AL	},
+
 /* Coprocessor 2 move/branch operations overlap with VR5400 .ob format
    instructions so they are here for the latters to take precedence.  */
 {"bc2f",    "p",	0x49000000, 0xffff0000,	CBD|RD_CC,		0,		I1	},
@@ -1282,6 +1589,36 @@
 {"mtc2",    "t,G,H",	0x48800000, 0xffe007f8,	COD|RD_t|WR_C2|WR_CC,	0,		I32	},
 {"mthc2",   "t,i",	0x48e00000, 0xffe00000,	COD|RD_t|WR_C2|WR_CC,	0,		I33	},
 
+/* Coprocessor 2 load/store operations overlap with the Allegrex VFPU
+   instructions so they are here for the latters to take precedence.  */
+/* COP1 ldc1 and sdc1 and COP3 ldc3 and sdc3 also overlap with the VFPU.  */
+{"ldc1",    "T,o(b)",	0xd4000000, 0xfc000000, CLD|RD_b|WR_T|FP_D,	0,		I2	},
+{"ldc1",    "E,o(b)",	0xd4000000, 0xfc000000, CLD|RD_b|WR_T|FP_D,	0,		I2	},
+{"ldc1",    "T,A(b)",	0,    (int) M_LDC1_AB,	INSN_MACRO,		0,		I2	},
+{"ldc1",    "E,A(b)",	0,    (int) M_LDC1_AB,	INSN_MACRO,		0,		I2	},
+{"l.d",     "T,o(b)",	0xd4000000, 0xfc000000, CLD|RD_b|WR_T|FP_D,	0,		I2	}, /* ldc1 */
+{"l.d",     "T,o(b)",	0,    (int) M_L_DOB,	INSN_MACRO,		0,		I1	},
+{"l.d",     "T,A(b)",	0,    (int) M_L_DAB,	INSN_MACRO,		0,		I1	},
+{"ldc2",    "E,o(b)",	0xd8000000, 0xfc000000, CLD|RD_b|WR_CC,		0,		I2	},
+{"ldc2",    "E,A(b)",	0,    (int) M_LDC2_AB,	INSN_MACRO,		0,		I2	},
+{"ldc3",    "E,o(b)",	0xdc000000, 0xfc000000, CLD|RD_b|WR_CC,		0,		I2	},
+{"ldc3",    "E,A(b)",	0,    (int) M_LDC3_AB,	INSN_MACRO,		0,		I2	},
+{"lwc2",    "E,o(b)",	0xc8000000, 0xfc000000,	CLD|RD_b|WR_CC,		0,		I1	},
+{"lwc2",    "E,A(b)",	0,    (int) M_LWC2_AB,	INSN_MACRO,		0,		I1	},
+{"sdc1",    "T,o(b)",	0xf4000000, 0xfc000000, SM|RD_T|RD_b|FP_D,	0,		I2	},
+{"sdc1",    "E,o(b)",	0xf4000000, 0xfc000000, SM|RD_T|RD_b|FP_D,	0,		I2	},
+{"sdc1",    "T,A(b)",	0,    (int) M_SDC1_AB,	INSN_MACRO,		0,		I2	},
+{"sdc1",    "E,A(b)",	0,    (int) M_SDC1_AB,	INSN_MACRO,		0,		I2	},
+{"s.d",     "T,o(b)",	0xf4000000, 0xfc000000, SM|RD_T|RD_b|FP_D,	0,		I2	},
+{"s.d",     "T,o(b)",	0,    (int) M_S_DOB,	INSN_MACRO,		0,		I1	},
+{"s.d",     "T,A(b)",	0,    (int) M_S_DAB,	INSN_MACRO,		0,		I1	},
+{"sdc2",    "E,o(b)",	0xf8000000, 0xfc000000, SM|RD_C2|RD_b,		0,		I2	},
+{"sdc2",    "E,A(b)",	0,    (int) M_SDC2_AB,	INSN_MACRO,		0,		I2	},
+{"sdc3",    "E,o(b)",	0xfc000000, 0xfc000000, SM|RD_C3|RD_b,		0,		I2	},
+{"sdc3",    "E,A(b)",	0,    (int) M_SDC3_AB,	INSN_MACRO,		0,		I2	},
+{"swc2",    "E,o(b)",	0xe8000000, 0xfc000000,	SM|RD_C2|RD_b,		0,		I1	},
+{"swc2",    "E,A(b)",	0,    (int) M_SWC2_AB,	INSN_MACRO,		0,		I1	},
+
 /* No hazard protection on coprocessor instructions--they shouldn't
    change the state of the processor and if they do it's up to the
    user to put in nops as necessary.  These are at the end so that the
