--- src/extension/internal/pdfinput/pdf-parser.cpp	2008/03/29 09:49:50	18077
+++ src/extension/internal/pdfinput/pdf-parser.cpp	2008/06/12 18:14:25	18894
@@ -2191,6 +2191,151 @@
   }
 }
 
+
+#if 1
+
+/**
+ * This is for the change to GfxFont's getNextChar() call.
+ * Thanks to tsdgeos for the fix.
+ * Miklos, does this look ok?
+ */   
+
+void PdfParser::doShowText(GooString *s) {
+  GfxFont *font;
+  int wMode;
+  double riseX, riseY;
+  CharCode code;
+  Unicode *u = NULL;
+  double x, y, dx, dy, dx2, dy2, curX, curY, tdx, tdy, lineX, lineY;
+  double originX, originY, tOriginX, tOriginY;
+  double oldCTM[6], newCTM[6];
+  double *mat;
+  Object charProc;
+  Dict *resDict;
+  Parser *oldParser;
+  char *p;
+  int len, n, uLen, nChars, nSpaces, i;
+
+  font = state->getFont();
+  wMode = font->getWMode();
+
+  builder->beginString(state, s);
+
+  // handle a Type 3 char
+  if (font->getType() == fontType3 && 0) {//out->interpretType3Chars()) {
+    mat = state->getCTM();
+    for (i = 0; i < 6; ++i) {
+      oldCTM[i] = mat[i];
+    }
+    mat = state->getTextMat();
+    newCTM[0] = mat[0] * oldCTM[0] + mat[1] * oldCTM[2];
+    newCTM[1] = mat[0] * oldCTM[1] + mat[1] * oldCTM[3];
+    newCTM[2] = mat[2] * oldCTM[0] + mat[3] * oldCTM[2];
+    newCTM[3] = mat[2] * oldCTM[1] + mat[3] * oldCTM[3];
+    mat = font->getFontMatrix();
+    newCTM[0] = mat[0] * newCTM[0] + mat[1] * newCTM[2];
+    newCTM[1] = mat[0] * newCTM[1] + mat[1] * newCTM[3];
+    newCTM[2] = mat[2] * newCTM[0] + mat[3] * newCTM[2];
+    newCTM[3] = mat[2] * newCTM[1] + mat[3] * newCTM[3];
+    newCTM[0] *= state->getFontSize();
+    newCTM[1] *= state->getFontSize();
+    newCTM[2] *= state->getFontSize();
+    newCTM[3] *= state->getFontSize();
+    newCTM[0] *= state->getHorizScaling();
+    newCTM[2] *= state->getHorizScaling();
+    state->textTransformDelta(0, state->getRise(), &riseX, &riseY);
+    curX = state->getCurX();
+    curY = state->getCurY();
+    lineX = state->getLineX();
+    lineY = state->getLineY();
+    oldParser = parser;
+    p = s->getCString();
+    len = s->getLength();
+    while (len > 0) {
+      n = font->getNextChar(p, len, &code,
+			    &u, &uLen,
+			    &dx, &dy, &originX, &originY);
+      dx = dx * state->getFontSize() + state->getCharSpace();
+      if (n == 1 && *p == ' ') {
+	dx += state->getWordSpace();
+      }
+      dx *= state->getHorizScaling();
+      dy *= state->getFontSize();
+      state->textTransformDelta(dx, dy, &tdx, &tdy);
+      state->transform(curX + riseX, curY + riseY, &x, &y);
+      saveState();
+      state->setCTM(newCTM[0], newCTM[1], newCTM[2], newCTM[3], x, y);
+      //~ the CTM concat values here are wrong (but never used)
+      //out->updateCTM(state, 1, 0, 0, 1, 0, 0);
+      if (0){ /*!out->beginType3Char(state, curX + riseX, curY + riseY, tdx, tdy,
+			       code, u, uLen)) {*/
+	((Gfx8BitFont *)font)->getCharProc(code, &charProc);
+	if ((resDict = ((Gfx8BitFont *)font)->getResources())) {
+	  pushResources(resDict);
+	}
+	if (charProc.isStream()) {
+	  //parse(&charProc, gFalse); // TODO: parse into SVG font
+	} else {
+	  error(getPos(), "Missing or bad Type3 CharProc entry");
+	}
+	//out->endType3Char(state);
+	if (resDict) {
+	  popResources();
+	}
+	charProc.free();
+      }
+      restoreState();
+      // GfxState::restore() does *not* restore the current position,
+      // so we deal with it here using (curX, curY) and (lineX, lineY)
+      curX += tdx;
+      curY += tdy;
+      state->moveTo(curX, curY);
+      state->textSetPos(lineX, lineY);
+      p += n;
+      len -= n;
+    }
+    parser = oldParser;
+
+  } else {
+    state->textTransformDelta(0, state->getRise(), &riseX, &riseY);
+    p = s->getCString();
+    len = s->getLength();
+    while (len > 0) {
+      n = font->getNextChar(p, len, &code,
+			    &u, &uLen,
+			    &dx, &dy, &originX, &originY);
+      
+      if (wMode) {
+	dx *= state->getFontSize();
+	dy = dy * state->getFontSize() + state->getCharSpace();
+	if (n == 1 && *p == ' ') {
+	  dy += state->getWordSpace();
+	}
+      } else {
+	dx = dx * state->getFontSize() + state->getCharSpace();
+	if (n == 1 && *p == ' ') {
+	  dx += state->getWordSpace();
+	}
+	dx *= state->getHorizScaling();
+	dy *= state->getFontSize();
+      }
+      state->textTransformDelta(dx, dy, &tdx, &tdy);
+      originX *= state->getFontSize();
+      originY *= state->getFontSize();
+      state->textTransformDelta(originX, originY, &tOriginX, &tOriginY);
+      builder->addChar(state, state->getCurX() + riseX, state->getCurY() + riseY,
+                       dx, dy, tOriginX, tOriginY, code, n, u, uLen);
+      state->shift(tdx, tdy);
+      p += n;
+      len -= n;
+    }
+  }
+
+  builder->endString(state);
+}
+
+#else  /* !POPPLER_NEW_GFXFONT */
+
 void PdfParser::doShowText(GooString *s) {
   GfxFont *font;
   int wMode;
@@ -2325,6 +2470,9 @@
   builder->endString(state);
 }
 
+#endif /* POPPLER_NEW_GFXFONT */
+
+
 //------------------------------------------------------------------------
 // XObject operators
 //------------------------------------------------------------------------
